/*****************************************************************
 * fbrot.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * fbrot.c: Rotate image 90 degrees clockwise
 *
 * USAGE
 *     % fbrot < image1 > image2
 *
 * EDITLOG
 *     LastEditDate = Mon Jun 25 00:04:32 1990 - Michael Mauldin
 *     LastFileName = /usr2/mlm/src/misc/fbm/fbrot.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 22-Aug-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *     Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE \
  "Usage: fbrot [ -<type> ] [ -90 | -180 | -270 ] < image > image"

#ifndef lint
static char *fbmid =
"$FBM fbrot.c <1.0> 25-Jun-90  (C) 1989,1990 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
char *argv[];
{ FBM input, output;
  int outtype = -1, rot = 90;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      {
	case '9':	rot=90; SKIPARG; break;
	case '1':	rot=180; SKIPARG; break;
	case '2':	rot=270; SKIPARG; break;
	case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'L':	outtype = FMT_LEAF; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'R':	outtype = FMT_RLE; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
	default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }

  /* Clear the memory pointers so alloc_fbm won't be confused */
  input.cm  = input.bm  = (unsigned char *) NULL;
  output.cm = output.bm = (unsigned char *) NULL;

  /* Read the image and rotate it */
  if (read_bitmap (&input, (char *) NULL))
  { if (outtype < 0)
    { if (input.hdr.planes == 1 && input.hdr.bits == 1)
      { outtype = DEF_1BIT; }
      else
      { outtype = DEF_8BIT; }
    }

    if (rotate_fbm (&input, &output, rot) &&
        write_bitmap (&output, stdout, outtype))
    { exit (0); }
  }

  exit (1);
}
