/*****************************************************************
 * fbm2tga.c: FBM Release 1.0 25-Jun-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * fbm2tga.c: convert a bitmap to Targa format
 *
 * USAGE
 *	% fbm2tga [ image ] > image.tga
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:19:28 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/fbm2tga.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 23-Jun-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.95) mlm@cs.cmu.edu
 *	Bug fix due to Neil Crellin <neilc@natmlab.dms.oz.au>
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE\
"Usage: fbm2tga [ image ] > image.tga"

#ifndef lint
static char *fbmid =
"$FBM fbm2tga.c <1.0> 25-Jun-90  (C) 1989,1990 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc,argv)
int argc; char *argv[];
{ FBM image;

  /* Clear pointers */
  image.cm = image.bm = (unsigned char *) NULL;

  /* Read anything, write targa */
  if (read_bitmap (&image, (argc > 0) ? argv[1] : (char *) NULL) &&
      write_tga (&image, stdout))
  {
    exit (0);
  }
  else
  { exit (1); }
}
