/****************************************************************************\
*                                                                            *
*  THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE  *
*     WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR     *
*   PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.   *
*                                                                            *
*     In no event will the supplier be liable for any lost revenue           *
*   or profits or other special, indirect and consequential damages, even    *
*    if the supplier has been advised of the possibility of such damages.    *
*                                                                            *
*             Users may copy or modify this file without charge,             *
*       but are NOT authorized to license or sell it to anyone.              *
*                                                                            *
\****************************************************************************/

/****************************************************************************\
*                                                                            *
*    If you modify this software, you should include a notice giving the     *
* name of the person performing the modification, the date of modification,  *
* and the reason for such modification.  Bug reports or fixes should be sent *
*        to the author, who may or may not act on them as he desires:        *
*                                                                            *
* Internet: raytrace@cutmcvax.cs.curtin.edu.au                               *
*                                                                            *
* Mail   : School of Computer Science         | Tel: 619 351 7680            *
*          Curtin University of Technology    | Fax: 619 351 2819            *
*          Kent Street, Bentley                                              *
*          Western Australia, 6102                                           *
*                                                                            *
\****************************************************************************/

/*
 Copyright (c) 1990 Fred Parke.
 Modification: 1991 Andrew Marriott.
 */

#include <stdio.h>
#include <malloc.h>
#include "parameters.h"
Parameter parameter[MAX_PARAMETERS]
#if 1
;
#else
	=
	{
/*00*/		{ 0.0,	NULL,		0.0,	1.0,	0.0,	0},	
/*01*/		{ 0.9,	"eye opening",	0.0,	1.0,	0.0,	0},	
/*02*/		{ 0.5,	"eyebrow arch",	0.0,	1.0,	0.0,	0},	
/*03*/		{ 0.0,	"eyebrow sepn",	0.0,	25.0,	0.0,	0},	
/*04*/		{ 0.0,	"jaw rotation",	0.0,	20.0,	0.0,	0},	
/*05*/		{ 1.0,	"eyelid Yscl",	0.0,	1.0,	0.0,	0},	
/*06*/		{ 1.0,	"eyelid Zscl",	0.0,	1.0,	0.0,	0},	
/*07*/		{ 1.0,	"head Xscl",	0.0,	1.0,	0.0,	0},	
/*08*/		{ 1.0,	"head Yscl",	0.0,	1.0,	0.0,	0},	
/*09*/		{ 1.0,	"head Zscl",	0.0,	1.0,	0.0,	0},	
/*10*/	 	{ 1.0,	"nse tip Yscl",	0.0,	1.0,	0.0,	0},	
/*11*/	 	{ 1.0,	"nse brg Yscl",	0.0,	1.0,	0.0,	0},	
/*12*/	 	{ 1.0,	"mth Yscl",	0.0,	1.0,	0.0,	0},	
/*13*/	 	{ 1.0,	"mth interp",	0.0,	1.0,	0.0,	0},	
/*14*/	  	{ 0.0,	"mth Xoff",	0.0,	1.0,	0.0,	0},	
/*15*/	  	{ 0.0,	"287 Yoff",	0.0,	1.0,	0.0,	0},	
/*16*/	  	{ 0.0,	"mth cnr Xoff",	0.0,	1.0,	0.0,	0},	
/*17*/	  	{ 0.0,	"mth cnr Yoff",	0.0,	1.0,	0.0,	0},	
/*18*/	  	{ 0.0,	"mth cnr Zoff",	0.0,	1.0,	0.0,	0},	
/*19*/	 	{ 1.0,	"jaw Yscl",	0.0,	1.0,	0.0,	0},	
/*20*/	 	{ 1.0,	"cheek Yscl",	0.0,	1.0,	0.0,	0},	
/*21*/	  	{ 0.0,	"lwrlip ftuck",	0.0,	1.0,	0.0,	0},	
/*22*/	        {15.0,	"rse uplip",	0.0,	100,	0.0,	0},	
/*23*/	        {0.0,	NULL,		0.0,	1.0,	0.0,	0},	
/*24*/	        {0.0,	NULL,		0.0,	1.0,	0.0,	0},	
/*25*/	        {0.0,	NULL,		0.0,	1.0,	0.0,	0},	
/*26*/	  	{ 0.0,	"nse tip Xoff",	0.0,	1.0,	0.0,	0},	
/*27*/	  	{ 0.0,	"nse tip Zoff",	0.0,	1.0,	0.0,	0},	
/*28*/	  	{ 0.0,	"eyeball Xoff",	0.0,	1.0,	0.0,	0},	
/*29*/	  	{ 0.0,	"eyeball Yoff",	0.0,	1.0,	0.0,	0},	
/*30*/	        {-15.0,	"eyeball Zoff",	-30.0,	30.0,	0.0,	0},	
/*31*/	  	{ 0.0,	"chin Xoff",	0.0,	1.0,	0.0,	0},	
/*32*/	  	{ 0.0,	"chin Zoff",	0.0,	1.0,	0.0,	0},	
/*33*/	  	{ 0.0,	NULL,		0.0,	1.0,	0.0,	0},	
/*34*/	  	{ 0.0,	NULL,		0.0,	1.0,	0.0,	0},	
/*35*/	 	{ 1.0,	"chin/mth scl",	0.0,	1.0,	0.0,	0},	
/*36*/	 	{ 1.0,	"chin/eye scl",	0.0,	1.0,	0.0,	0},	
/*37*/	 	{ 1.0,	"eye/4head scl",	0.0,	1.0,	0.0,	0},	
/*38*/	  	{ 0.0,	"eyelid Xoff",	0.0,	1.0,	0.0,	0},	
/*39*/	  	{ 0.0,	"eyelid Yoff",	0.0,	1.0,	0.0,	0},	
/*40*/	  	{ 0.0,	"eyelid Zoff",	0.0,	1.0,	0.0,	0},	
/*41*/	  	{ 0.4,	"pupil frac",	0.0,	1.0,	0.0,	0},	
/*42*/	        {0.85,	"fringe frac",	0.0,	1.0,	0.0,	0},	
/*43*/	  	{ 0.4,	"iris frac",	0.0,	1.0,	0.0,	0},	
/*44*/	 	{ 70.,	"eyeball rad",	0.0,	100.0,	0.0,	0},	
/*45*/	 	{ 80.,	"eyelid rad",	0.0,	100.0,	0.0,	0},	
/*46*/	 	{ 0.0,	"growth factr",	0.0,	1.0,	0.0,	0},	
/*47*/	 	{ 0.0,	"teeth x off",	0.0,	1.0,	0.0,	0},	
/*48*/		{ 38.,	"teeth z off",	0.0,	100.0,	0.0,	0},	
/*49*/		{ 0.0,	NULL,		0.0,	1.0,	0.0,	0},	
/*50*/	 	{ 1.0,	"smoothness",	0.0,	1.0,	0.0,	0},
/*51*/	 	{ 3.0,	"dist to face",	1.0,	20.0,	0.0,	0},
/*52*/	 	{ 0.0,	"polar azim",	-180.0,	180.0,	0.0,	0},
/*53*/	 	{ 90.0,	"polar inc",	-180.0,	180.0,	0.0,	0},
/*54*/	 	{ 0.0,	"polar twist",	0.0,	360.0,	0.0,	0}
	};
#endif
read_params_file(filename)
char * filename;
{
int length,i;
FILE *fp, *fopen();
char line[80];
	if((fp = fopen(filename,"r")) == NULL)
	{
#ifdef FORMS
		if(forms_required)
			fl_show_message("Cannot open file ",filename,"Sorry");
		else
#endif
			fprintf(stderr,"Cannot open file %s. Sorry",filename);
		return(0);
	}
	for(i=0;i<MAX_PARAMETERS; i++)
	{
		length=fscanf(fp,"%*d %f %f %f %f %d",
		   &parameter[i].original,
		   &parameter[i].min,&parameter[i].max,
		   &parameter[i].value,&parameter[i].changed
		      );
		if(length != 5)
		{
#ifdef FORMS
			if(forms_required)
				fl_show_message("Ill formed param file ",filename,"Sorry");
			else
#endif
				fprintf(stderr,"Ill formed param file %s. Sorry",filename);
			return(0);
		}
		fgetc(fp);
		fgets(line,80,fp);
		length=strlen(line);
		if(length >1)
		{
			line[length-1]='\0';

			if(parameter[i].box_label)
				free(parameter[i].box_label);/**/
			parameter[i].box_label=malloc((unsigned int) length);
			strcpy(parameter[i].box_label,line);
		}
	}
	fclose(fp);
	return(1);
}

#ifdef FORMS
save_params_file(filename)
char * filename;
{
int i;
FILE *fp, *fopen();
	if((fp = fopen(filename,"w")) == NULL)
	{
		fl_show_message("Cannot create file ",filename,"Sorry");
		return;
	}
	for(i=0;i<MAX_PARAMETERS; i++)
	{
		fprintf(fp,"%d %lf %lf %lf %lf %d ",
		   i,parameter[i].original,
		   parameter[i].min,parameter[i].max,parameter[i].value,
		   parameter[i].changed);
		if(parameter[i].box_label)
			fprintf(fp,"%s\n",
		   		parameter[i].box_label);
		else
			fputc('\n',fp);
	}
	fclose(fp);
}
#endif
