/******
  
  muscles.c:	sets up the muscles data structures



This "single layer" facial animation model is basically a rewrite of
a old program of Keith Waters which he gave to Carol Wang at Univeristy
of Calgary.

This code was written with time and equipment provided by Sony Computer
Science Lab. It is freely distributable for research purposes. 

It is hoped making this available will facilitate research on facial
animation. If you make significant changes/extensions to this, or have
a different system I would appreciate hearing about it.


The latest versions of this and other animation systems are
available by anonymous FTP from:
     
        scslwide.sony.co.jp
	ftp2/SGI/Facial-Animation

  Copyright 1992	

  Written:	Steve Franks
                Sony Computer Science Labs
		Tokyo, Japan	
		Febuary 1992
		stevef@csl.sony.co.jp


*******/
#include "muscles.h"
#include "standard.h"
#include <forms.h>
#include "proto.h"

#include <stdio.h>
#include <math.h>

extern	struct	sphinctor mouth_sphin;
extern struct	muscle musc[NUM_MUSCLES];
extern	float	*face;
extern	param_vals	param[];
/*** setup_muscles() ***/
void setup_muscles(char *file)
{
    
    FILE 	*in_fp;
    int		num_musc;
    int		x,y,z;
    int		i;

  
   if (file == NULL) {
	for (i=0;i<NUM_MUSCLES;i++) {
	    musc[i].start_vrtx = -666;
	    musc[i].end_vrtx = -666;
	}
	return;
    }
	    
    printf("Opening %s for Muscle Input \n",file);
    in_fp = fopen(file,"r");
    if (in_fp==NULL) {
	printf("Error Opening Muscle file <%s> \n",file);
	exit(-1);
    }

    fscanf(in_fp,"%d",&num_musc);
    if (num_musc!=NUM_MUSCLES) {
	printf("I am hardwired for stupidity..I must have 14 \n");
	exit(-1);
    }
    
    for (i=0; i<num_musc; i++)  {
	fscanf(in_fp,"%d%d",&musc[i].start_vrtx, &musc[i].end_vrtx );
    }
    fclose(in_fp);


    sprintf(musc[0].title," Left Zygomatic major ");
    sprintf(musc[1].title," Right Zygomatic major ");
    sprintf(musc[2].title," Left Anguli Depressor ");
    sprintf(musc[3].title," Right Agnuli Depressor ");
    sprintf(musc[4].title," Inner-Left Frontalis ");
    sprintf(musc[5].title," Inner-Right Frontalis ");
    sprintf(musc[6].title," Outer-Left Frontalis ");
    sprintf(musc[7].title," Outer-Right Frontalis ");
    sprintf(musc[8].title," Left Labii ");
    sprintf(musc[9].title," Right Labii ");
    sprintf(musc[10].title," Left Corrugator ");
    sprintf(musc[11].title," Right Corrugator ");
    sprintf(musc[12].title," Nasi ");
    sprintf(musc[13].title," Lateral Corrugator ");
    sprintf(musc[14].title," Left Frontalis Major ");
    sprintf(musc[15].title," Right Frontalis Major ");
   
    
  
    /* Make better colours */
 
    musc[0].color = CON_RGB(0,255,255); 
    musc[1].color = CON_RGB(0,255,255); 
    musc[2].color = CON_RGB(0,0,255);
    musc[3].color = CON_RGB(0,0,255); 
    musc[4].color = CON_RGB(0,255,0); 
    musc[5].color = CON_RGB(0,255,0); 
    musc[6].color = CON_RGB(255,255,0); 
    musc[7].color = CON_RGB(255,255,0); 
    musc[8].color = CON_RGB(255,0,255); 
    musc[9].color = CON_RGB(255,0,255); 
    musc[10].color = CON_RGB(123,0,168); 
    musc[11].color = CON_RGB(123,0,168); 
    musc[12].color = CON_RGB(255,130,0); 
    musc[13].color = CON_RGB(67,25,184); 
    musc[14].color = CON_RGB(0,209,150); 
    musc[15].color = CON_RGB(0,209,150); 
   

}


/*** init_sphinctor ***/
void	init_sphinctor()
{
    printf("init_sphinctor() \n");
    mouth_sphin.cx = 0.0;
    mouth_sphin.cy = -2.0;

    mouth_sphin.range = 1.0;		/* 0..2 */
    mouth_sphin.pout  = 2.5;		/* 0..5 */

    sprintf(mouth_sphin.title," Mouth Sphincto");
    mouth_sphin.color = CON_RGB(255,0,0);

}	




/*** init_muscles()	***/
void	init_muscles() {
 
    
    int	face_indx,i;	
    float	ftemp;
    
    if (DEBUGGING)
      printf("init_muscles() \n");
    
    /* These distances are all relative to the Waters face coords */
    /* Define Range of Effect of the Muscles */
    
    musc[L_ZYGO].fall_strt = 	0.2;	/* zero */
    musc[L_ZYGO].fall_end  =	5.5;
    musc[L_ZYGO].theta	= 	30.0;
    
    
    musc[R_ZYGO].fall_strt = 	0.2;	/* zero */
    musc[R_ZYGO].fall_end  = 	5.5;
    musc[R_ZYGO].theta	= 	30.0;
    
    
    musc[L_ANGULI].fall_strt =  0.2;  /* one */
    musc[L_ANGULI].fall_end  =	4.5;
    musc[L_ANGULI].theta= 	55.0;
    
    
    musc[R_ANGULI].fall_strt = 	0.2;  /* one */
    musc[R_ANGULI].fall_end  = 	4.5;
    musc[R_ANGULI].theta= 	55.0;
    
    
    musc[IL_FRONT].fall_strt = 	0.2; /* two */
    musc[IL_FRONT].fall_end  = 	4.0;
    musc[IL_FRONT].theta= 	34.0;
    
    
    musc[IR_FRONT].fall_strt = 	0.2; /* two ok */
    musc[IR_FRONT].fall_end  = 	4.0;
    musc[IR_FRONT].theta= 	34.0;
    
    
    musc[OL_FRONT].fall_strt = 	0.2;  /* four ok*/
    musc[OL_FRONT].fall_end  = 	3.75;
    musc[OL_FRONT].theta= 	36.0;
    
    
    musc[OR_FRONT].fall_strt = 	0.2;	/* four */
    musc[OR_FRONT].fall_end  = 	3.75;
    musc[OR_FRONT].theta= 	36.0;
    
    
    musc[L_LABI].fall_strt = 	0.2;	/* five */
    musc[L_LABI].fall_end  = 	4.5;	/* ????????? not in origianl ig.c */
    musc[L_LABI].theta	= 	31.0;
    
    
    musc[R_LABI].fall_strt =	0.2;	/* five */
    musc[R_LABI].fall_end  = 	5.5;	/* not in original ig.c !!!!!! */
    musc[R_LABI].theta	= 	31.0;
    
    
    musc[NASI].fall_strt = 	0.2;	/* six ok */
    musc[NASI].fall_end  = 	5.5;
    musc[NASI].theta	= 	40.0;
    
    
    musc[LAT_CORR].fall_strt = 	0.2;	/* seven ok */
    musc[LAT_CORR].fall_end  = 	5.5;
    musc[LAT_CORR].theta= 	40.0;
    
    
    musc[L_CORR].fall_strt = 	0.2;	/* eight &ok*/
    musc[L_CORR].fall_end  = 	4.6;
    musc[L_CORR].theta	= 	54.0;
    
    
    musc[R_CORR].fall_strt = 	0.2;	/* eight ok*/
    musc[R_CORR].fall_end  = 	4.6;
    musc[R_CORR].theta	= 	54.0;
    
    musc[ML_FRONT].fall_strt = 	0.2;	/* eight ok*/
    musc[ML_FRONT].fall_end  = 	2.0;
    musc[ML_FRONT].theta= 	90; 
    
    musc[MR_FRONT].fall_strt = 	0.2;	/* eight ok*/
    musc[MR_FRONT].fall_end  = 	2.0;
    musc[MR_FRONT].theta= 	90;
        
    
    /* Compute some handy info */
    /* Note: These muscles are attached to the face at rest and the
      deformations are applied to the location the muscle is at when the face
	is at rest. */



    
    for (i=0; i<= NUM_MUSCLES; i++) {
	face_indx = musc[i].start_vrtx*3-2;
	bcopy(&face[face_indx],musc[i].start,sizeof(float)*3);
	
	face_indx = musc[i].end_vrtx*3-2;
	bcopy(&face[face_indx],musc[i].end,sizeof(float)*3);
	
    }

    /* Do a patch to Frontalis muscle to make it look better ?*/
    musc[MR_FRONT].start[0] += 0.01;
    musc[MR_FRONT].start[1] += 0.10;
    musc[MR_FRONT].start[2] += 0.01;

    musc[MR_FRONT].end[0] += 0.01;
    musc[MR_FRONT].end[1] += 0.01;
    musc[MR_FRONT].end[2] += 0.01;

    musc[ML_FRONT].start[0] += 0.01;
    musc[ML_FRONT].start[1] += 0.10;
    musc[ML_FRONT].start[2] += 0.01;

    musc[ML_FRONT].end[0] += 0.01;
    musc[ML_FRONT].end[1] += 0.01;
    musc[ML_FRONT].end[2] += 0.01;


    for (i=0; i<= NUM_MUSCLES; i++) {
	/*maybe these need opposite sign ?? */
	musc[i].lenx = musc[i].start[0] - musc[i].end[0];
	musc[i].leny = musc[i].start[1] - musc[i].end[1];
	musc[i].lenz = musc[i].start[2] - musc[i].end[2];
	
	
	musc[i].legth=SQR(musc[i].lenx)+SQR(musc[i].leny)+SQR(musc[i].lenz);
	musc[i].legth= fsqrt(musc[i].legth);

	
    }

}    



init_params()
{

    /* This adds a scaling factor for each muscle/jaw/eye.. parameter
       that is inputed via FORMS widgets...this allows all parameters
       to be expressed by the user in 0...1 space */
    
    printf("Initializing Parameter Scaling Factors \n");
    
    param[ L_ZYGO].scale = .650;
    param[ R_ZYGO].scale = .650;

    param[ L_ANGULI].scale = 1.0;
    param[ R_ANGULI].scale = 1.0;

    param[ IL_FRONT].scale = .80;
    param[ IR_FRONT].scale = .80;

    param[ OL_FRONT].scale = 1.2;
    param[ OR_FRONT].scale = 1.2;

    param[ L_LABI].scale = 0.80;
    param[ R_LABI].scale = 0.80;

    param[ L_CORR].scale = 0.8;
    param[ R_CORR].scale = 0.8;

    param[ NASI].scale = 0.600;
    param[ LAT_CORR].scale = 0.60;

    param[ ML_FRONT].scale = 0.30; 
    param[ MR_FRONT].scale = 0.30; 

    param[ LIP_Z].scale = 2.0;
    param[ LIP_Y].scale = 1.5;
    param[ JAW].scale = 1.5;

    
    /* 
      sphincter values are handled in the sphinctor muscle routine
       range = *2.0;
       msqueeze = *.225;
       pout = *5.0;

       */
}

/*** print_muscle - given a pointer to muscle structure print info ***/
void	print_muscle(struct muscle *msc)
{
    
    printf("Muscle Name \t : %s \n",msc->title);
    printf("Start Coord\t (%5.3f , %5.3f, %5.3f )\n",
	   msc->start[0], msc->start[1], msc->start[2]);

    printf("End Coord\t (%5.3f , %5.3f, %5.3f )\n",
	   msc->end[0], msc->end[1], msc->end[2]);

  
    printf("Start Vertex = %d    End Vertex = %d\n",
	   msc->start_vrtx,msc->end_vrtx);
    printf("Length = <%5.3f %5.3f %5.3f> %5.3f \n",
	   msc->lenx,msc->leny,msc->lenz,msc->legth);
    
    printf("Fall Start = % 5.3f \t Fall End = %5.3f\n",msc->fall_strt,
	   msc->fall_end);

    printf("Theta = %5.3f \n",msc->theta);
}




