/******
  
  face.c:	Loads disk files for the face data, as well
                as the vertex indexes for the Lips and Jaw



This "single layer" facial animation model is basically a rewrite of
a old program of Keith Waters which he gave to Carol Wang at Univeristy
of Calgary.

This code was written with time and equipment provided by Sony Computer
Science Lab. It is freely distributable for research purposes. 

It is hoped making this available will facilitate research on facial
animation. If you make significant changes/extensions to this, or have
a different system I would appreciate hearing about it.


The latest versions of this and other animation systems are
available by anonymous FTP from:
     
        scslwide.sony.co.jp
	ftp2/SGI/Facial-Animation

  Copyright 1992	

  Written:	Steve Franks
                Sony Computer Science Labs
		Tokyo, Japan	
		Febuary 1992
		stevef@csl.sony.co.jp


*******/



#include <forms.h>
#define REDUNDANT -666
#include <gl/gl.h>
#include <stdio.h>
#include <unistd.h>
#include "standard.h"
#include "muscles.h"
#include "proto.h"

extern	float 	*face;
extern	int   	*tconn;
extern	int	*qconn;


/*** load_face() -- get info from disk files ***/
void load_face(char *dfile)
{


    char	data_file[40];
    FILE 	*in_file;
    int 	i,st,npoly,nvert;
    float	ftemp;


    /* First Load in the Connection Data */
    sprintf(data_file,"%s.tconn",dfile);
    in_file = fopen(data_file,"r");
    if (in_file == NULL) {
	printf("Error opening %s \n", data_file); 
	exit(-1);
    }

    st = fscanf(in_file,"%d",&npoly);
    tconn = (int *) malloc(sizeof(int) * (npoly*3+1));
    tconn[0] = npoly;

    for (i=1;i<=npoly*3;i++) { 
	fscanf(in_file,"%d",&tconn[i]);
    }
    fclose(in_file);
    

    /** Load in the Quadralateral Connection Data **/
    /* First Load in the Connection Data */
    sprintf(data_file,"%s.qconn",dfile);
    in_file = fopen(data_file,"r");
    if (in_file == NULL) {
	printf("Error opening %s \n", data_file); 
	exit(-1);
    }

    st = fscanf(in_file,"%d",&npoly);
    qconn = (int *) malloc(sizeof(int) * (npoly*4+1));
    qconn[0] = npoly;

    for (i=1;i<=npoly*4;i++) { 
	fscanf(in_file,"%d",&qconn[i]);
    }
    fclose(in_file);
    
    

    /* Now Load In the Vertex locations */
    
    sprintf(data_file,"%s.coor",dfile);
    in_file= fopen(data_file,"r");
    if (in_file == NULL) {
	printf("Error opening %s \n", data_file); 
	exit(-1);
    }
    
    st = fscanf(in_file,"%f",&ftemp);
    nvert = (int) ftemp;
    printf("Loading %d Vertices \n",nvert);
    face = (float *) malloc(sizeof(float) * (nvert*3+1));
    face[0] = (float) nvert;
    
    for (i=1;i<=nvert*3;i++) {
	fscanf(in_file,"%f",&face[i]);
    }
    
    fclose(in_file);

   
}	


int *load_jaw(char *file)
{

    int	i,npnts;
    FILE *fp;
    int	*jaw_indx;


    printf("Reading  <%s> for jaw locations \n",file);
    fp = fopen(file,"r");
    if (fp==NULL) {
	printf("ERROR: \07 Opening File %s \n",file);
	exit(-1);
    }

    fscanf(fp,"%d",&npnts);

    jaw_indx = 	(int *) malloc((npnts+1)*sizeof(int));
    jaw_indx[0] = npnts;
    for (i=1;i<=npnts; i++) {
	fscanf(fp,"%d",&jaw_indx[i]); 
    }
    return(jaw_indx);
}




int *load_lips(char *file)
{

    int	i,npnts;
    FILE *fp;
    int	*lips;

    printf("Reading  <%s> for Lip locations \n",file);
    fp = fopen(file,"r");
    if (fp==NULL) {
	printf("ERROR: \07 Opening File %s \n",file);
	exit(-1);
    }

    fscanf(fp,"%d",&npnts);

    lips = 	(int *) malloc((npnts+1)*sizeof(int));
    
    lips[0] = npnts;

    for (i=1;i<=npnts; i++) {
	fscanf(fp,"%d",&lips[i]); 
    }
    
    fclose(fp);
    return(lips);
}




