/******
  
  face.c:	Loads disk files for the face data, as well
                as the vertex indexes for the Lips and Jaw


This code was written with time and equipment provided by Sony Computer
Science Lab. It is freely distributable for research purposes. 

It is hoped making this available will facilitate research on facial
animation. If you make significant changes/extensions to this, or have
a different system I would appreciate hearing about it.


The latest versions of this and other animation systems are
available by anonymous FTP from:
     
        scslwide.sony.co.jp
	ftp2/SGI/Facial-Animation

  Copyright 1992	

  Written:	Steve Franks
                Sony Computer Science Labs
		Tokyo, Japan	
		Febuary 1992
		stevef@csl.sony.co.jp


*******/



#include <forms.h>
#define REDUNDANT -666
#include <gl/gl.h>
#include <stdio.h>
#include <unistd.h>
#include "standard.h"
#include "muscles.h"


/*** load_face_qconn() -- get info from disk files ***/
int *load_face_qconn(char *dfile)
{


    int		*quad_conn;
    char	data_file[40];
    FILE 	*in_file;
    int 	i,st,npoly;
    float	ftemp;


    sprintf(data_file,"%s.qconn",dfile);
    in_file = fopen(data_file,"r");
    if (in_file == NULL) {
	printf("Error opening %s \n", data_file); 
	exit(-1);
    }

    st = fscanf(in_file,"%d",&npoly);
    quad_conn = (int *) malloc(sizeof(int) * (npoly*4+1));
    quad_conn[0] = npoly;

    for (i=1;i<=npoly*4;i++) { 
	fscanf(in_file,"%d",&quad_conn[i]);
    }
    fclose(in_file);
    return(quad_conn);
    
}

/*** float *load_face_coor () ***/
float *load_face_coor(char *dfile)
{
    char 	data_file[100];
    int		st,i,nvert;
    float	*coor;
    float	ftemp;
    FILE	*in_file;

    sprintf(data_file,"%s.coor",dfile);
    in_file= fopen(data_file,"r");
    if (in_file == NULL) {
	printf("Error opening %s \n", data_file); 
	exit(-1);
    }
    
    st = fscanf(in_file,"%f",&ftemp);
    nvert = (int) ftemp;
    printf("Loading %d Vertices \n",nvert);
    coor = (float *) malloc(sizeof(float) * (nvert*3+1));
    coor[0] = (float) nvert;
    
    for (i=1;i<=nvert*3;i++) {
	fscanf(in_file,"%f",&coor[i]);
    }
    
    fclose(in_file);
    return(coor);

   
}	


/*** int *load_face_tconn(char *) ***/
int *load_face_tconn(char *file)
{
    char	data_file[100];
    FILE	*in_file;
    int		npoly,st,i;
    int		*tconn;
    /* First Load in the Connection Data */
    sprintf(data_file,"%s.tconn",file);
    in_file = fopen(data_file,"r");
    if (in_file == NULL) {
	printf("Error opening %s \n", data_file); 
	exit(-1);
    }

    st = fscanf(in_file,"%d",&npoly);
    tconn = (int *) malloc(sizeof(int) * (npoly*3+1));
    tconn[0] = npoly;

    for (i=1;i<=npoly*3;i++) { 
	fscanf(in_file,"%d",&tconn[i]);
    }
    fclose(in_file);
    return(tconn);
    
}


/*** int *load_jaw(char *file) ***/
int *load_jaw(char *file)
{

    int	i,npnts;
    FILE *fp;
    int	*jaw_indx;


    printf("Reading  <%s> for jaw locations \n",file);
    fp = fopen(file,"r");
    if (fp==NULL) {
	printf("ERROR: \07 Opening File %s \n",file);
	exit(-1);
    }

    fscanf(fp,"%d",&npnts);

    jaw_indx = 	(int *) malloc((npnts+1)*sizeof(int));
    jaw_indx[0] = npnts;
    for (i=1;i<=npnts; i++) {
	fscanf(fp,"%d",&jaw_indx[i]); 
    }
    return(jaw_indx);
}




/*** int *load_lips(char *file) ***/
int *load_lips(char *file)
{

    int	i,npnts;
    FILE *fp;
    int	*lips;

    printf("Reading  <%s> for Lip locations \n",file);
    fp = fopen(file,"r");
    if (fp==NULL) {
	printf("ERROR: \07 Opening File %s \n",file);
	exit(-1);
    }

    fscanf(fp,"%d",&npnts);

    lips = 	(int *) malloc((npnts+1)*sizeof(int));
    
    lips[0] = npnts;

    for (i=1;i<=npnts; i++) {
	fscanf(fp,"%d",&lips[i]); 
    }
    
    fclose(fp);
    return(lips);
}



/*** float *load_skull_coor() ***/
float *load_skull_coor()
{

    FILE 	*sk_coor_fp;
    int		st,i,pntr,n;
    float	*sk_pnts;

    sk_coor_fp = fopen("skull.coor","r");
    
    fscanf(sk_coor_fp,"%d",&n);
    printf("Reading %d Coordinate \n",n);
    sk_pnts = (float *) malloc(sizeof(float)*n*3 +1);
    sk_pnts[0] = (float)n;
    for (i=1;i<=n*3;i++) {
	st=fscanf(sk_coor_fp,"%f",&sk_pnts[i]);
	if (st!=1) {
	    perror("Reading Coordinates");
	}
    }

    return(sk_pnts);
    /* Now make the normals for each point */
}



/*** int *load_skull_conn() ***/
int *load_skull_conn()
{
    FILE *sk_conn_fp;
    int	n,i,st;
    int *sk_quad;

    /* will use triangles here */
    sk_conn_fp = fopen("skull.conn","r");
    if (sk_conn_fp ==NULL) {
	perror("Opening Skull Connection File ");
    }
    fscanf(sk_conn_fp,"%d",&n);
    printf("Reading %d quads \n",n);
    sk_quad = (int *) malloc(sizeof(int)*n*4 +1);
    sk_quad[0] = n;
    for (i=1;i<=n*4;i++) {
	st=fscanf(sk_conn_fp,"%d",&sk_quad[i]);
	if (st!=1) {
	    printf("st = %d \n",st);
	    perror("Reading Skull Connections");
	}
    }
    return(sk_quad);
}

    
