static char rcsid[]="$Id$";
/*
 * $RCSfile: $
 * $Revision: $
 * $Date: $
 * $Author: $
 * $Locker: $
 *
 * $Log: $
 *
 */
#define SIZE 20

#include <stdio.h>
#include <math.h>

typedef struct point {
	double x,y,z;
} Point;

Point map[SIZE][SIZE];

sub(a,b,p)
Point a,b,*p;
{
	p->x=a.x-b.x;
	p->y=a.y-b.y;
	p->z=a.z-b.z;
}

add(a,b,p)
Point a,b,*p;
{
	p->x=a.x+b.x;
	p->y=a.y+b.y;
	p->z=a.z+b.z;
}

double len(p)
Point p;
{
	return(sqrt(p.x*p.x+p.y*p.y+p.z*p.z));
}

mul(p,c,p2)
Point p,*p2;
double c;
{
	p2->x=p.x*c;
	p2->y=p.y*c;
	p2->z=p.z*c;
}

sheet(p,start,end,musclen,ml,falldist,factor)
Point *p,start,end,musclen;
double ml,falldist,factor;
{
	Point rel;
	Point newp;

	double length;
	double cosang;
	double sinang;
	double constan,percent,newv;
	double dist1,dist2;
	double	sign;

	sub(*p,start,&rel);	/* distance from head to point */
	length=len(rel);
	
	cosang = ((rel.x*musclen.x)+(rel.y*musclen.y)+(rel.z*musclen.z)) / (length*ml);
	sinang = sqrt(1. -cosang*cosang);
	
	dist1  = length*sinang;	/* length of muscle */
	if(dist1 < falldist)
	{
		dist2 = length * cosang;
		constan = dist2/ml;
		if(constan <= 1.0 && constan >=0.0)
		{
			percent = dist1/falldist;
			if (factor>=0)	sign = 1.;
			else		sign = -1.;
			newv = cos(percent* 1.57079632679489661923132169164);
			newv = newv*newv -pow(newv, 2.0+fabs(factor));
/*			newv = cos(percent*1.57079632679489661923132169164)*factor; */
			mul(rel,sign*newv,&newp);
			sub(*p,newp,p);
		}	
	}
}

linear (p, start, end, musclen, ml, fallstart, fallfin, theta, factor, ofp)
Point *p,start,end,musclen;
double ml,fallstart, fallfin, theta, factor;
FILE	*ofp;
{
    Point rel;
    Point newp;
    
    double length;
    double cosang;
    double sinang;
    double constan,percent,newv;
    double dist1,dist2;
    double	sign;

    double toll, value, dif, tot;

    theta = cos(theta/57.2957795130823208767981548141);
    toll  = 20.0;
    
    sub(*p,start,&rel);	/* distance from head to point */
    length=len(rel);
	
/* 	    if(px<= toll) ? */

    if ((ml > 0.0) && (length > 0.0))
	cosang = ((rel.x*musclen.x)+(rel.y*musclen.y)+(rel.z*musclen.z)) / (length*ml);
    else	cosang =0.0;
		
    if ((cosang >= theta) &&  (ml <= fallfin))	{
	value = factor*((cosang - theta)/(1.0- theta));
	if(ml>=fallstart && ml<=fallfin)	{
	    dif = ml - fallstart;
	    tot = fallfin - fallstart;
	    percent = dif/tot;
	    newv = cos(percent*1.57079632679489661923132169164);
	    mul(rel, value*0.9*newv, &newp);
	    }
	else	mul(rel, value*.5, &newp);
	sub(*p, newp, p);
	}
    return;
    }

sphincter (p, c, r, fall_rad, squeeze, ofp)
Point *p, c, r;
double fall_rad, squeeze;
FILE	*ofp;
{
    Point	v, rel, newp;
    double sqrx,sqry,sqrz, dist;
    double percent, value;
    double	ra,rb,rc;
    
    sub(*p, c, &rel);

    sqrx = rel.x * rel.x;
    sqry = rel.y * rel.y;
    ra = r.x*r.x;
    rb = r.y*r.y;
	    
    if ((dist = sqrt(sqrx/ra +sqry/rb))<= fall_rad)	{ 
	percent = dist/fall_rad;
	value = squeeze*cos(percent*1.57079632679489661923132169164);

	mul(rel, value, &newp);		
	sub(*p, newp, p);
	}
    return;
    }

/* 
::gnuplot command:: 
set xlabel "x"
set ylabel "y"
set zlabel "z"
set parametric
splot [0:20] [0:20] [0:20] [0:20] [-1:1] "data", "vector.dat" with lines, "vector.dat"
*/

main(argc,argv)
int argc;
char *argv[];
{
	int	x,y;
	FILE	*ofp, *fopen();

	Point start;
	Point end;
	Point musclen;
	double ml;
	double factor;
	double	falldist;

	start.x=4.0;
	start.y=10.0;
	start.z=-0.3;

	end.x=15.0;
	end.y=10.0;
	end.z=0.5;
	ofp = fopen("vector.dat", "w");
	fprintf(ofp,"%lf %lf %lf\n", start.x, start.y,start.z);
	fprintf(ofp,"%lf %lf %lf\n", end.x, end.y,end.z);

	ofp = fopen("argh.dat", "w");

	if(argc>1){
		factor=atof(argv[1]);
	}else
		factor=0.0;

	for(x=0;x<SIZE;x++)
		for(y=0;y<SIZE;y++){
			map[x][y].x=x;
			map[x][y].y=y;
			map[x][y].z=0;
		}

	end.z *= factor;
	sub(end,start,&musclen);
	ml=len(musclen);

	if(argc>2){
	    falldist=atof(argv[2]);
	}else
	    falldist = 0.85*ml;

	for(x=0;x<SIZE;x++)
		for(y=0;y<SIZE;y++){
/*			sheet(&map[x][y],start,end,musclen,ml,falldist,factor, ofp);*/ 
/*			linear(&map[x][y],start,end,musclen,ml,falldist,ml*1.2,30.,factor, ofp); */
			sphincter (&map[x][y], start, end, falldist, factor, ofp);/**/
		}


	for(x=0;x<SIZE;x++)
		for(y=0;y<SIZE;y++){
			printf("%lf %lf %lf\n", map[x][y].x, map[x][y].y,map[x][y].z);
		}
	
}
