/*
# proc: readfetfile - opens an fet file and reads its contents into an
# proc:               fet structure.
*/

#include <stdio.h>
#include <string.h>
#include <fet.h>

FET *readfetfile(file)
char *file;
{
   FILE *fp;
   FET *fet;
   int feature_number;
   int end_of_file = False;
   char c,buf[MAXFETLENGTH];

   if ((fp = fopen(file,"r")) == NULL)
      syserr("readfetfile","fopen",file);

   fet = allocfet(MAXFETS);
   feature_number = 0;
   while ((feature_number < MAXFETS) && (!end_of_file)){
      if (fscanf(fp,"%s",buf) == EOF)
         {
           end_of_file = True;
           continue;
         }
      while(((c = getc(fp)) == ' ') || (c == '\t'));
      ungetc(c, fp);
      fet->names[feature_number] = strdup(buf);
      if(fet->names[feature_number] == NULL)
         syserr("readfetfile","strdup","fet->names[]");
      fgets(buf,MAXFETLENGTH-1,fp);
      buf[strlen(buf)-1] = '\0';
      fet->values[feature_number] = strdup(buf);
      if(fet->values[feature_number] == NULL)
         syserr("readfetfile","strdup","fet->values[]");
      feature_number++;
   }
   if(feature_number >= MAXFETS)
      fatalerr("readfetfile","feature values overflow malloc",NULL);
   fclose(fp);
   fet->num = feature_number; 
   return(fet);
}
