/*** FILE "mapbase.cc" ********************************************* 110693 ***/

#include "include/mapbase.h"
#include "include/rgb.h"

/*** MapBase ******************************************************************/

pix MapBase::MaxX() const
{ return SizeX()-1;
}

pix MapBase::MaxY() const
{ return SizeY()-1;
}

n1 MapBase::GetBitColorNC(pix x, pix y) const
{ n16 r, g, b;
  GetPixelNC(x,y,r,g,b);
  return BitIntensity(r,g,b);
}

void MapBase::Black()
{ BitColor(0);
}

void MapBase::White()
{ BitColor(1);
}

void MapBase::Clear()
{ ClearNC(0,0,MaxX(),MaxY());  //clear everything
}

void MapBase::ClearNC(pix x1, pix y1, pix x2, pix y2)
{ Black();                 //use the color Black...
  FillBoxNC(x1,y1,x2,y2);  //...to fill the window
}

void MapBase::HLineNC(pix x1, pix x2, pix y)
{ if (x1>x2) Swap(x1,x2);    //orientate the line from low to high pix values
  for(pix x=x1; x<=x2; x++)  //for each pixel on the line...
    PixelNC(x,y);            //...set pixel
}

void MapBase::VLineNC(pix x, pix y1, pix y2)
{ if (y1>y2) Swap(y1,y2);    //orientate the line from low to high pix values
  for(pix y=y1; y<=y2; y++)  //for each pixel on the line...
    PixelNC(x,y);            //...set pixel
}

void MapBase::DLineNC(pix x1, pix y1, pix x2, pix y2)
{ /* Bresenham's Line Algorithm: */
  if (Abs(x1-x2)>Abs(y1-y2))
  { if (x1>x2)
    { Swap(x1,x2);
      Swap(y1,y2);
    }
    pix dx=x2-x1;
    pix y=y1;
    if (y1<y2)
    { pix dy=y2-y1;
      pix e_noinc=dy+dy;         //e_noinc change in error when y increments
      spix e=e_noinc-dx;         //e current error term
      spix e_inc=e-dx;           //e_inc change in error when y increments
      for(pix x=x1; x<=x2; x++)
      { PixelNC(x,y);
        if (e<0)
          e+=e_noinc;
        else
        { y++;
          e+=e_inc;
        }
      }
    }
    else
    { pix dy=y1-y2;
      pix e_noinc=dy+dy;
      spix e=e_noinc-dx;
      spix e_inc=e-dx;
      for(pix x=x1; x<=x2; x++)
      { PixelNC(x,y);
        if (e<0)
          e+=e_noinc;
        else
        { y--;
          e+=e_inc;
        }
      }
    }
  }
  else
  { if (y1>y2)
    { Swap(y1,y2);
      Swap(x1,x2);
    }
    pix dy=y2-y1;
    pix x=x1;
    if (x1<x2)
    { pix dx=x2-x1;
      pix e_noinc=dx+dx;
      spix e=e_noinc-dy;
      spix e_inc=e-dy;
      for(pix y=y1; y<=y2; y++)
      { PixelNC(x,y);
        if (e<0)
          e+=e_noinc;
        else
        { x++;
          e+=e_inc;
        }
      }
    }
    else
    { pix dx=x1-x2;
      pix e_noinc=dx+dx;
      spix e=e_noinc-dy;
      spix e_inc=e-dy;
      for(pix y=y1; y<=y2; y++)
      { PixelNC(x,y);
        if (e<0)
          e+=e_noinc;
        else
        { x--;
          e+=e_inc;
        }
      }
    }
  }
}

void MapBase::LineNC(pix x1, pix y1, pix x2, pix y2)
{ if (x1==x2)                //if the line is vertical...
    VLineNC(x1,y1,y2);       //...VLineNC can draw it fastest...
  else
  { if (y1==y2)              //...else if the line is horizontal...
      HLineNC(x1,x2,y1);     //...HLineNC can draw it fastest...
    else
      DLineNC(x1,y1,x2,y2);  //...else let DLineNC draw the line
  }
}

void MapBase::BoxNC(pix x1, pix y1, pix x2, pix y2)
{ HLineNC(x1,x2,y1);  //upper line
  HLineNC(x1,x2,y2);  //lower line
  VLineNC(x1,y1,y2);  //left line
  VLineNC(x2,y1,y2);  //right line
}

void MapBase::FillBoxNC(pix x1, pix y1, pix x2, pix y2)
{ pix y=y1;
  while(y<=y2)       //for each y value inside the box...
  { pix x=x1;
    while(x<=x2)     //...and for each x value inside the box...
    { PixelNC(x,y);  //...set pixel
      x++;
    }
    y++;
  }
}

void MapBase::FillTriangleNC(PPoint points[])
{ //NOTE: YET TO BE IMPLEMENTED!
}

void MapBase::FillConvexPolygonNC(PPoint points[], word n)
{ //NOTE: YET TO BE IMPLEMENTED!
}

void MapBase::FillPolygonNC(PPoint points[], word n)
{ //NOTE: YET TO BE IMPLEMENTED!
}

void MapBase::Flush()
{ /* Empty - and should be kept empty; the default implementation is supposed
   * to do nothing at all! */
}

void MapBase::AspectRatio(double r)
{ /* Empty - and should be kept empty; the default implementation is supposed
   * to do nothing at all! */
}

double MapBase::GetAspectRatio() const
{ return 1;
}

/*** EXPERIMENTAL AREA ONLY ***/

void MapBase::Copy(MapBase& M, pix x1, pix y1, pix x2, pix y2)
{
}

/******************************/

/*** MapPCBase ****************************************************************/

void MapPCBase::BitColor(n1 c)
{ if (c==0)               //if Black is wanted...
    ColorNC(0);           //...select Black...
  else
    ColorNC(GetWhite());  //...else select White
}

/*** EXPERIMENTAL AREA ONLY ***/

void MapPCBase::Copy(MapBase& M, pix x1, pix y1, pix x2, pix y2, n16 colors)
{
}

/******************************/

/*** MapSCBase ****************************************************************/

void MapSCBase::BitColor(n1 c)
{ if (c==0)                    //if Black is wanted...
    Color(0,0,0);              //...select Black...
  else
    Color(MAX_R,MAX_G,MAX_B);  //...else select White
}

/*** EXPERIMENTAL AREA ONLY ***/

void MapSCBase::Copy(MapBase& M, pix x1, pix y1, pix x2, pix y2)
{
}

void MapSCBase::Blend(MapBase& M, pix x1, pix y1, pix x2, pix y2)
{
}

/******************************/

/******** "mapbase.cc" ********************************************************/

