#ifndef lint
static char sccsid[] = "@(#)tiffcp.c	1.13 6/3/90";
#endif

/*
 * Copyright (c) 1988, 1990 by Sam Leffler.
 * All rights reserved.
 *
 * This file is provided for unrestricted use provided that this
 * legend is included on all tape media and as a part of the
 * software program in whole or part.  Users may copy, modify or
 * distribute this file at will.
 */

#include <stdio.h>
#include "tiffio.h"

#define	howmany(x, y)	(((x)+((y)-1))/(y))
#define	streq(a,b)	(strcmp(a,b) == 0)
#define	CopyField(tag, v) \
    if (TIFFGetField(in, tag, &v)) TIFFSetField(out, tag, v)
#define	CopyField3(tag, v1, v2, v3) \
    if (TIFFGetField(in, tag, &v1, &v2, &v3)) TIFFSetField(out, tag, v1, v2, v3)

main(argc, argv)
	char *argv[];
{
	short bitspersample, samplesperpixel, shortv;
	short imagewidth, imagelength, config = -1;
	u_short compression = -1;
	u_short predictor = 0;
	long rowsperstrip = -1;
	float floatv;
	char *stringv;
	u_long longv;
	u_char *buf;
	int row, s;
	TIFF *in, *out;

	argc--, argv++;
	if (argc < 2)
		usage();
	for (; argc > 2 && argv[0][0] == '-'; argc--, argv++) {
		if (streq(argv[0], "-none")) {
			compression = COMPRESSION_NONE;
			continue;
		}
		if (streq(argv[0], "-packbits")) {
			compression = COMPRESSION_PACKBITS;
			continue;
		}
		if (streq(argv[0], "-lzw")) {
			compression = COMPRESSION_LZW;
			continue;
		}
		if (streq(argv[0], "-contig")) {
			config = PLANARCONFIG_CONTIG;
			continue;
		}
		if (streq(argv[0], "-separate")) {
			config = PLANARCONFIG_SEPARATE;
			continue;
		}
		if (streq(argv[0], "-rowsperstrip")) {
			argc--, argv++;
			rowsperstrip = atoi(argv[0]);
			continue;
		}
		if (streq(argv[0], "-predictor")) {
			argc--, argv++;
			predictor = atoi(argv[0]);
			continue;
		}
		usage();
	}
	in = TIFFOpen(argv[0], "r");
	if (in == NULL)
		exit(-1);
	out = TIFFOpen(argv[1], "w");
	if (out == NULL)
		exit(-2);
	CopyField(TIFFTAG_SUBFILETYPE, longv);
	CopyField(TIFFTAG_IMAGEWIDTH, imagewidth);
	CopyField(TIFFTAG_IMAGELENGTH, imagelength);
	CopyField(TIFFTAG_BITSPERSAMPLE, bitspersample);
	if (compression != (u_short)-1)
		TIFFSetField(out, TIFFTAG_COMPRESSION, compression);
	else
		CopyField(TIFFTAG_COMPRESSION, compression);
	if (predictor != 0)
		TIFFSetField(out, TIFFTAG_PREDICTOR, predictor);
	else
		CopyField(TIFFTAG_PREDICTOR, predictor);
	CopyField(TIFFTAG_PHOTOMETRIC, shortv);
	CopyField(TIFFTAG_THRESHHOLDING, shortv);
	CopyField(TIFFTAG_FILLORDER, shortv);
	CopyField(TIFFTAG_ORIENTATION, shortv);
	CopyField(TIFFTAG_SAMPLESPERPIXEL, samplesperpixel);
	CopyField(TIFFTAG_MINSAMPLEVALUE, shortv);
	CopyField(TIFFTAG_MAXSAMPLEVALUE, shortv);
	CopyField(TIFFTAG_XRESOLUTION, floatv);
	CopyField(TIFFTAG_YRESOLUTION, floatv);
	CopyField(TIFFTAG_GROUP3OPTIONS, longv);
	CopyField(TIFFTAG_GROUP4OPTIONS, longv);
	CopyField(TIFFTAG_RESOLUTIONUNIT, shortv);
	if (config != -1)
		TIFFSetField(out, TIFFTAG_PLANARCONFIG, config);
	else
		CopyField(TIFFTAG_PLANARCONFIG, config);
	if (rowsperstrip <= 0)
		rowsperstrip = (8*1024)/TIFFScanlineSize(out);
	TIFFSetField(out, TIFFTAG_ROWSPERSTRIP,
	    rowsperstrip == 0 ? 1 : rowsperstrip);
	CopyField(TIFFTAG_XPOSITION, floatv);
	CopyField(TIFFTAG_YPOSITION, floatv);
	CopyField(TIFFTAG_GRAYRESPONSEUNIT, shortv);
	{ u_short *graycurve;
	  CopyField(TIFFTAG_GRAYRESPONSECURVE, graycurve);
	}
	CopyField(TIFFTAG_COLORRESPONSEUNIT, shortv);
	{ u_short *red, *green, *blue;
	  CopyField3(TIFFTAG_COLORRESPONSECURVE, red, green, blue);
	}
	CopyField(TIFFTAG_MATTEING, shortv);
	{ u_short *red, *green, *blue;
	  CopyField3(TIFFTAG_COLORMAP, red, green, blue);
	}
	CopyField(TIFFTAG_ARTIST, stringv);
	CopyField(TIFFTAG_IMAGEDESCRIPTION, stringv);
	CopyField(TIFFTAG_MAKE, stringv);
	CopyField(TIFFTAG_MODEL, stringv);
	CopyField(TIFFTAG_SOFTWARE, stringv);
	CopyField(TIFFTAG_DATETIME, stringv);
	CopyField(TIFFTAG_HOSTCOMPUTER, stringv);
	CopyField(TIFFTAG_PAGENAME, stringv);
	CopyField(TIFFTAG_DOCUMENTNAME, stringv);
	(void) TIFFGetField(in, TIFFTAG_PLANARCONFIG, &shortv);
	if (shortv != config && bitspersample != 8 && samplesperpixel > 1) {
		fprintf(stderr,
"Can't handle different planar configuration w/ bits/sample != 8\n");
		exit(-1);
	}
#define	pack(a,b)	((a)<<8)|(b)
	switch (pack(shortv, config)) {
	case pack(PLANARCONFIG_CONTIG, PLANARCONFIG_CONTIG):
		buf = (u_char *)malloc(TIFFScanlineSize(in));
		for (row = 0; row < imagelength; row++) {
			if (TIFFReadScanline(in, buf, row, 0) < 0 ||
			    TIFFWriteScanline(out, buf, row, 0) < 0)
				goto done;
		}
		break;
	case pack(PLANARCONFIG_SEPARATE, PLANARCONFIG_SEPARATE):
		buf = (u_char *)malloc(TIFFScanlineSize(in));
		for (s = 0; s < samplesperpixel; s++)
			for (row = 0; row < imagelength; row++) {
				if (TIFFReadScanline(in, buf, row, s) < 0 ||
				    TIFFWriteScanline(out, buf, row, s) < 0)
					goto done;
			}
		break;
	case pack(PLANARCONFIG_CONTIG, PLANARCONFIG_SEPARATE): {
		u_char *inbuf, *outbuf;
		register u_char *inp, *outp;
		register int n;

		inbuf = (u_char *)malloc(TIFFScanlineSize(in));
		outbuf = (u_char *)malloc(TIFFScanlineSize(out));
		/* unpack channels */
		for (s = 0; s < samplesperpixel; s++) {
			for (row = 0; row < imagelength; row++) {
				if (TIFFReadScanline(in, inbuf, row, 0) < 0)
					goto done;
				inp = inbuf + s;
				outp = outbuf;
				for (n = imagewidth; n-- > 0;) {
					*outp++ = *inp;
					inp += samplesperpixel;
				}
				if (TIFFWriteScanline(out, outbuf, row, s) < 0)
					goto done;
			}
		}
		break;
	}
	case pack(PLANARCONFIG_SEPARATE, PLANARCONFIG_CONTIG): {
		u_char *inbuf, *outbuf;
		register u_char *inp, *outp;
		register int n;

		inbuf = (u_char *)malloc(TIFFScanlineSize(in));
		outbuf = (u_char *)malloc(TIFFScanlineSize(out));
		for (row = 0; row < imagelength; row++) {
			/* merge channels */
			for (s = 0; s < samplesperpixel; s++) {
				if (TIFFReadScanline(in, inbuf, row, s) < 0)
					goto done;
				inp = inbuf;
				outp = outbuf + s;
				for (n = imagewidth; n-- > 0;) {
					*outp = *inp++;
					outp += samplesperpixel;
				}
			}
			if (TIFFWriteScanline(out, outbuf, row, 0) < 0)
				goto done;
		}
		break;
	}
	}
done:
	(void) TIFFClose(in);
	(void) TIFFClose(out);
	exit(0);
}

usage()
{
	fprintf(stderr, "usage: tiffcp [options] input output\n");
	fprintf(stderr, "where options are:\n");
	fprintf(stderr,
	    " -contig\tpack samples contiguously (e.g. RGBRGB...)\n");
	fprintf(stderr,
	    " -separate\tstore samples separately (e.g. RRR...GGG...BBB...)\n");
	fprintf(stderr, "\n");
	fprintf(stderr,
	    " -lzw\t\tcompress output with Lempel-Ziv & Welch encoding\n");
	fprintf(stderr,
	    " -packbits\tcompress output with packbits encoding\n");
	fprintf(stderr,
	    " -none\t\tuse no compression algorithm on output\n");
	fprintf(stderr, "\n");
	fprintf(stderr,
	    " -rowsperstrip #\tmake each strip have no more than # rows\n");
	exit(-1);
}
