/*Object IDs and variable IDs
  Eric Pepke
  March 28, 1990
*/

/*Variables and methods*/
#define DATA		1	/*Data variable*/
#define DATAFORM	2	/*Data form*/
#define COLORS		3	/*Colors for field dots*/
#define DIMENSIONS	4	/*Dimensions of something*/
#define BOUNDS		5	/*Bounds of an object*/
#define ICONLOC		6	/*Icon location*/
#define REPOBJ		7	/*Object this object represents*/
#define NAME		8	/*Name of this object*/
#define DRAW		9	/*Draw yerself.*/
#define CONTENTS	10	/*Contents of this panel, corral, or whatever*/
#define WHICHICON	11	/*The number of the icon*/
#define PRESS		12	/*Press method*/
#define SELECTED	13	/*Selected variable*/
#define HIGHLIGHTED	14	/*Highghlighghglighghted variable.*/
#define BASECOLOR	15	/*Base color of an object*/
#define XFORM		16	/*Rotation and translation matrix for an observer*/
#define ROTATE		17	/*Rotate message*/
#define BUTTONTYPE	18	/*Type of button*/
#define MARKERTYPE	19	/*Type of marker*/
#define XSTRETCH	20	/*Stretch in X*/
#define YSTRETCH	21	/*Stretch in Y*/
#define CHANGEDVALUE	22	/*Changedvalue method for buttons & controls*/
#define LEVEL		23	/*Level in a slice*/
#define ADDCONTROLS	24	/*Gives visualization a chance to add controls*/
#define DRAWCONTENTS	25	/*Method to draw the contents of something*/
#define PRESSCONTENTS	26	/*Method to press in the contents of something*/
#define BACKGROUND	27	/*Background color of something*/
#define STYLE		28      /*Style of anything*/
#define LOVALUE         29      /*Lower limit of slider value*/
#define HIVALUE         30      /*Upper limit of slider value*/
#define STEPVALUE       31      /*Step value of slider*/
#define VALUE           32      /*Current value of slider*/
#define VALUE2          33      /*Second value of dual-value slider*/
#define GETVAL		34	/*Get value method*/
#define NORMALS		35	/*Normals for a mesh*/
#define DEFAULTICON	36	/*Default icon for a visualization object*/
#define NEWCTLWINDOW	37	/*New control window method*/
#define SPECVAL		38	/*Specular value*/
#define SHINVAL		39	/*Shininess value*/
#define CLEANUP		40	/*Clean up object message*/
#define CLOSE		41	/*Close (a window) message*/
#define STICKINESS	42	/*Stickiness of an object, flag bits*/
#define RESHAPE		43	/*Reshape a window*/
#define INITIALIZE	44	/*Initialize an object*/
#define HILITESEGMENT	45	/*Variable containing hilite segment*/
#define SURFACE		46	/*Variable containing a surface*/
#define DELTAS		47	/*Variable containing deltas in a field*/
#define ISTRANSPARENT	48	/*True iff surface is transparent*/
#define BRIGHTNESS	49	/*Brightness of a surface*/
#define ISOVAL		50	/*Isosurface value*/
#define YAW		51	/*Yaw of the eye*/
#define ROLL		52	/*Roll of the eye*/
#define PITCH		53	/*Pitch of the eye*/
#define KEYDOWN		54	/*KeyDown method*/
#define AIRSPEED	55	/*Airspeed of eye*/
#define LASTTIME	56	/*Last time eye was moved*/
#define CONNECT		57	/*Connect something, maybe a recorder*/
#define DISCONNECT	58	/*Disconnect something*/
#define PORTNUMBER	59	/*Port number for a recorder*/
#define RECORD		60	/*Record some frames*/
#define PREPARETORECORD	61	/*Prepare to record some frames*/
#define STOPRECORDING	62	/*Stop recording*/
#define SNAPONEFRAME	63	/*Snap a single frame shot*/
#define SELECT		64	/*Select an icon or something*/
#define ICONY		65	/*Y of next icon*/
#define MATERIALHUE	66	/*Hue of material*/
#define CONTROLICON	67	/*Icon for controlling stuff*/
#define PANEL		68	/*Var holding control panel for an icon or space*/
#define PANELCONTENTS	69	/*Contents for a control panel for an icon*/
#define REPICON		70	/*Icon that represents this field*/
#define MULTIDRAW	71	/*True iff all classes of objects are to be drawn*/
#define BBFLAGS		72	/*Flags for bounding box*/
#define WHICHFLAG	73	/*Which flag a check box controls*/
#define SETVAL		74	/*Method to set a value*/
#define LILSTEP		75	/*Little step in a scale*/
#define BIGSTEP		76	/*Big step in a scale*/
#define FORMAT		77	/*Format of numbers*/
#define TRACKNOT	78	/*Variable to inhibit tracking*/
#define MAXSIZE		79	/*Maximum size of objects within space*/
#define SPACE		80	/*Space to which this object belongs*/
#define PARENT		81	/*Parent of object in window*/
#define PORTIONSHOWN	82	/*Portion of a scrolled window that's shown*/
#define TIMESTEPS	83	/*Array of time steps*/
#define TIMEDATA	84	/*Data corresponding to the time steps*/
#define OWNERWINDOW	85	/*Window that owns this space*/
#define WAKEUP		86	/*Wakeup call*/
#define CLOCK		87	/*The clock in this space*/
#define TIME		88	/*Time of this space*/
#define TIMEBOUNDS	89	/*Bounds of the time, array[2] of real*/
#define FOCUSDIST	90	/*Distance of focus, relates FOCUSPOINT to EYEPOSN*/
#define SMOOTH		91	/*Boolean value of smoothness of curve*/
#define SHEAR		92	/*Shear matrix*/
#define ALIGNMENT	93	/*Alignment*/
#define WHICHDIALOG	94	/*Identifier for dialog*/
#define DTIME		95	/*Delta time per second*/
#define MARKTIME	96	/*Mark time in a time-dependant field*/
#define ANCHOR		97	/*Anchor for a slider*/
#define COLOR		98	/*Color of a something*/
#define DISPLAY		99	/*Display yourself*/
#define BUTTONPRESSED	100	/*Method when a button has been pressed*/
#define CURRENT		101	/*Current object in window clicked*/
#define KEYSTRING	102	/*String so far in a slider from keypress*/
#define READOUT		103	/*Slider readout*/
#define SETREADOUT	104	/*Method to set slider readout*/
#define MAKEDRAWN	105	/*Method to make something drawn if not already*/
#define MARK		106	/*Mark method*/
#define INHIBITDRAWING	107	/*Flag to inhibit drawing.  DrawObject looks at it*/
#define XSCALE		108	/*Scale along X dimension*/
#define YSCALE		109	/*Scale along Y dimension*/
#define ZSCALE		110	/*Scale along Z dimension*/
#define DOUBLECLICK	111	/*Double click method*/
#define NCELLS		112	/*Number of cells in a switch*/
#define OUTCELL		113	/*Which cell is the output*/
#define ISTRANSLUCENT	114	/*True iff translucent*/
#define OTHERSWITCH	115	/*Another switch*/
#define DONTCHANGE	116	/*Temporary flag meaning don't do changedvalue*/
#define MINMAX		117	/*Minimum and maximum*/
#define CPALETTE	118	/*Variable to store palette*/
#define COLOROBJ	119	/*Object waiting to be color*/
#define DROPOBJECTS	120	/*Method to drop some objects*/
#define DROPINCONTENTS	121	/*Drop in contents of something like a corral*/
#define HSCROLL		122	/*Horizontal scroll bar*/
#define VSCROLL		123	/*Vertical scroll bar*/
#define RECALCSCROLL	124	/*Recalculate scroll bars*/
#define LABEL		125	/*Label of button*/
#define ISOSLIDER	126	/*Slider for an iso value*/
#define HANDLEMISSING	127	/*Integer specifying how to handle missing data*/
#define NODES		128	/*Nodes for an unstructured grid*/
#define EDGES		129	/*Edges for an unstructured grid*/
#define CELLS		130	/*Cells for an unstructured grid*/
#define TEXTFONT	131	/*Text font*/
#define TEXTSIZE	132	/*Text size, as if you couldn't guess.*/
#define LINESPACE	133	/*Line spacing for text boxes*/
#define SPACES		134	/*List of spaces*/
#define DISPLAYCLOCK	135	/*Displayed clock in a space*/
#define MAGICDRAG	136	/*Predicate giving magic drag of a panel*/
#define FRONTPANEL	137	/*Front space panel*/
#define BACKPANEL	138	/*Back space panel*/
#define BINDTOSPACE	139	/*Method to bind a controller to a space*/
#define TOUCHSPACE	140	/*Method for a changed controller to touch a space*/
#define OBSERVER	141	/*Observer of this space.  That's YOU!*/
#define WHICHUPDATE	142	/*Place for current update*/
#define ERRORLIST	143	/*List of errors waiting*/
#define ERRORNUMBER	144	/*Currently displayed error*/
#define ERRORTEXT	145	/*TextBox of the error message*/
#define ERRORCOUNT	146	/*Number of errors*/
#define DPITCH		147	/*Change in pitch*/
#define ALWAYSCHANGE	148	/*Always do a changed value*/
#define RANGE		149	/*Range of a whatever*/
#define FILETYPE	150	/*File type*/
#define MARQUEE		151	/*Marquee around icons*/
#define LOCATION	152	/*Location of an object, usually in 3-space*/
#define LIGHTS		153	/*Individual lights in a lights class*/
#define WHATVALUE	154	/*A value for a button that changes a slider*/
#define CYCLECLOCK	155	/*Clock cycle predicate*/
#define GETVISDATASETS	156	/*Returns a dataset or list of datasets from vis obj*/
#define PANELHIDDEN	157	/*True iff the panel is hidden*/
#define ENCLOSELOW	158	/*True iff enclosing low values in isosurface*/
#define ENABLED		159	/*True iff something is enabled, like a light*/
#define FINDOBJECT	160	/*Finds an object*/
#define INTERPOLATEP	161	/*True iff we're to interpolate*/
#define RESOLVEDONE	162	/*Method to resolve a controller after spaces touched*/
#define TIMEREGISTERED	163	/*Dummy variable for registering time*/
#define LASTTIMESTEP	164	/*Size of last time step*/
#define PREFVIS		165	/*Preferred visualization*/
#define TRANSLUCENTCNT	166	/*Translucent control, if already made*/
#define TRANSPARENTCNT	167	/*Transparent control, if already made*/
#define COLORSHADING	168	/*Color shading value*/
#define LIGHTSHADING	169	/*Light shading value*/
#define COLORSHADED	170	/*Dummy dependency variable for color shaded*/
#define LIGHTSHADED	171	/*Dummy dependency variable for light shaded*/
#define PICCOLORED	172	/*Dummy dependency variable for picture colored*/
#define MAINDATASET	173	/*The main data set which sets up the time*/
#define ISOFIELD	174	/*The field that the isosurface is made from*/
#define SETMAINDATASET	175	/*Method for a vis object to accept a main field*/
#define CONTOURFIELD	176	/*Field for contours*/
#define UNSTRUCTURED	177	/*Boolean that tells if a data form is unstructured*/
#define VIEWBYWHAT	178	/*View by icon or name*/
#define VIRTUALBOUNDS	179	/*Virtual bounds of a scrolled field*/
#define BGNSEL		180	/* index of first char of text selection */
#define ENDSEL		181	/* index of last char of text selection */
#define SELECTALL	182	/* method to select all text in a textbox */
#define CALLBACK	183	/* callback method for a dialog */
#define	FILELIST	184	/* list of file lists by type */
#define SELECTOR	185	/* selector bits for file types */
#define PATH		186	/* path name to file window's directory */
#define OKMETHOD	187	/* method to call when OK button pressed */
#define SHOWFILES	188	/* method to show files in a corral */
#define REGISTERFIELD	189	/*Method to register a field*/
#define HIDDEN		190	/*True iff a visualization object is hidden*/
#define ICONGREYED	191	/*Greyed (an icon*)*/
#define WHICHPREF	192	/*Which preference a control deals with*/
#define HIGHLIGHTCOLOR	193	/*Color of a highlight*/
#define HIDE		194	/*Hide method*/
#define CLONE		195	/*Clone yourself method*/
#define ACTIVATED	196	/*Object is activated*/
#define ICONEXTRADRAW	197	/*Method to draw extra stuff for an icon*/
#define CURDATA		198	/*Current data*/
#define CMODERADIO	199	/*Color map radio button for a window*/
#define RENDERER	200	/*Renderer for a space*/
#define RENDERTYPE	201	/*Type of renderer*/
#define FILTERTYPE	202	/*Type of image filter*/
#define ENTERMETHOD	203	/*Method to call when enter key pressed in object*/
#define KEDGES		204	/*K-edges*/
#define DELETEICON	205	/*Message to send an icon to delete its repobj before deleting*/
#define CORRAL		206	/*Corral assoc with a space or window*/
#define VISBUTTON	207	/*The vis button for a corral*/
#define SHOWCNTBUTTON	208	/*Show controls button*/
#define TIMEPERPIXEL	209	/*Time per pixel on screen in time control*/
#define PREFIXDATASETS	210	/*Method to have a vis object prefix datasets it uses*/
#define DATASETS	211	/*Datasets of a clock*/
#define DISPLAYSTEP	212	/*Step for displaying time*/
#define DISPLAYTICS	213	/*Number of tics per time step*/
#define TIMECONTROL	214	/*A time control in a dialog*/
#define AUTOSCROLL	215	/*Autoscroll message*/
#define REINIT		216	/*Reinitialize controller*/
#define TIMEFORMAT	217	/*Format of time associated with dataset*/
#define CUT		218	/*Method to cut from something*/
#define COPY		219	/*Method to copy from something*/
#define PASTE		220	/*Method to paste on something*/
#define CLEAR		221	/*Method to clear something*/
#define TOPVARS		222	/*Topological variables*/
#define LASTINTERP	223	/*Last value of interpolate*/
#define VALUESET	224	/*Predicate, means new set value has been registered once*/
#define ROTATING	225	/*Of a space, predicate saying we are rotating*/
#define MOVING		226	/*Of a space, true iff moving*/
#define HELPSTRING	227	/*The help string of an object for the default help system*/ 
#define BORDERTYPE	228	/*Type of border, on a panel*/
#define HELPCONTENTS	229	/*Array of contents for help*/
#define HELPRADIO	230	/*Radio button in a help dialog*/
#define TYPESTRING	231	/*type string*/
#define	MAKE1HELPSTRING	232	/*Makes the help string*/
#define SINGLECORRAL	233	/*True iff corral can only hold one icon*/
#define REGISTERCOMP	234	/*Method to register a component*/
#define XFIELD		235	/*Field for X of trace*/
#define YFIELD		236	/*Field for Y of trace*/
#define ZFIELD		237	/*Field for Z of trace*/
#define XTOPDIM		238	/*Topological dimension for X*/
#define YTOPDIM		239	/*Topological dimension for Y*/
#define ZTOPDIM		240	/*Topological dimension for Z*/
#define ORTHO		241	/*Predicate to see if a perspec control is ortho*/
#define NCOMPONENTS	242	/*Number of components for a vector dataset or null for scalar*/
#define INDICES		243	/*Indices for array*/
#define COLORCELLS	244	/*What kind of color cells*/
#define ZDISPLACED	245	/*True iff z is displaced*/
#define VISASBUTTON	246	/*Visualize As button*/
#define PARENTS		247	/*List of parents*/
#define SLIDER		248	/*A slider a text box represents*/
#define CHANGED		249	/*Dummy variable used sometimes to indicate data changed*/
#define PALETTESET	250	/*Set if a color palette is set in a dataset*/
#define COLORWHEEL	251	/*Color control*/
#define KEPTPALETTE	252	/*The kept palette*/
#define COLORBAR	253	/*A color bar with which a slider or colorwheel works*/
#define OLDCOLORS	254	/*Old colors to revert to*/
#define BUTTON		255	/*A random button*/
#define TEMPPALETTE	256	/*Temporary palette*/
#define INITVALUE	257	/*Initial value of something*/
#define KEEPBUTTON	258	/*Keep button*/
#define REVERTBUTTON	259	/*Revert button*/
#define PALETTEFUNC	260	/*Palette function*/
#define FULLCOMPBUTTONS	261	/*List of buttons to activate or deactivate on full and components*/
#define COMPBUTTONS	262	/*List of buttons to activate or deactivate on components*/
#define EDITMODE	263	/*The edit mode, esp. of a color bar*/
#define TOOLGROUP	264	/*Group of tools*/
#define FUNCTIONBOX	265	/*Box that controls a function*/
#define FREEFORMBUTTON	266	/*Button for free form tool*/
#define HALTHELP	267	/*Halt help search predicate*/
#define NCOLORBOX	268	/*Box for ncolors*/
#define MINBOX		269	/*Box for min*/
#define MAXBOX		270	/*Box for max*/
#define REGISTERFORM	271	/*Register data form*/
#define JUSTCOLORCHANGE	272	/*Just the colors changed*/
#define GETTOPDIM	273	/*Get topological dimension*/
#define INITFILTER	274	/*Initialize filter*/
#define GETSPATIALDIM	275	/*Get spatial dimension*/
#define GETDATASETINFO	276	/*Get dataset info*/
#define SETRGBMESSAGE	277	/*Message to set to RGB*/
#define DIMVALUES	278	/*Array of dimension values*/
#define GETFORMDIMS	279	/*Method to get form dimensions*/
#define OPENBTN		280	/*Open button in file window*/
#define SETFORMATBTN	281	/*Set Format button in file window*/
#define SHOWINFOBTN	282	/*Show Info button in file window*/
#define FILEINFO	283	/*Text box in file information window*/
#define WHICHDIMENSION	284	/*Which dimension a slider controls*/
#define TOPDOWN		285	/*Predicate of field, true iff top down*/
#define VIEWTYPE	286	/*Type of view*/
#define EYEOFFSET	287	/*Offset of individual eyes*/
#define PERSPECCONTROL	288	/*Perspective control of this radio group*/
#define OLDVALUE	289	/*Old value for something*/
#define INTERPCOLORS	290	/*True iff interp colors*/
#define DRAWSURFACE	291	/*Draw the surface*/
#define DRAWWIREFRAME	292	/*Draw the wire frame*/
#define VECTORFACTOR	293	/*Factor for vector displays*/
#define SHAFTWIDTH	294	/*Width of an arrow's shaft*/
#define	HEADWIDTH	295	/*Width of an arrow's head*/
#define HEADLENGTH	296	/*Length of an arrow's head*/
#define GETLONGNAME	297	/*Returns long name of an object*/
#define WHICHVAR	298	/*Which var for numeric text*/
#define TEMPLATEP	299	/*True iff the object is a template*/
#define ALLFILTERS	300	/*Method to get all filters*/
#define DISPOSE		301	/*Dispose method for a window*/
#define READALL		302	/*Read all of a file method*/
#define OLDREAD		303	/*Old style file read routine, NOT method style*/
#define EXTENSION	304	/*Extension for file reader*/
#define TIMEDDATASETS	305	/*Timed datasets flags*/
#define OUTOFBOUNDS	306	/*Integer specifying how to handle out of bounds*/
#define TICDENSITY	307	/*Tic mark density*/
#define TICLENGTH	308	/*Length of tic marks*/
#define SPHERESUBDIV	309	/*Sphere subdivisions*/
#define FRUSTUMSUBDIV	310	/*Subdivision of a frustum*/
#define CAPENDSP	311	/*Cap ends predicate*/
#define ETERNALPART	312	/*Eternal portion of a picture*/
#define YOURENOTCURRENT	313	/*You're not current anymore message*/
#define HIDEPANEL	314	/*True iff window has panel to hide*/
#define MINMAJORSTEP	315	/*Number of pixels minimum in major step*/
#define COLORBYFIELD	316	/*Color text by field*/
#define CHECKBOX	317	/*A check box*/
#define SHOWOVERUNDER	318	/*Show over and under*/
#define SHOWMISSING	319	/*Show missing data*/
#define NUMBERSONLY	320	/*Numbers only*/
#define SHOWMINORTICS	321	/*Show minor tics*/
#define ROTAXIS		322	/*Axis of rotation*/
#define ROTSPEED	323	/*Rotation speed*/
#define FLYING		324	/*F L Y I N ---- G predicate*/
#define DEFORMOBJ	325	/*Deformation object*/
#define DEFCONSTANT	326	/*Constant deformation*/
#define DEFOFFSET	327	/*Offset of deformation*/
#define DEFFACTOR	328	/*Factor of deformation*/
#define DEFORMSWITCH	329	/*Value of deform switch*/
#define REVERSESENSE	330	/*Reverse order of contour*/
#define COLORMODEL	331	/*Color model for palette*/
#define CMODELRADIO	332	/*Color model radio button*/
#define FILENAME	333	/*Name of file where a dataset was found*/
#define DIRECTORY	334	/*Name of directory where a dataset was found*/
#define SAVECPANEL	335	/*Method to save the controls of an object*/
#define SAVEALLCONTROLS	336	/*Method to save all the indiv. controls of an object*/
#define CONTOURLINES	337	/*List of contour lines in an object*/
#define STARTVALUE	338	/*Starting value of a contour line*/
#define PICDEFORMED	339	/*Dummy variable for deformed picture*/
#define CONNECTIONSTATE 340	/*State of a connection*/
#define INHIBITLOGGING	341	/*Control predicate, inhibits logging*/
#define TIMEOUT		342	/*Timeout message*/
#define CURCMD		343	/*Current command being assembled*/
#define CMDPROCNAME	344	/*Command process name*/
#define ALLPROCESSES	345	/*All processes in a connection*/
#define OBJPANEL	346	/*A space's object panel*/
#define TOOLPANEL	347	/*A space's tool panel*/
#define ESCAPED		348	/*Connection is escaped*/
#define EDITTOOL	349	/*Edit tool*/
#define LINEWIDTH	350	/*Line width*/
#define COLORWIDTH	351	/*Width of a color bar in a palette display*/
#define TEXTWIDTH	352	/*Width of text on a palette display*/
#define STARTPOINT	353	/*Starting location (for a line)*/
#define ENDPOINT	354	/*Ending location (for a line)*/
#define ARROWHEAD	355	/*Of a line, are there arrowheads at each side*/
#define READER		356	/* reader for a file */
#define FIELD		357	/* control field */
#define OPEN		358	/* open message */
#define CLASSID		359	/*ID of a class*/
#define ONEONLY		360	/*One only predicate, of a controller in a space*/
#define TWOSIDEDSURFACE	361	/*Two-sided surface predicate*/
#define CONTROLLERP	362	/*True iff it's a controller*/
#define SHOWGRID	363	/*True iff show grid*/
#define FUNCTIONBUTTONS 364	/*List of function buttons in a window*/
#define SHOWCONTROLS	365	/*Show controls method of an object*/
#define DOFUNCTION	366	/*Deferred message for an object function button*/
#define VISUALIZE	367	/*Visualize an object*/
#define VISUALIZEAS	368	/*Visualize an object as...*/
#define MODIFY		369	/*Modify datasets*/
#define DELETE		370	/*Delete yourself from current window*/
#define SHOW		371	/*Show an object, opposite of hide*/
#define DUPLICATE	372	/*Duplicate an object*/
#define LOCALCOPY	373	/*Make local copy*/
#define PICKUP		374	/*Pick up an object*/
#define COLLECT		375	/*Collect object into a list*/
#define FORALLOBJECTS	376	/*For all objects method*/
#define APPEARANCE	377	/*Appearance of an object*/
#define BEVELED		378	/*Beveled style predicate*/
#define SHADOW		379	/*Shadow int variable*/
#define BINOCULARITY	380	/*Binocular distance*/
#define BRINGTOTOP	381	/*Bring object to top*/
#define PUSHTOBOTTOM	382	/*Push object to bottom*/
#define MOVETOBACKPANEL	383	/*Move to back panel*/
#define MOVETOFRONTPANEL 384	/*Move to front panel*/
#define MESHFIELD	385	/*Field for the mesh*/
#define CONTOURCENTER	386	/*Center value of contour*/
#define CONTOURSTEP	387	/*Step of contour*/
#define CONTOURMAX	388	/*Maximum value of contour*/
#define CONTOURDIV	389	/*Divisions of contour*/
#define CONTOURMIN	390	/*Minimum value of contour*/
#define CONTOURMAJWIDTH	391	/*Major width of contours*/
#define CONTOURMINWIDTH	392	/*Minor width of contours*/
#define DEFERLASTKEY	393	/*Defer the last keystroke*/
#define XNAME		394	/*Name of X axis*/
#define YNAME		395	/*Name of Y axis*/
#define ZNAME		396	/*Name of Z axis*/
#define READVECTOR	397	/*Read vector data*/
#define DTIMEPER	398	/*Delta time per second*/
#define RUNSPEED	399	/*Control integer for running*/
#define RUNCONTROL	400	/*Running radio button*/
#define DTIMEUNITS	401	/*Units for delta time*/
#define DTIMEPERUNITS	402	/*Units for delta time per*/
#define TIMESTEP	403	/*Time step in a clock*/
#define SHOWPANEL 	404	/*Show a panel*/
#define CONNECTIONKIND	405	/*Kind of connection*/
#define MOVESKELETON	406	/*True iff move skeleton*/
#define CONNECTTOPROCESS 407	/*Connect to a process*/
#define OUTPUTQUEUE	408	/*Output queue for a connection*/
#define OWNERCONNECTION	409	/*The connection of a process*/
#define CMDPROCSOCKET	410	/*Socket for a proc*/
#define ALLOBJECTS	411	/*All objects of a proc*/
#define SOCKETID	412	/*Socket a process wants to connect*/
#define OBJECTID	413	/*ID of object*/
#define ADVERTISED	414	/*Of an object, true iff advertised*/
#define ADVERTISE	415	/*Advertise obj function*/
#define UNADVERTISE	416	/*Unadvertise obj function*/
#define OLDCONNSTATE	417	/*Old connection state*/
#define OWNERPROCESS	418	/*Process that owns this connection*/
#define READNUMBERONE	419
#define READNUMBERTWO	420
#define READNUMBERTHREE	421
#define RECEIVEEXTRA	422
#define NETWORKID	423
#define TRANSMITEXTRA	424
#define ALLADVERTISED	425	/*Advertised objects of a process*/
#define TARGETOBJECT	426	/*Target for an incoming object*/
#define TARGETVAR	427
#define NEWREMOTEOBJ	428	/*New remote object method*/
#define BOUNDSINVALID	429	/*Bounds invalid method*/
#define SHOWBOUNDS	430	/*Show bounds predicate*/
#define PREFWIDTH	431	/*Preferred width of an object*/
#define PREFHEIGHT	432	/*Preferred height of an object*/
#define INNERSOFTMARGIN	433	/*Inner soft margin*/
#define OUTERSOFTMARGIN	434	/*Outer soft margin*/
#define SHOWROTGUIDES	435	/*Show rotation guides*/
#define SHOWMOTGUIDES	436	/*Show motion guides*/
#define SHOWFRAME	437	/*Of a window, show the frame*/
#define HIDEFRAME	438	/*Of a window, hide the frame*/
#define SPACEWINDOW	439	/*Space window of this window if any*/
#define SETTORGBMODE	440	/*Message to set a window to RGB mode*/
#define SETTOCMAPMODE	441	/*Message to set a window to CMAP mode*/
#define CHANGEDBOUNDS	442	/*Bounds which have been changed*/
#define BUFFER0		443	/*State of window buffer 0*/
#define BUFFER1		444	/*State of window buffer 1*/
#define WHICHBUFFER	445	/*Which buffer pointed to*/
#define SUBWINDOWS	446	/*Sub windows*/
#define SUPERWINDOW	447	/*Super window of this window*/
#define SUBWINDOWMARGIN	448	/*Margin for a subwindw*/
#define OPAQUE		449	/*Opaque predicate of object within panel*/
#define BACKNOTNEEDED	450	/*Drawing of background not needed*/
#define TEMPOBSCURED	451	/*Temporary obscuring for interaction*/
#define READNUMBERFOUR	452
#define VIEWFIELD	453	/*Field of view for an observer*/
#define VIEWCLIP	454	/*Two clipping planes for an observer*/
#define UPVECTOR	455	/*Up vector of an observer*/
#define FORWARDVECTOR	456	/*Forward vector of an observer*/
#define IMINVALID	457	/*Message for non-standard iminvalid*/
#define SPACECENTER	458	/*Center of space*/
#define SPACESCALE	458	/*Scale of space*/
