/*ScianWindows.h
  Routines for windows in scian
  Eric Pepke
  March 8, 1990
*/

#ifndef _H_WINDOWS
#define _H_WINDOWS

/*Flags for a window*/
#define WINRGB		1		/*Window wants to be RGB*/
#define WINDBUF		2		/*Window wants to be double buffered*/
#define WINZBUF		4		/*Window wants to be Z-buffered*/
#define WINSHRINK	8		/*Anti-alias shrink*/
#define WINFIXEDSIZE	16		/*Fixed size window*/
#ifdef NOHIDEFRAME
#define WINNOFRAME	0		/*Must have window frame*/
#else
#define WINNOFRAME	32		/*No window frame*/
#endif
#define WINCENTERED	64		/*Center the window*/

/*Menus, must go from 0 to NMENUS - 1*/
#define FILEMENU	0		/*"File" menu*/
#define NETWORKMENU	1		/*"Network" menu*/
#define DATASETSMENU	2		/*"Datasets" menu*/
#define OBJECTMENU	3		/*"Object" menu*/
#define TEXTMENU	4		/*"Space" menu*/
#define WINSIZEMENU	5		/*"Window Size" submenu*/
#define WINDOWSMENU	6		/*"Windows" menu*/
#define ARRANGEMENU	7		/*"Arrange" submenu*/
#define NMENUS		8		/*Number of menus*/

/*Values for picState*/
#define FG		2		/*Bit for front good*/
#define BG		1		/*Bit for back good*/
#define FBBB		0		/*Front buffer bad,  back buffer bad */
#define FBBG		BG		/*Front buffer bad,  back buffer good*/
#define FGBB		FG		/*Front buffer good, back buffer bad */
#define FGBG		(FG | BG)	/*Front buffer good, back buffer good*/

/*Values for drawingQuality*/
#define DQ_SKELETON     0               /*Draw as skeleton*/
#define DQ_WIREFRAME    1               /*Draw as a wire frame*/
#define DQ_FULL         2               /*Draw with full quality*/
#define DQ_NQUALITIES	3		/*Number of qualities*/

extern int drawingQuality;              /*Current drawing quality*/
extern int movingDrawingQuality;        /*Current moving drawing quality*/

typedef struct				/*Menu item within window*/
    {
	int menu;			/*Which menu the item is in*/
	char name[256];			/*Name of the menu item*/
	void (*action)();		/*Action of the menu item*/
    } MenuItem;

#define MAXNMENUITEMS	20		/*Maximum number of menu items per window*/

typedef struct win			/*Window information structure*/
    {
	Thing thing;			/*Thing part of the window*/
	long id;			/*Window identifier*/
	long flags;			/*Flags for the window*/
	struct win *next;		/*Next window record in the list*/
	long mainMenu;			/*Main menu, or 0 for none*/
	long subMenus[NMENUS];		/*Submenus*/
	int ol, or, ot, ob;		/*Old bounds*/
	int nl, nr, nt, nb;		/*New bounds*/
	char winTitle[256];		/*Title of the window*/
	int nMenuItems;			/*Number of menu items*/
	MenuItem menuItems[MAXNMENUITEMS];
	int minWidth, maxWidth;
	int minHeight, maxHeight;
    } WinInfo, *WinInfoPtr;

extern char *menuName[NMENUS];
extern WinInfoPtr inputWindow;		/*Current window for input or 0*/
extern WinInfoPtr selWinInfo;           /*Info for currently selected window*/
#ifdef GRAPHICS
#define SelectWindow(i) selWinInfo = GetWinInfo(i); if (selWinInfo) {winset(i);\
		curDisplayMode = getdisplaymode();\
		rgbp = (curDisplayMode == DMSINGLE || curDisplayMode == DMDOUBLE) ? false : true;}

#if 1
#define SelWindow(w) selWinInfo = w; if (w && ((WinInfoPtr) w) -> id) {winset(((WinInfoPtr) w) -> id);\
		curDisplayMode = getdisplaymode();\
		rgbp = (curDisplayMode == DMSINGLE || curDisplayMode == DMDOUBLE) ? false : true;}
#else
void SelWindow(WinInfoPtr w);
#endif
#else
#define SelectWindow(i) selWinInfo = GetWinInfo(i); if (selWinInfo) { \
		rgbp = true; }
#define SelWindow(w) selWinInfo = w;
#endif

extern int curDisplayMode;		/*Display mode of current window*/
extern Bool rgbp;			/*rgb predicate*/
extern ObjPtr windowClass;		/*Class of all windows*/
typedef int WindowID;			/*Machine-specific window identifier*/
extern WinInfoPtr allWindows;		/*All the windows*/
extern int updateBatch;			/*Current batch of updates*/
extern int recScrWidth, recScrHeight;	/*Width and height of recording screen*/
extern short curCursor;			/*Current cursor*/
extern Bool showControlPanels;		/*Show subsequent control panels*/

#ifdef PROTO
void ResetMovingQuality(void);
WinInfoPtr NewWinInfo(ObjPtr, long, long, char *, int, int, int, int);
WinInfoPtr GetWinInfo(long);
WinInfoPtr GetWinFromTitle(char *);
Bool DisposeAllWindows(void);
Bool IdleAllWindows(void);
void DrawWindow(long);
void ArrowWindow(long, long);
void DoToggleColorMode(void);
void DoToggleShrinkMode(void);
void DoMaxScreen(void);
void DoVideoScreen(void);
void Do2VideoScreen(void);
void DoPhscoScreen(void);
int ReshapeWindow(ObjPtr);
void InitWindows(void);
void KillWindows(void);
WindowID NewOpenedWindow(char *, int, int, int, int, long);
void BuildMenu(WinInfoPtr);
void DefineMenuItem(ObjPtr, int, char *, void (*action)());
void SetWindowTitle(ObjPtr, char *);
void MySetCursor(int);
void DeleteMenus(WinInfoPtr);
void SetMode(WinInfoPtr);
void LocateWindow(int, int, int, int);
void SetShrink(WinInfoPtr, Bool);
void SetMinSize(WinInfoPtr, int, int);
void PopWindow(WinInfoPtr);
void PushWindow(WinInfoPtr);
void SaveScreen(WinInfoPtr, int);
#ifdef GRAPHICS
#ifdef WINDOWS4D
void GetWindowBounds(int *, int *, int *, int *);
void GetWindowOrigin(int *, int *);
#endif
#endif
void ForAllWindows(void (*routine)());
Bool IsValidWindow(WinInfoPtr);
void PopDatasetsWindow(void);
WinInfoPtr WhichWindow(int x, int y);
#else
void ResetDrawingQuality();
WinInfoPtr NewWinInfo();
WinInfoPtr GetWinInfo();
WinInfoPtr GetWinFromTitle();
Bool DisposeAllWindows();
Bool IdleAllWindows();
void DoToggleShrinkMode();
void DrawWindow();
void ArrowWindow();
void DoMaxScreen();
void DoVideoScreen();
void Do2VideoScreen();
void DoPhscoScreen();
int ReshapeWindow();
void InitWindows();
void KillWindows();
WindowID NewOpenedWindow();
void BuildMenu();
void DefineMenuItem();
void SetWindowTitle();
void MySetCursor();
void DeleteMenus();
void SetMode();
void LocateWindow();
void SetShrink();
void SetMinSize();
void PopWindow();
void PushWindow();
void SaveScreen();
#ifdef GRAPHICS
#ifdef WINDOWS4D
void GetWindowBounds();
void GetWindowOrigin();
#endif
#endif
void ForAllWindows();
Bool IsValidWindow();
void PopDatasetsWindow();
WinInfoPtr WhichWindow();
#endif

#endif
