/*ScianSpaces.h
  Public stuff for ScianSpace.c
*/

extern Matrix Identity;

extern ObjPtr curSpace, spaceClass, observerClass;
extern real spaceTime;			/*Time of the current space*/
extern ObjPtr controllerClass, spacePanelClass, spaceBackPanelClass;
extern Bool oneObserver, oneClock, oneLights, oneRenderer;
extern Bool drawingTransparent;

/*Is space predicate*/
#define IsSpace(object) IntVarEql(object, CLASSID, CLASS_SPACE)

/*Values for drawing*/
#define DRAWSPACE	1		/*Drawing in a space*/
#define PICKSPACE	2		/*Picking in a space*/
#define ROTSPACE	3		/*Rotating in a space*/
#define MOVESPACE	4		/*Moving a space*/

/*Running controls*/
#define RC_FAST_REVERSE	4		/*Fast reverse*/
#define RC_REVERSE	2		/*Reverse*/
#define RC_STOP		0		/*Stop*/
#define RC_FORWARD	1		/*Forward*/
#define RC_FAST_FORWARD	3		/*Fast forward*/

/*Values for whichview*/
#define VIEW_CENTER	1		/*Draw from center*/
#define VIEW_XLEFT	2		/*Crosseyed left*/
#define VIEW_XRIGHT	3		/*Crosseyed right*/
#define VIEW_RCLEFT	4		/*Red/scian left*/
#define VIEW_RCRIGHT	5		/*Red/scian right*/
#define VIEW_ORTHO	6		/*Orthographic center view*/

/*Values for renderer type, 0 through whatever*/
#define RT_NONE		0		/*No renderer*/
#define RT_HARDWARE	1		/*Hardware renderer*/

/*Valued for filter type, 0 through whatever*/
#define FT_NONE		0		/*No filter*/
#define FT_SHRINK	1		/*Shrink filter*/
#define FT_4AVERAGE	2		/*Average 4 neighbors*/		

/*Values for view type*/
#define VT_PERSPECTIVE	0		/*Perspective view*/
#define VT_ORTHOGRAPHIC	1		/*Orthographic view*/
#define VT_CROSSEYED	2		/*Crosseyed stereo*/
#define VT_REDCYAN	3		/*Red/Cyan stereo*/

/*Values for space tool.  Must agree with button order*/
#define ST_MOVEROTATE	0		/*Move/rotate tool*/
#define ST_FINGER	1		/*Finger*/
#define ST_ANNOTATION	2		/*Annotation*/
#define ST_RECTANGLE	3		/*Rectangle*/
#define ST_LINE		4		/*Line*/
#define ST_TIME_READOUT	5		/*Clock*/

/*Is controller predicate*/
#define IsController(object) GetPredicate(object, CONTROLLERP)
#define IsObserver(object) IntVarEql(object, CLASSID, CLASS_OBSERVER)
#define IsClock(object) IntVarEql(object, CLASSID, CLASS_CLOCK)
#define IsRenderer(object) IntVarEql(object, CLASSID, CLASS_RENDERER)


#ifdef PROTO
ObjPtr NewSpace(int, int, int, int);
Bool AddObjToSpace(ObjPtr, ObjPtr, ObjPtr, ObjPtr, ObjPtr);
Bool AddControllerToSpace(ObjPtr, ObjPtr, ObjPtr, ObjPtr);
Bool SetFocus(ObjPtr);
ObjPtr NewClock(void);
ObjPtr NewObserver(void);
ObjPtr NewRenderer(void);
void SetClock(ObjPtr, real);
void ResolveController(ObjPtr);
void ReinitController(ObjPtr);
ObjPtr ShowIconControls(ObjPtr);
ObjPtr MakeClockDatasets(ObjPtr);
void PrintClock(char *, char *, real);
void GetSliderRange(ObjPtr slider, real *loValue, real *hiValue);
void SetRotationMotor(real, real, real, real);
Bool RotateObserver(ObjPtr, real axis[3], real, Bool);
Bool RotateLights(ObjPtr, real axis[3], real, Bool, ObjPtr, ObjPtr);
#else
ObjPtr NewSpace();
Bool AddObjToSpace();
Bool SetFocus();
Bool AddControllerToSpace();
ObjPtr NewClock();
ObjPtr NewObserver();
ObjPtr NewRenderer();
void SetClock();
void ResolveController();
void ReinitController();
ObjPtr ShowIconControls();
ObjPtr MakeClockDatasets();
void PrintClock();
void GetSliderRange();
void SetRotationMotor();
Bool RotateObserver();
Bool RotateLights();
#endif
