/*ScianClient.c
  Eric Pepke
  April 27, 1990
  Client stuff for doing commands over the network to scian
*/

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include "ScianSockets.h"

int inSocket;			/*The internet socket*/

char buf[257];			/*Temporary buffer*/

#define TOLOWER(c) ((c >= 'A' && c <= 'Z') ? c - 32 : c)
#define TIMEOUT	(5 * HZ)	/*Number of ticks before timeout*/

long times();

static long GetRetValue()
/*Returns the ret value*/
{
    struct tms theTimeBuffer;
    long startTime;
    long endTime;
    long retVal;

    startTime = times(&theTimeBuffer);
    do
    {
	if (sizeof(long) == read(inSocket, &retVal, sizeof(long)))
	{
	    return retVal;
	}
    } while (times(&theTimeBuffer) < startTime + TIMEOUT);
    fprintf(stderr, "GetRetValue: Time out on socket link\n");
    return 0;
}

static u_short SocketPort()
/*Returns the port for the socket*/
{
    return htons((u_short) 3738);
}

static struct hostent *Host()
/*Returns the name of the host to which to connect, or 0*/
{
    return gethostbyname("scri4d.scri.fsu.edu");
}

SendCmd(sock, cmd)
int sock;
long cmd;
/*Sends cmd over socket sock  Args follow cmd*/
{
    /*Write the command name*/
    printf("Sending %ld\n", cmd);
    write(sock, &cmd, (unsigned) sizeof(cmd));
}

fortran int sinit_()
/*Initializes connection  Returns 1 iff successful, 0 if not.*/
{
    struct sockaddr_in inSocketAddr;
    int proto;
    struct hostent *host;
    int k;

    /*See if the host exists*/
    host = Host();
    if (host)
    {
	for (k = 0; k < sizeof(inSocketAddr); ++k)
	{
	    *(k + (char *) &inSocketAddr) = 0;
	}
	for (k = 0; k < host -> h_length; ++k)
	{
	    *(k + (char *) &inSocketAddr . sin_addr) =
		*(k + (char *) host -> h_addr);
        }
    	inSocketAddr . sin_port = SocketPort();/*Port number 3737*/
    	inSocketAddr . sin_family = PF_INET;		/*Internet socket*/

	proto = getprotobyname("tcp") -> p_proto;
    	inSocket = socket(PF_INET, SOCK_STREAM, proto);
   	if (inSocket >= 0)
    	{
	    int status;

	    status = connect(inSocket, (char *) &inSocketAddr, sizeof(inSocketAddr));
	    if (status >= 0)
	    {
		/*Successful connection*/
		fcntl(inSocket, F_SETFL, 
			fcntl(inSocket, F_GETFL) | FNDELAY);
 		return 1;
	    }
	    else
	    {
		fprintf(stderr, "connect failed\n");
		perror("SINIT");
		return 0;
	    }
	}
	else
	{
	    fprintf(stderr, "socket failed\n");
	    perror("SINIT");
	    return 0;
	}
    }
    else
    {
	fprintf("gethostbyname failed\n");
	perror("SINIT");
	return 0;
    }
}

fortran void sclose_()
/*Closes the socket connection*/
{
    SendCmd(inSocket, SDISCONNECT);
    close(inSocket);
}

fortran long snwin_()
/*Creates a window and returns it's identifier*/
{
    SendCmd(inSocket, SNEWOBJWINDOW);
    return GetRetValue();
}

