/*ScianVisWindow.h
  Public stuff for ScianVisWindow.c
  Eric Pepke
  April 6, 1990
*/

#define MESHMATERIAL	2

/*Is viswindow predicate*/
#define IsVisWindow(object) IntVarEql(object, CLASSID, CLASS_VISWINDOW)

ObjPtr MakeLocalCopy();

/*Function prototypes*/
#ifdef PROTO
ObjPtr NewTimeReadout(int, int, int, int, char *name, ObjPtr space);
WinInfoPtr NewVisWindow(char *, long);
void VisObjects(void);
void VisObjectsAs(void);
ObjPtr FindSpace(WinInfoPtr);
ObjPtr FindObserver(WinInfoPtr);
ObjPtr FindPerspecControl(WinInfoPtr);
void RotateOrthoWindow(WinInfoPtr, char, float);
void RotateWindowTo(WinInfoPtr, Matrix);
void ShowPanel(void);
void HidePanel(void);
void DoShowControls(void);
void ShearOrthoWindow(WinInfoPtr window, float amount);
void DoShowClock();
void InitVisWindows(void);
void KillVisWindows(void);
void ForAllVisWindows(void (*routine)());
void DoShowPanel(void);
void DoHidePanel(void);
void DoMakeLocalCopy(void);
void AddLine(char *, int, int, int, int);
void AddRectangle(char *, real bounds[4]);
void NewSerializedVisWindow(void);
void NewVisAsWindow(void);
void ProcessVisAsList(void);
ObjPtr CloneObject(ObjPtr);
void DoShowFrontPanelControls(void);
void DoShowBackPanelControls(void);
void DoShowSpaceControls(void);
void AddToVisualizeAsList(ObjPtr);
#else
ObjPtr NewTimeReadout();
WinInfoPtr NewVisWindow();
void VisObjects();
void VisObjectsAs();
ObjPtr FindSpace();
ObjPtr FindObserver();
ObjPtr FindPerspecControl();
void RotateOrthoWindow();
void RotateWindowTo();
void ShowPanel();
void HidePanel();
void DoShowControls();
void ShearOrthoWindow();
void DoShowClock();
void InitVisWindows();
void KillVisWindows();
void ForAllVisWindows();
void DoShowPanel();
void DoHidePanel();
void DoMakeLocalCopy();
void AddLine();
void AddRectangle();
void NewSerializedVisWindow();
void NewVisAsWindow();
ObjPtr CloneObject();
void DoShowFrontPanelControls();
void DoShowBackPanelControls();
void DoShowSpaceControls();
void ProcessVisAsList();
void AddToVisualizeAsList();
#endif
