/*ScianTrackControls.c
  Eric Pepke
  7 February 1993

  Track controls for SciAn

  Track controls are used to edit time tracks, such as for keyframe animation.
*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianLists.h"
#include "ScianControls.h"
#include "ScianButtons.h"
#include "ScianTitleBoxes.h"
#include "ScianTextBoxes.h"
#include "ScianColors.h"
#include "ScianIDs.h"
#include "ScianSliders.h"
#include "ScianArrays.h"
#include "ScianErrors.h"
#include "ScianWindows.h"
#include "ScianDraw.h"
#include "ScianIcons.h"
#include "ScianMethods.h"
#include "ScianStyle.h"
#include "ScianHelp.h"
#include "ScianPreferences.h"
#include "ScianSymbols.h"
#include "ScianTrackControls.h"

static ObjPtr trackControlClass;	/*Class of all track controls*/



void InitTrackControls()
/*Initializes the track controls*/
{
    trackControlClass = NewObject(controlClass, 0L);
    AddToReferenceList(trackControlClass);
}

void KillTrackControls()
/*Kills the track controls*/
{
    RemoveFromReferenceList(trackControlClass);
}
