#include "salem.h"

make_vertex_colors(obj)
object_t *obj;
{
	int 		*r, *g, *b, fr, fg, fb, vno, vo, i, j;
	polygon_t 	*fp;
	vertex_t 	*vp;

	r = N_NEW(obj->n_vertices, int);
	g = N_NEW(obj->n_vertices, int);
	b = N_NEW(obj->n_vertices, int);

	for (i=0, vp = obj->v_list; i < obj->n_vertices; i++, vp++ )	{
		r[i] = g[i] = b[i] = 0;
		vp->order = 0;
		}
	for (i=0, fp = obj->polygons; i < obj->n_polygons; i++, fp++ )	{
		extract_color_triple(fp->fastcolor, &fr, &fg, &fb);
		for (j = 0 ; j < fp->n_vertices ; j++ )	{
			vno = Vint(fp->v[j],obj->v_list);
if ( (vno < 0) || ( vno > obj->n_vertices) ) printf(" hiccup, vno is %d\n",vno);
			r[vno] += fr;
			g[vno] += fg;
			b[vno] += fb;
			obj->v_list[vno].order++;
			}
		}
	for (i=0, vp = obj->v_list; i < obj->n_vertices; i++, vp++ )    {
		vo = vp->order;
		if (vo > 0)	{
			vp->fastcolor=int_color_triple(r[i]/vo,g[i]/vo,b[i]/vo);
			vp->colored = TRUE;
			}
		}
	free(r);
	free(g);
	free(b);
}

make_vertex_normals(obj)
object_t *obj;
{
	int 		i;
	double 		length;
	vertex_t	*vp;

	for (i = 0, vp = obj->v_list; i < obj->n_vertices ; i++, vp++ )	{
		length = sqrt(vp->normal[0] * vp->normal[0] + 
			vp->normal[1] * vp->normal[1] + 
			vp->normal[2] * vp->normal[2]);
		if (length > 0.0)	{
			vp->normal[0] /= length;
			vp->normal[1] /= length;
			vp->normal[2] /= length;
			}
		}
}

random_face_color()
{
	return( int_color_triple(rand()%256,rand()%256,rand()%256));
}

make_normal(p)
polygon_t*	p;
{
	double		normal[3];
	double		d1[3],d2[3];
	vertex_t	**pp = p->v;
	int		j,k;
	normal[0] = normal[1] = normal[2] = 0.0;
	for (j = 0; j < p->n_vertices; j++) {
		for (k = 0; k < 3; k++) {
			d1[k]= pp[j]->position[k]-pp[(j+1)%p->n_vertices]->position[k];
			d2[k]= pp[(j+1)%p->n_vertices]->position[k]
				-pp[(j+2)%p->n_vertices]->position[k];
		}
		normal[0]+= d1[1]*d2[2]-d1[2]*d2[1];
		normal[1]+= d1[2]*d2[0]-d1[0]*d2[2];
		normal[2]+= d1[0]*d2[1]-d1[1]*d2[0];
	}
	for (j = 0; j < p->n_vertices; j++)
		for (k = 0; k < 3; k++)
			p->v[j]->normal[k]+= normal[k];
}

color_triple(r,g,b)
float r,g,b;
{
	int rv = ((int)(r*255)) +(((int)(g*255))<<8) +(((int)(b*255))<<16);
        return(rv);
}

int_color_triple(r,g,b)
int r,g,b;
{
       int rv = ((r*256) + g)*256 + b;
       return(rv);
}

extract_color_triple(col,r,g,b)
int col, *r, *g, *b;
{
	*b = col%256;
	col = (col - (*b))/256;
	*g = col%256;
	col = (col - (*g))/256;
	*r = col;
}
