#include "salem.h"

/*
 * core of the text commmand interpreter
 * including parsing and string processing
 * TODO: remove escapes?
 */

static cmdlist_t	*Cmdlist = NULL, *Last_cmd;
static alist_t		*Aliaslist = NULL;
static int			History_Echo;

do_command(argc,argv)
int	argc;
char	**argv;
{
	cmdlist_t	*p,*first_hit;
	int 		i, nhits, rv, arglength;

	if (argc == 0) return(0);
	if (History_Echo) {
		for (i = 0; i < argc; i++) printf("%s ",argv[i]);
		printf("\n");
		History_Echo = FALSE;
	}
	if (try_alias(argc,argv)) return 1;
	nhits = 0;	/* for safety */
	arglength = strlen(argv[0]);
	for (p = Cmdlist; p; p = p->next) 	/* search for exact match */
		if (!strcmp(argv[0],p->name)) {
			nhits = 1;
			first_hit = p;
			break;
			}
	if (nhits == 0) for (p = Cmdlist; p; p = p->next) /* prefix match? */
		if (!strncmp(argv[0],p->name,arglength)) {
			if (nhits++ == 0) first_hit = p;
			else if (nhits == 2) {
			    fprintf(stderr," too many matches, choice is\n");
			    fprintf(stderr,"%s\n%s\n",first_hit->name,p->name);
			    rv = -1;
			        }
			else	fprintf(stderr,"%s\n",p->name);
			}
	if (nhits == 1)	{
		if (first_hit->transcribe)
			transcribe(argc,argv);
		rv =  (first_hit->func)(argc,argv);
		}
	else if (nhits == 0) {
		fprintf(stderr,"%s: Command not found.\n",argv[0]);
		rv = -1;
		}
	return rv ;
}

register_client(name,func,help)
char	*name;
fnptr_t	func;
char	*help;
{
	cmdlist_t	*new,*p,*q = NULL;
	int		cmp = 1;

	for (p = Cmdlist; p; p = p->next)
		if ((cmp = strcmp(name,p->name)) < 0) break;
		else q = p;
	if (cmp == 0) ERR_RET_2(name,"was already registered");
	Last_cmd = new  = NEW(cmdlist_t);
	new->name	=  name;
	new->func	= func;
	new->help	= help;
	new->next	= p;
	new->transcribe = TRUE;
	if (q) q->next = new;
	else Cmdlist = new;
}

notranscribe_last_client() 
{
	Last_cmd->transcribe = FALSE;
}

int 	help();
int	alias();
int	echo();
int	forloop();
int setcmd();

initialize_commands()
{
	register_client("help",	help,		"print help messages");
	register_client("alias",alias,		"create a command alias ");
	register_client("echo ", echo,		"echo [string]");
	register_client("for ", forloop,	"for i in (list) do commands done");
	register_client("setvar", setcmd,		"set name val");
	Typed_cmd.keep_history = TRUE;
}

/* could cache this in alias */
has_positional_var(argc,argv)
int		argc;
char	**argv;
{
	int		i;
	char	*p;
	for (i = 0; i < argc; i++) {
		for (p = argv[i]; *p; p++) {
			if ((*p == '$') && (isdigit(*++p))) return TRUE;
		}
	}
	return FALSE;
}

try_alias(argc, argv) 
int argc; 
char** argv; 
{
	int			i;
	alist_t*	p;
	char		buf[10],cmd[MAXLINE];

	for (p = Aliaslist; p; p = p->next)
		if (!strcmp(argv[0],p->name))  {
			if (has_positional_var(p->argc,p->argv)) {
				for (i = 0; i < argc; i++) {
					sprintf(buf,"%d",i);
					setvar(buf,argv[i]);
				}
				varcat(p->argc,p->argv,cmd);
				parse_entire_string(cmd);
			}
			else {
				/* assume argv is big enough to hold the result */
				for (i = argc-1; i>=0; i--) argv[i+p->argc] = argv[i];
				for (i = 0; i < p->argc; i++) argv[i] = p->argv[i];
				argc = argc + p->argc - 1;
				do_command(argc,argv);
			}
			return TRUE;
		}
	return FALSE;
}

echo(argc,argv)
int argc;
char **argv;
{
	int i;
	for (i = 1 ; i < argc ; i++ ) printf("%s ",argv[i]);
	printf("\n");
}

alias(argc,argv)
int	argc;
char	**argv;
{
	int	i;
	alist_t	*p, *q;
	if (argc < 3) {
		/* print an alias, or all aliases */
		for (p = Aliaslist; p; p = p->next) {
			if ((argc == 1) || !strncmp(argv[1],p->name,strlen(argv[1]))) {
				printf("alias %s\t",p->name);
				for (i = 0; i < p->argc; i++)
					printf(" %s",p->argv[i]);
				printf("\n");
				}
			}
		}
	else {
		/* create or update an existing alias */
		q = NULL;
		for (p = Aliaslist; p; q = p, p = p->next) {
			if (!strcmp(argv[1],p->name)) {
				if (q) q->next = p->next;
				else Aliaslist = p->next;
				for (i = 0; i < p->argc; i++) free(p->argv[i]);
				free(p->argv);
				free(p);
				p = NULL;
				break;
				}
			}
		if (p == NULL) p = NEW(alist_t);
		p->name = strdup(argv[1]);
		p->argc = argc - 2;
		p->argv = N_NEW(p->argc,char*);
		for (i = 2; i < argc; i++) 
			p->argv[i-2] = strdup(argv[i]);
		p->next = Aliaslist;
		Aliaslist = p;
	}
}

help(argc,argv)
int	argc;
char**	argv;
{
	int		i,len,col;
	cmdlist_t	*p;

	if (argc == 1)	{
		col = 0;
		for (p = Cmdlist; p; p = p->next) {
			len = strlen(p->name);
			if (col + len > MAXCOL)
				{printf("\n"); col = 0;}
			printf("%s",p->name);
			col += len;
			for (i = (FAKETAB - col % FAKETAB)+1; i; i--) {
				printf(" ");
				col++;
				}
			}
		if (col) printf("\n");
		}
	else 
		for (i = 1 ; i < argc ; i++ )	{
			alias(2,&argv[i-1]);
			for (p = Cmdlist; p; p = p->next) {
				if (!strncmp(argv[i],p->name,strlen(argv[i])))
					printf("%s:\t%s\n",p->name,p->help);
				}
			}
}

static int	parse_lvl;	/* command parser recursion depth*/

parse_string(s)	
char* s;
{
	parse1(s,&Typed_cmd);
}

/* call here to process mouse and menu commands */
parse_entire_string(s)
char* s;
{
	pstate_t	*pstate;
	if (parse_lvl >= MAX_NESTED_COMMANDS)
		fprintf(stderr,"too much command recursion, ignoring %s\n",s);
	else {
		pstate = &Auxcmd[parse_lvl++];
		parse1(s,pstate);
		if (pstate->state != CMD_BEGINARG) {
			/* recover from an unterminated command */
			pstate->state = CMD_BEGINARG;
			parse1(";",pstate);
			}
		parse_lvl--;
		}
}
static int has_metachar(s)
char	*s;
{
	return ((strpbrk(s,"*[]")) != NULL);
}

static add_quotedchar(p,c)
pstate_t	*p;
char		c;
{
	if (strchr("*[]",c)) *(p->bp++) = '\\';
	*(p->bp++) = c;
}

reset_parser(p)
pstate_t	*p;
{
	p->bp = p->buf;
	p->argv[0] = p->bp;
	p->argc = 0;
	p->state = CMD_BEGINARG;
	p->subst_vars = TRUE;
	p->in_hist_expansion = FALSE;
	p->nest_level = FALSE;
}

term_arg(p)
pstate_t	*p;
{
	if (p->state == CMD_MIDARG) {
		*(p->bp++) = '\0';
		p->argc++;
		p->argv[p->argc] = p->bp;
		p->state = CMD_BEGINARG;
	}
}

glob_args(p)
pstate_t	*p;
{
	int			i,j;

	for (i = 0; i < p->argc; i++)
		if (has_metachar(p->argv[i])) {
			j = p->argc;
			glob(p,i);
			if (p->argc == 0) return; /* too big */
			i += (p->argc - j);
		}
}

append_arg(p,str)
pstate_t	*p;
char		*str;
{
	int len = strlen(str);
	if (len + p->bp > p->buf + sizeof(p->buf)) return FALSE;
	strcpy(p->bp,str);
	p->bp += len;
	p->state = CMD_MIDARG;
	return TRUE;
}

see_token(p,s,token)
pstate_t	*p;
char		*s,*token;
{
	int		tlen = strlen(token);
	return ((strncmp(s,token,tlen) == 0) && (p->state == CMD_BEGINARG)
		&& (!isalnum(s[tlen])));
}

one_char_arg(p,c)
pstate_t	*p;
char		c;
{
	term_arg(p);
	*(p->bp++) = c;
	p->state = CMD_MIDARG;
	term_arg(p);
}

/* parse1 tries to do EVERYTHING. it parses, it lexes, it processes strings,
it chops, it removes spots and stains, and anything else but handle errors.*/
parse1(s,p)
char	*s;
pstate_t *p;
{
	char	c,*v,str[MAXLINE];
	Boolean	save_flag;

	if (p->bp == NULL) reset_parser(p);

	while (*s) {
		if (p->keep_history) record_history(*s);
		switch (p->state) {
		case CMD_INCOMMENT:
			s++;
			continue;
		case CMD_BEGINARG:
		case CMD_MIDARG:
			switch (c = *s++) {

				/* chars that affect further parsing */
				case '\'':	p->state = CMD_SINGLEQUOTE; break;
				case '"':	p->state = CMD_DOUBLEQUOTE; break;
				case '\\':	p->state = CMD_BACKSLASH; break;
				case '#':   term_arg(p); p->state = CMD_INCOMMENT; break;

				/* shell variables */
				case '$':
					if (p->subst_vars == FALSE) {
						*(p->bp++) = c;
						p->state = CMD_MIDARG;
						break;
					}
					v = str;
					do { *v++ = *s++; } while (isalnum(*s));
					*v = '\0';
					if (append_arg(p,getvar(str)) == FALSE)
						fprintf(stderr,"variable substitution too long");
					break;

				/* history */
				case '!':
						/* check for escape to shell */
					if ((*s==' ')||(*s=='\t')) {
						*(p->bp++) = c;
						p->state = CMD_MIDARG;
						break; 
						}
					backup_history();
					History_Echo = TRUE;
					save_flag = p->in_hist_expansion;
					p->in_hist_expansion = TRUE;
					v = expand_history(s,str);
					if (v) {
						s = v;
						parse1(str,p);
					}
					else p->state = CMD_INCOMMENT;
					p->in_hist_expansion = save_flag;
					break;

				/* punctuation */
				case '(':
				case ')':
					one_char_arg(p,c);
					break;

				/* delimiters */
				case ' ':
				case '\t':
					term_arg(p);
					break;
				case ';':
					if (p->nest_level <= 0) {
						term_arg(p);
						glob_args(p);
						do_command(p->argc,p->argv);
						reset_parser(p);
						}
					else one_char_arg(p,c);
					break;

				/* other characters are just copied */
				default:
					if (see_token(p,s-1,"do")) {
						p->subst_vars = FALSE;
						p->nest_level++;
						}
					else if (see_token(p,s-1,"done")) {
						if (p->nest_level > 0) p->nest_level--;
						if (p->nest_level == 0) p->subst_vars = TRUE;
						}
					*(p->bp++) = c;
					p->state = CMD_MIDARG;
					break;
			}
			break;
		case CMD_SINGLEQUOTE:
			if ((c = *s++) == '\'') p->state = CMD_MIDARG;
			else add_quotedchar(p,c);
			break;
		case CMD_DOUBLEQUOTE:
			if ((c = *s++) == '\"') p->state = CMD_MIDARG;
			else add_quotedchar(p,c);
			break;
		case CMD_BACKSLASH:
			*(p->bp++) = *s++;
			p->state = CMD_MIDARG;
			break;
		default:
			fatal("parse_string confused");
		}
	}
	if (p->in_hist_expansion == FALSE) {
		if (p->keep_history) record_history(*s);
		if (p->state == CMD_MIDARG) term_arg(p);
		if (p->state == CMD_INCOMMENT) p->state = CMD_BEGINARG;
		if (p->state == CMD_BEGINARG) {
			glob_args(p);
			do_command(p->argc,p->argv);
			reset_parser(p);
		}
	}
}

#define NSHELLVAR 100
char	*Varname[NSHELLVAR+1],*Varval[NSHELLVAR+1];
setvar(name,val)
char	*name,*val;
{
	int	i;
	for (i = 0; i < NSHELLVAR; i++)
		if (!Varname[i] || !strcmp(Varname[i],name)) break;
	if (Varname[i] == NULL) Varname[i] = strdup(name);
	if (Varval[i]) free(Varval[i]);
	Varval[i] = strdup(val);
}

sym_t specialvar_list[] = {
	{"view",V_WINDOW},
	{"object",V_SELECTEDOBJ},
	{"x",V_MOUSEX},
	{"y",V_MOUSEY},
	{"dx",V_MOUSEDX},
	{"dy",V_MOUSEDY},
	{NULL,0}
};

char*
getvar(name)
char	*name;
{
	int		i,v;
	sym_t	*sp;
	char	expbuf[MAXLINE];

	if (sp = lookup(name,specialvar_list)) {
		if (sp->val == V_WINDOW)	
			strcpy(expbuf, Input_window?Input_window->obj->name:
				"(no window)");
		else if (sp->val == V_SELECTEDOBJ)
			strcpy(expbuf,Selected.name);
		else {
			switch (sp->val) {
				case V_MOUSEX: v = Mouse.x; break;
				case V_MOUSEY: v = Mouse.y; break;
				case V_MOUSEDX: v = Mouse.dx; break;
				case V_MOUSEDY: v = Mouse.dy; break;
			}
			sprintf(expbuf,"%d",v);
		}
		return expbuf;
	}
	else {
		for (i = 0; Varname[i]; i++)
			if (!strcmp(Varname[i],name)) return Varval[i];
		return "";
	}
}

forloop(argc,argv)
int	argc;
char**	argv;
{
	char	*indexvar,cmd[MAXLINE];
	int	a,i,nest;

	indexvar = argv[1];
	if (strcmp(argv[2],"in") || strcmp(argv[3],"("))
		ERR_RET("for: syntax error");
	for (a = 3; a < argc; a++)
		if (!strcmp(argv[a],")")) break;
	if ((a >= argc)  || strcmp(argv[a + 1],"do"))
		ERR_RET("for: syntax error");
	for (nest = 1, i = a + 2; (nest > 0) && (i < argc); i++) {
		if (!strcmp(argv[i],"do")) nest++;
		else if (!strcmp(argv[i],"done")) nest--;
	}

	varcat(i - a - 3, argv + a + 2, cmd);
	for (i = 4; i < a; i++) {
		setvar(indexvar,argv[i]);
		parse_entire_string(cmd);
	}
}

setcmd(argc,argv)
int		argc;
char	**argv;
{
	int		i;
	sym_t	*sp;

	switch (argc) {
		case 1:	/* would be prettier if sorted */
			for (sp = specialvar_list; sp->name; sp++)
				printf("%s\t%s\n",sp->name,getvar(sp->name));
			for (i = 0; Varname[i]; i++)
				printf("%s\t%s\n",Varname[i],Varval[i]);
			break;
		case 2: printf("%s\n",getvar(argv[1])); break;
		case 3: setvar(argv[1],argv[2]); break;
		default: fprintf(stderr,"syntax error\n"); break;
	}
}
