#include "salem.h"

#define MAXDEPTH 128
static object_t		*Stack[MAXDEPTH];
static object_t		*Save[MAXDEPTH];
static int			SP;
static Coord		A[4],B[4],C[4],D[4],E[4],RayDelta[4];
static selection_t	Best;

int		do_pick();
double	L2dist();

initialize_pick()
{
   register_client("pick",do_pick,"pick [objname [poly_index [vertex_index]]]");
}


static map_the_point(M,val,res)
Matrix		M;
Coord		*val,*res;
{
	res[0] = val[0]*M[0][0] + val[1]*M[1][0] + val[2]*M[2][0] + val[3]*M[3][0];
	res[1] = val[0]*M[0][1] + val[1]*M[1][1] + val[2]*M[2][1] + val[3]*M[3][1];
	res[2] = val[0]*M[0][2] + val[1]*M[1][2] + val[2]*M[2][2] + val[3]*M[3][2];
	res[3] = 1.0;
}

#define dotproduct(A,B)	(A[0]*B[0] + A[1]*B[1] + A[2]*B[2])

static double ray_plane_inter(p0,p1,p2,RayOrigin,D)
Coord		*p0,*p1,*p2;
Coord		*RayOrigin,*D;
{
	int			i;
	Coord		U[3],V[3];	/* vectors p0p1 and p0p2 of polygon */
	Coord		N[3];		/* normal of plane of polygon */
	double		t;			/* parameter for ray definition */
	double		d;			/* dot product of point on poly with N */
	double		nd;			/* dot product of N and D */

	for (i = 0; i < 3; i++) {
		U[i] = p1[i] - p0[i];
		V[i] = p2[i] - p0[i];
	}

	N[0] = U[1]*V[2]-U[2]*V[1];
	N[1] = U[2]*V[0]-U[0]*V[2];
	N[2] = U[0]*V[1]-U[1]*V[0];

	d = -dotproduct(p0,N);
	nd = dotproduct(N,D);
	if (nd == 0) {fprintf(stderr,"ray_plane_inter: parallel\n"); return -1.0;}
	t = -(d + dotproduct(N,RayOrigin))/nd;
	if (t <= 0) {fprintf(stderr,"ray_plane_inter: behind origin\n");}
	return t;
}

static closest_vertex(M,poly,p0)
Matrix		M;
polygon_t	*poly;
Coord		*p0;
{
	int		i,rv;
	double	dist,best;
	Coord	p[4];

	for (i = 0; i < poly->n_vertices; i++) {
		map_the_point(M,poly->v[i]->position,p);
		dist = L2dist(p0,p);
		if ((i == 0) || (dist < best)) {best = dist; rv = i;}
	}
	return rv;
}


static find_polyhit(obj)
object_t 	*obj;
{
	int				pn,i,j,k,s0,s1,s2;
	double			t;
	objlink_t		*link;
	polygon_t		*poly;
	Matrix			CTM;

	Stack[SP++] = obj;
	pushmatrix();
	multmatrix(obj->v);
	getmatrix(CTM);

	for (poly = obj->polygons, pn = 0; pn < obj->n_polygons; pn++, poly++) {
		map_the_point(CTM,poly->v[0]->position,A);
		map_the_point(CTM,poly->v[1]->position,B);
		for (j = 2; j < poly->n_vertices; j++) {
			map_the_point(CTM,poly->v[j]->position,C);
			s0 = DET4(A,B,D,E);
			s1 = DET4(B,C,D,E);
			s2 = DET4(C,A,D,E);
			if (s0 * s1 * s2 == 0) fprintf(stderr,"hiccup\n");
			else if ((s0 == s1) && (s1 == s2)) {
				t = ray_plane_inter(A,B,C,D,RayDelta);
				/*fprintf(stderr,"hit %d in %s distance %lf\n",pn,obj->name,t);*/
				if ((Best.object == NULL) || (Best.dist > t)) {
					for (i = 0; i < SP; i++) Save[i] = Stack[i];
					Best.object = obj;
					Best.dist = t;
					Best.d[0] = D[0] + t * RayDelta[0];
					Best.d[1] = D[1] + t * RayDelta[1];
					Best.d[2] = D[2] + t * RayDelta[2];
					/*fprintf(stderr," i think the coord is %f,%f,%f\n",Best.d[0],Best.d[1],Best.d[2]);*/
					Best.polygon = pn;
					emu_copy_matrix(Best.Mpick,CTM);
				}
			}
			for (k = 0; k < 4; k++) B[k] = C[k];
		}
	}
	for (link = obj->child_list; link; link = link->c_next)
		find_polyhit(link->child,D,E);
	popmatrix();
	SP--;
}

make_pick_view()
{
	Object 		pick_view;
	Matrix		M;

	mmode(MSINGLE);
	loadmatrix(Identity);
	pick_view = genobj();
	makeobj(pick_view);
	perspective_view(M,Input_window,0);
	loadmatrix(M);
	get_position(M,Input_window->obj);
	invert_matrix(M, M);
	multmatrix(M);
	closeobj();
	mmode(MVIEWING);
	loadmatrix(Identity);
	pushmatrix();
	return(pick_view);
}

static DET4(A,B,C,D)
Coord *A, *B, *C, *D;	/* expect A,B,C,D to be vectors of Coords */
{
	double value;

	value = (A[0]-D[0]) *
		(((B[1]-D[1]) * (C[2]-D[2])) - ((B[2]-D[2]) * (C[1]-D[1])));

	value += (A[1]-D[1]) *
		(((B[2]-D[2]) * (C[0]-D[0])) - ((B[0]-D[0]) * (C[2]-D[2])));

	value += (A[2]-D[2]) *
		(((B[0]-D[0]) * (C[1]-D[1])) - ((B[1]-D[1]) * (C[0]-D[0])));

	if (value > 1E-8)	return(1);
	else if (value < -1E-8)	return(-1);
	else	return(0);
}

do_pick(argc,argv) 
int		argc;
char**		argv;
{
	if (argc > 1)	{
		Selected.object = get_object(argv[1]);
		Selected.polygon = (argc > 2) ? atoi(argv[2]) : 0 ;
		Selected.vertex = (argc > 3) ? atoi(argv[3]) : 0 ;
		strcpy(Selected.name,argv[1]);
	}
	else {
		if (Input_window) {
			char	*p,*q;
			int		xorig,yorig;
			Object vobj = make_pick_view();

			getorigin(&xorig,&yorig);
			mapw(vobj,Mouse.x-xorig,Mouse.y-yorig,E,E+1,E+2,D,D+1,D+2);
			D[3] = E[3] = 1.0;
			/*fprintf(stderr,"ray is (%f,%f,%f) to (%f,%f,%f)\n",D[0],D[1],D[2],E[0],E[1],E[2]);*/
			RayDelta[0] = (E[0] - D[0]);
			RayDelta[1] = (E[1] - D[1]);
			RayDelta[2] = (E[2] - D[2]);
			RayDelta[3] = 0.0;
			loadmatrix(Identity);
			Best.object = NULL;
			find_polyhit(Input_window->cluster);
			if (Best.object)  {
				Best.vertex = closest_vertex(Best.Mpick,
					&(Best.object->polygons[Best.polygon]), Best.d);
				p = Best.name;
				for (SP = (Save[1] != World? 1 : 2);
					Save[SP] != Best.object; SP++) {
					q = Save[SP]->name;
					while (*p++ = *q++);
					*(p - 1) = '/';
				}
				strcpy(p,Save[SP]->name);
				SP = 0;
			}
			Selected = Best;
		}
		else printf("no window to select in, therefore ");
	}

	if (Selected.object) {
		printf("object %s was picked at polygon %d vertex %d\n",
			Selected.object->name,Selected.polygon,Selected.vertex);
	}
	else {
		printf("no object was picked\n");
		Selected.object = World;
		strcpy(Selected.name,"/world");
	}
}
