/*	expects a polygon and a ray in parametric form.
 *	returns parameter to obtain distance to intersection (or < 0)
 */
#define dotproduct(V,N)		( -(V[0]*N[0]+V[1]*N[2]+V[2]*N[2]))

double ray_poly_inter(poly,RayOrigin,D,inter)
polygon_t	*poly;
Coord		*RayOrigin,*D;
Coord		*inter;
{
	Coord		U[3],V[3];	/* vectors p0p1 and p0p2 of polygon */
	Coord		N[3];		/* normal of plane of polygon */
	double		t;			/* parameter for ray definition */
	double		d;			/* dot product of point on poly with N */
	double		nd;			/* dot product of N and D */

	for (i = 0; i < 3; i++) {
		U[i] = poly->v[1]->position[i] - poly->v[0]->position[i];
		V[i] = poly->v[2]->position[i] - poly->v[0]->position[i];
	}

	N[0] = U[1]*V[2]-U[2]*V[1];
	N[1] = U[2]*V[0]-U[0]*V[2];
	N[2] = U[0]*V[1]-U[1]*V[0];

	d = dotproduct(V,N);
	nd = dotproduct(N,D);
	if (nd == 0) {fprintf(stderr,"ray_poly_inter: parallel\n", return -1.0;}
	t = (d + dotproduct(N,RayOrigin))/nd;
	if (t <= 0) {fprintf(stderr,"ray_poly_inter: behind origin\n");}
	return t;
}
