#include "salem.h"

#define COFACTOR(i,j)	\
		(pp[0][i] * (pp[1][j] - pp[2][j]) +\
		 pp[1][i] * (pp[2][j] - pp[0][j]) +\
		 pp[2][i] * (pp[0][j] - pp[1][j]))

#define DETERMINANT(i,j,k)\
	(pp[0][i] * (pp[1][j] * pp[2][k] - pp[1][k] * pp[2][j]) + \
	 pp[1][i] * (pp[2][j] * pp[0][k] - pp[2][k] * pp[0][j]) + \
	 pp[2][i] * (pp[0][j] * pp[1][k] - pp[0][k] * pp[1][j]) )

#define SQ(x)	((x) * (x))
#define EPS .000000001
double 
L2dist(e,f)
Coord e[],f[];
{
	double dret;
	dret = SQ(e[0] - f[0]) + SQ(e[1] - f[1]) + SQ(e[2] - f[2]);
	dret = sqrt(dret);
	return(dret);
}

normalize(v)
Coord v[];
{
	double norm;
	norm = SQ(v[0]) + SQ(v[1]) + SQ(v[2]) ; 
	if (norm < EPS)
		return(0);
	norm = sqrt(norm);
	v[0] /= norm; v[1] /= norm; v[2] /= norm;
	return(1);
}

double
dist_to_plane(poly,e,f,m)
polygon_t *poly;
Coord *e, *f;
Matrix m;
{
        double a,b,c,d,t;
        vertex_t *p[3] ;
        Coord *pp[3], g[3];
        int i,j,k;

	Coord np[3][3];

        for (i = 0 ; i < 3 ; i++ )      {
                p[i] = poly->v[i];
                pp[i] = p[i]->position;
		}

	for (i = 0 ; i < 3 ; i++ )
		for (j = 0 ; j < 3 ; j++ )	{
			np[i][j] = m[i][3];
			for (k = 0 ; k < 3 ; k++ )
				np[i][j] += m[i][k] * pp[k][j];
			}

#define NCOFACTOR(i,j)	\
		(np[0][i] * (np[1][j] - np[2][j]) +\
		 np[1][i] * (np[2][j] - np[0][j]) +\
		 np[2][i] * (np[0][j] - np[1][j]))

#define NDETERMINANT(i,j,k)\
	(np[0][i] * (np[1][j] * np[2][k] - np[1][k] * np[2][j]) + \
	 np[1][i] * (np[2][j] * np[0][k] - np[2][k] * np[0][j]) + \
	 np[2][i] * (np[0][j] * np[1][k] - np[0][k] * np[1][j]) )

	a = NCOFACTOR(1,2);
	b = NCOFACTOR(2,0);
	c = NCOFACTOR(0,1);
	if ((a*a + b*b + c*c) < .000001001)	{
		fprintf(stderr,"plane is actually a line\n");
		return(-1);
		}
	d =  NDETERMINANT(0,1,2);

	for (i = 0 ; i < 3 ; i++ ) g[i] = e[i] - f[i] ;

	t = (d - (a * f[0] + b * f[1] + c * f[2]))/(a*g[0] + b*g[1] + c*g[2]);

	return((t<0)? (-t) : t);
}
