typedef int (*fnptr_t)();

typedef struct vertex_t {
        Coord	position[4];
        int	fastcolor;
        Boolean colored;
        Coord	normal[4];
        int	order;
} vertex_t;

typedef struct polygon_t {
        int	n_vertices;
	Boolean	colored;
	int	fastcolor;
        vertex_t** v;
} polygon_t;

typedef struct patch_t {
	double color[3];
	Matrix x,y,z;
} patch_t;

typedef struct objlink_t {
	struct object_t	*parent,*child;
	struct objlink_t *c_prev,*c_next;
	struct objlink_t *p_prev,*p_next;
} objlink_t;

typedef struct object_t {
/* object properties */
        char		*name;			/* NULL or empty means Root */
	struct object_t	*owner;
	objlink_t	*parent_list;		/* for graph of objects */
	objlink_t	*child_list;
	Matrix		v;			/* for this instance */
	double		displayed;		/* displayed fraction */
	int		shading;		/* GOURAUD, WIREFRAME, MIXED, or FLAT*/
	int		g_st, g_end, c_st, c_end ;
	char 		*user;			/* for user fields*/
	char		*creation_string;
	int		mark;
	long		flags;

/* actions per tick */
	fnptr_t		tick;			/* its tick action */
	fnptr_t		editfn;			/* call back for object editing */

/* object data */
	int		n_patches;
        patch_t		*patches;		/* primitive object */
	int		n_polygons, n_polygons_alloc;
        polygon_t	*polygons;		/* primitive object */
	int		n_vertices, n_vertices_alloc;
	vertex_t	*v_list;		/* simplifies storage mgt */
	struct window_t *win;
} object_t;

typedef struct sym_t {
        char	*name;
        int	val;
} sym_t;

typedef struct submenu_t {
        char	*name;
        int		pupid;
} submenu_t;

typedef struct cmdlist_t {
        char	*name, *help;
        fnptr_t	func;
	int	transcribe;
        struct cmdlist_t *next;
} cmdlist_t;

typedef struct alist_t {
	char*	name;
	int		argc;
	char**	argv;
	struct alist_t *next;
} alist_t;

typedef struct inputstack_t {
	FILE*	fp;
	int	is_a_tty;
	struct inputstack_t* link;
} inputstack_t;

typedef struct mouse_t	{
	int x, y, dx, dy;
	long buttonsdown;
} mouse_t;

typedef struct	selection_t	{
	Matrix 		Mpick;
	Coord 		d[3], e[3];
	double 		dist;
	object_t	*object;
	int		polygon;
	int		vertex;
	int		patch;
	char		name[MAXLINE];
} selection_t ;

typedef struct projection_t {
		int type;				 /* ORTHOGONAL | PERSPECTIVE */
        Coord	zoom;
        Coord	frontclip, backclip;
} projection_t;

typedef struct window_t {
        long	flags;
        int	gid;
        Boolean light_on;

	projection_t proj;

	Boolean stereo;
	float   fe,fp;

	object_t *cluster;
	object_t *obj;
} window_t;

typedef struct pstate_t {
	int		argc;
	char		*argv[MAXARGS];
	char		buf[CMDBUFSIZE],*bp;
	int		state;
	Boolean		subst_vars;
	Boolean		keep_history;
	Boolean		in_hist_expansion;
	int		nest_level;
} pstate_t;

typedef struct motion_t {
	object_t *moving_obj;
	object_t *axes_obj;
	object_t *center_obj;
	fnptr_t local_transform_func;
	Coord amount[3];
	struct motion_t *next;
} motion_t;
