#include "salem.h"

int color_object();
int random_color_object();
int facecolor();

initialize_coloring()
{
	register_client("color_object", color_object, "color_object objname [partial]");
	register_client("random_color_object", random_color_object, "random_color_object objname");
	register_client("facecolor", facecolor, "facecolor objname filename");
}

int compar();

struct	edge_table_entry	{
	int to, from, poly;
	} ;
int
color_object(argc,argv)
int argc;
char **argv;
{
	struct	edge_table_entry	*etable;
	int 		nedges, *noff, *nused, ncolors, locor[256], used[256];
	int		previous_used[256], prev_count;
	float		cv[8];
	int 		ncv, np, *adj_table, i,j,k,l, from, to; 
	int		poly1, poly2, adj_poly ;
	polygon_t 	*pp;
	object_t	*obj;
	int		partial = 0;

	obj = get_object(argv[1]);
	if (obj == NULL)	{
		if (Selected.object) obj = Selected.object;
		else	{
			fprintf(stderr," no object %s to color \n",argv[1]);
			return;
			}
		}

	if (argc > 2) partial = 1;

	np = obj->n_polygons;
	if (np <= 0) return;

	/* build adjacency list by first creating and marking necessary space */
	noff = N_NEW(np, int);
	nused = N_NEW(np, int);
	for (noff[0] = 0, i = 1 ; i < np ; i++ ) 	{
		noff[i] = noff[i-1] + obj->polygons[i-1].n_vertices;
		nused[i] = 0;
		}


	nedges = noff[np - 1] + obj->polygons[np - 1].n_vertices;
	etable = N_NEW(nedges,struct  edge_table_entry);
	adj_table = N_NEW(nedges,int);

	for (i = 0 ; i < nedges ; i++ ) adj_table[i] = -1;

	/* record each edge in the edge table along with polygon it bounds */
	for ( k = i = 0 ; i < np ; i++ )	{
		pp = &obj->polygons[i];
		for (j = 0 ; j < pp->n_vertices ; j++ ,k++ )	{
			from = (int) (pp->v[j] - obj->v_list) ;
			if (j < (pp->n_vertices - 1 ))
				to = (int) (pp->v[j+1] - obj->v_list) ;
			else 	to = (int) (pp->v[0] - obj->v_list) ;
			if (from < to)	{ 
				etable[k].from = from; 
				etable[k].to = to;
				}
			else	{ 
				etable[k].from = to; 
				etable[k].to = from; 
				}
			etable[k].poly = i;
			}
		}

	/* the sort is to tell us which faces share an edge (ie are adjacent)*/
	qsort((char*) etable, nedges, sizeof(struct edge_table_entry), compar);
	for (i = 0 ; i < nedges ;  )	{
		poly1 = etable[i].poly ;
		poly2 = etable[i+1].poly ;
		if ((etable[i].to != etable[i+1].to) || (etable[i].from != etable[i].from)) i++; /* one sided edge */
		else	{
			adj_table[noff[poly1] + nused[poly1]] = poly2; 
			nused[poly1]++;
			adj_table[noff[poly2] + nused[poly2]] = poly1; 
			nused[poly2]++;
			i += 2;
			}
		}

	/* now go thru adjacencies and create a legal, though dumb, coloring */
	/* first initialize colors to -1 */
if (partial== 0)
	for (i = ncolors = 0; i < np ; i++ )	{
		pp = &obj->polygons[i];
		pp->fastcolor = -1;
		}

	for (i = ncolors = 0; i < np ; i++ )	{
		pp = &obj->polygons[i];
if (partial && pp->fastcolor != -1) continue;
		for (j = 0 ; j < ncolors ; j++ ) used[j] = 0;
		for (j = 0 ; j < pp->n_vertices ; j++ )		{
			adj_poly = adj_table[noff[i] + j];
			if ((adj_poly != -1) && 
				    (obj->polygons[adj_poly].fastcolor != -1))
				used[obj->polygons[adj_poly].fastcolor] = 1;
			}
		for (j = 0 ; used[j] != 0  ; j++ ) used[j] = 0;
		pp->fastcolor = j;
		if (j > ncolors) ncolors = j;
		else	for ( ; j < ncolors ; j++ )	used[j] = 0;
		}

	if (ncolors < 8)	{
		locor[0] = color_triple(1.,0.,0.);
		locor[1] = color_triple(0.,1.,0.);
		locor[2] = color_triple(0.,0.,1.);
		locor[3] = color_triple(1.,1.,0.);
		locor[4] = color_triple(1.,0.,1.);
		locor[5] = color_triple(0.,1.,1.);
		locor[6] = color_triple(1.,1.,1.);
		}
	else	{
		for (j = 2 ; ; j++ )
			if ((j*j*j) > (ncolors + 1))
				break;
		ncv = j;
		cv[0] = 0; 
		for (j = 0; j < ncv; j++) cv[j] = ((float)j)/((float)(ncv - 1));

		for (l = i = 0 ; i < ncv ; i++ )
			for (j = 0 ; j < ncv ; j++ )
				for (k = 0 ; k < ncv ; k++ )
					if ((i==0)&& (j==0) && (k==0)) continue;
					else locor[l++] = 
						color_triple(cv[i],cv[j],cv[k]);
		}

	for ( i = 0 ; i < np ; i++ )	{
		pp = &obj->polygons[i];
		pp->fastcolor = locor[pp->fastcolor];
		pp->colored = TRUE;
		}
	make_vertex_colors(obj);
	free(noff);
	free(nused);
	free(adj_table);
	free(etable);
}

int
compar(xx,yy)
struct edge_table_entry *xx, *yy;
{
	if (xx->to < yy->to) return (-1);
	if (xx->to > yy->to) return(1);
	if (xx->from < yy->from) return(-1);
	if (xx->from > yy->from) return(1);
	if (xx->poly < yy->poly) return(-1);
	if (xx->poly > yy->poly) return(1);
	fprintf(stderr," sorting broken (%d %d %d) vs. (%d %d %d)\n",
		xx->to,xx->from,xx->poly,yy->to,yy->from,yy->poly);
	return(0);
}

int
random_color_object(argc,argv)
int argc;
char **argv;
{
	int 		i ;
	object_t	*obj;

	obj = get_object(argv[1]);
	if (obj == NULL)	{
		if (Selected.object) obj = Selected.object;
		else	{
			fprintf(stderr," no object %s to color \n",argv[1]);
			return;
			}
		}
	for ( i = 0 ; i < obj->n_polygons ; i++ )
		obj->polygons[i].fastcolor = random_face_color();

	make_vertex_colors(obj);
}

int
facecolor(argc,argv)
int argc;
char **argv;
{
	polygon_t	*poly, *end_poly;
	object_t	*obj;
	FILE 		*file_in;

	obj = get_object(argv[1]);
	if (obj == NULL)	{
		fprintf(stderr," no object %s to color \n",argv[1]);
		return;
		}

	if (( file_in = fopen( argv[2] , "r" )) == NULL) {
		fprintf(stderr," no file %s to open \n",argv[2]);
		return;
		}

	end_poly = obj->polygons + obj->n_polygons;
	for (poly = obj->polygons ; poly < end_poly ; poly++ )	{
		poly->colored = 1;
		fscanf(file_in,"%d",&poly->fastcolor);
		}
}
