#include "sl_lincoln.h"
#include "sli.h"

int compar2();

struct	is_table_entry	{
	int to, from;
	} ;

#define MAX_COLORS	10
int
find_independent_set(lobj,isv,maxdegree)
lincoln_t	*lobj;
int 		*isv;
int 		maxdegree;
{
	struct	is_table_entry	*etable, *et;
	int 		ncolors, used[MAX_COLORS], freq[MAX_COLORS];
	int 		ne,nv,np, i,j,tmp, maxc, maxv ;
	int		*vertex_colors;
	lvertex_t       *lvl;
	ledge_t         *lel;
	ldata_t         *ldl;
	int 		vdeg ;

        ldl = &lobj->data;
        lvl =  lobj->vlist ;
        lel =  lobj->elist ;

	np = ldl->nfaces;
	nv = ldl->nvertices;
	ne = ldl->nedges;

	etable = N_NEW(1+ne,struct  is_table_entry); /* why 1 more ?? i dunno */
	vertex_colors = N_NEW(1+nv, int);
	if (!etable || !vertex_colors) return(-1);

	for ( et = etable, i = 0 ; i < ne ; i++, et++ )	{
		et->from = Vint(lel[i].v[0],lvl);
		et->to   = Vint(lel[i].v[1],lvl);
		if (et->from > et->to)	{
			tmp = et->from; et->from = et->to; et->to = tmp;
			}
		}

	qsort((char*) etable, ne, sizeof(struct is_table_entry), compar2);

	bzero(freq, MAX_COLORS*sizeof(int));
	bzero(used, MAX_COLORS*sizeof(int));

	for (i = 0; i < nv ; i++ )	
		vertex_colors[nv] = -1;
	et = etable;
	for (i = ncolors = 0; i < nv ; i++ )	{
		vdeg = 0;
		for (j = 0 ; j <= ncolors ; j++ ) used[j] = 0;
		for (  ; et->to == i ; vdeg++, et++ ) 
			used[vertex_colors[et->from]] = 1;
		for (j = 0 ; used[j] != 0  ; j++ ) used[j] = 0;
		if (vdeg > maxdegree)
			j = MAX_COLORS - 1;
		vertex_colors[i] = j;
		freq[j]++;
		if ( (j >= ncolors) && ( j != (MAX_COLORS - 1))) ncolors = j;
		else	for ( ; j <= ncolors ; j++ )	used[j] = 0;
		}

	for (maxc = 0, maxv = freq[0] , i = 1 ; i < ncolors ; i++ )
		if (freq[i] > maxv)	{ maxv = freq[i]; maxc = i; }

	for (i = j = 0 ; i < nv ; i++ )	
		if (vertex_colors[i] == maxc)	
			isv[j++] = i;

printf(" independent set has size = %d \n",maxv);

	free(etable);
	free(vertex_colors);
	return(maxv);
}

int
compar2(xx,yy)
struct is_table_entry *xx, *yy;
{
	if (xx->to < yy->to) return (-1);
	if (xx->to > yy->to) return(1);
	if (xx->from < yy->from) return(-1);
	if (xx->from > yy->from) return(1);
	return(0);
}
