/*====================================================================
     Make.c   This file contains the functions that build up the face, 
  edge, and vertex structures. 
  ===================================================================*/

#include "3DHull_structs.h"
#include "3DHull_macros.h"

/*----------------------------------------------------------------------
       Make_structs makes a new face and two new edges between the 
  edge and the point that are passed to it. It returns a pointer to
  the new face.
 ----------------------------------------------------------------------*/
struct tface *make_structs( e, p )
struct tedge *e;
struct tvertex *p;
{
	register struct tedge *new_edge[2];
                 struct tedge *make_edge();
        register struct tface *new_face;
                 struct tface *make_face();
        register int i, j;

        for ( i=0; i < 2; ++i ) 
              if ( !( new_edge[i] = e->endpts[i]->duplicate) ) {
                 /* if the edge does not already exist, make it */
                 new_edge[i] = make_edge(e->endpts[i],p);
                 e->endpts[i]->duplicate = new_edge[i];
		*( duplicate_vertices + duplicate_vertex_no++ ) = 
			e->endpts[i] ;
                 }

        /* make the new face */
        new_face = make_face(e,new_edge[0],new_edge[1],e->endpts[0],e->endpts[1],p);   

	make_ccw(new_face,e);

        pre_vol( new_face );
        
        /* set the adjacent face pointers */
        for ( i=0; i < 2; ++i )
              for ( j=0; j < 3; ++j )  
                    if ( !new_edge[i]->adjface[j] ) {
                          new_edge[i]->adjface[j] = new_face;
                          break;
                          }
        
        return new_face;
}

/*------------------------------------------------------------------------
      Make_ccw puts the vetices in the face structure in counter
  clockwise order.  If there is no adjacent face[1] then we know that
  we are working with the first face of the initial tetrahedron.  In this
  case we want to store the vertices in the opposite order from the
  initial face.  Otherwise, we want to store the vertices in the same order
  as in the visible face.  
  ------------------------------------------------------------------------*/
make_ccw( f, e )
struct tface *f;
struct tedge *e;
{
        register int i;
        register struct tface *fv;

        if ( !e->adjface[1] ) {
             /* if this is the initial triangle */
             fv = e->adjface[0];

             /* find the index of endpoint[1] */
             for ( i=0; fv->vert[i] != e->endpts[1]; ++i )
                   ;
             /* put the vertices in the opposite order of fv */
             if ( fv->vert[ (i+1) % 3 ] != e->endpts[0] ) {
                  f->vert[0] = e->endpts[1];
                  f->vert[1] = e->endpts[0];
                  }
             else {
                  f->vert[0] = e->endpts[0];
                  f->vert[1] = e->endpts[1];
                  }
             }

        else {
             /* otherwise,  set the visible face */
             if  ( e->adjface[0]->visible )
                   fv = e->adjface[0];
             else fv = e->adjface[1];

             /* find the index of endpoint[1] */
             for ( i = 0; fv->vert[i] != e->endpts[1] ; ++i )
                   ;

             /* put the vertices in the same order as fv */
             if ( fv->vert[ (i+1) % 3 ] != e->endpts[0] ) {
                  f->vert[0] = e->endpts[0];
                  f->vert[1] = e->endpts[1];
                  }
             else {
                  f->vert[0] = e->endpts[1];
                  f->vert[1] = e->endpts[0];
                  }
              }    

}

/*---------------------------------------------------------------------
      Make_edge creates a new cell and fills in its fields.
   It returns a pointer to the new edge.
  ---------------------------------------------------------------------*/
struct tedge *make_edge(v1,v2)
struct tvertex *v1, *v2;
{
	register struct tedge *new;

        ALLOCATE( new, struct tedge );

        new->adjface[0] = new->adjface[1] = new->adjface[2] = NULL;
        new->endpts[0] = v1; new->endpts[1] = v2;
        new->deleted = !DELETED;
        ADD_QUEUE( edges, new );
	v1->order++ ; v2->order++ ;
        return new;
}

/*---------------------------------------------------------------------
     Make_face creates a new face structure and fills in its fields 
  It returns a pointer to the new face.
 ----------------------------------------------------------------------*/
struct tface *make_face(e0,e1,e2,v0,v1,v2)
struct tedge *e0, *e1, *e2 ;
struct tvertex *v0, *v1, *v2 ;
{
	register struct tface *new;

	ALLOCATE( new, struct tface);

    	new->edg[0] = e0 ; new->edg[1] = e1 ; new->edg[2] = e2 ;
    	new->vert[0] = v0 ; new->vert[1] = v1 ; new->vert[2] = v2 ;

	new->visible = !VISIBLE;
	ADD_QUEUE( faces, new );
	return new;
}
