/*===================================================================
  Degen.c  This file contains the functions that check for 
  co-linear and co-planar points.
  ===================================================================*/

#include "3DHull_structs.h"
#include "3DHull_macros.h"

/*------------------------------------------------------------------
     Co_linear checks to see if the three points given are colinear.
  It checks to see if the cross product  ( rather, each element of
  the cross product  i, j, and k ) between the two vectors formed by
  the points is 0 or not.  If each element is 0 then the area of the
  triangle is 0 and the points are colinear.
---------------------------------------------------------------------*/
co_linear( a, b, c )
struct tvertex *a, *b, *c;
{
	return ( c->v[Z] - a->v[Z] ) * ( b->v[Y] - a->v[Y] ) -
               ( b->v[Z] - a->v[Z] ) * ( c->v[Y] - a->v[Y] ) == 0
            && ( b->v[Z] - a->v[Z] ) * ( c->v[X] - a->v[X] ) -
               ( b->v[X] - a->v[X] ) * ( c->v[Z] - a->v[Z] ) == 0
            && ( b->v[X] - a->v[X] ) * ( c->v[Y] - a->v[Y] ) -
               ( b->v[Y] - a->v[Y] ) * ( c->v[X] - a->v[X] ) == 0  ;
}

      
/*----------------------------------------------------------------------
       Pre_vol calculates the volume information that corresponds to 
   each face and stores it in the face structure.
  ----------------------------------------------------------------------*/
pre_vol( f )
struct tface *f;
{
        double x1, x2, x3, y1, y2, y3, z1, z2, z3;

        x1 = f->vert[0]->v[0];
        y1 = f->vert[0]->v[1];
        z1 = f->vert[0]->v[2];

        x2 = f->vert[1]->v[0] - x1;
        y2 = f->vert[1]->v[1] - y1;
        z2 = f->vert[1]->v[2] - z1;

        x3 = f->vert[2]->v[0] - x1;
        y3 = f->vert[2]->v[1] - y1;
        z3 = f->vert[2]->v[2] - z1;
        
        f->p[X] =  y3*z2 - y2*z3;
        f->p[Y] =  x2*z3 - x3*z2;
        f->p[Z] =  x3*y2 - x2*y3; 

}

