/* ================================================================== 
    Clean.c   This file contains the functions that take care of
    cleaning up the data structures. 
   ==================================================================*/

#include "3DHull_structs.h"
#include "3DHull_macros.h"

/*-------------------------------------------------------------------------
       Clean_up goes through each data structure list and clears all
   flags and NULLs out some pointers.  In the vertex list,  
   the duplicate pointer is set to NULL. In the
  edge list any struture that is marked deleted gets deleted from the 
  edge list, and in the vertex list any face that is marked visible gets
  deleted from the face list.  
  ------------------------------------------------------------------------*/
clean_up()
{

	clean_edges();
	clean_faces();
	clean_vertices();

}

/*------------------------------------------------------------------------
      Clean_edges runs through the edge list and cleans up the structure.
   If there is a face in the edges adjacent face[2] then it will put
   that face in place of the visible face and set adjacent face[2] to 
   NULL.  It will also delete any edge marked deleted.
  -----------------------------------------------------------------------*/
clean_edges()
{
	register struct tedge *e ;
	int i;
	
        /* replace the visible face with the new face */
	for (i = 0 ; i < adj_2_edge_no ; i++ )	{
		e = adj_2_edges[i] ;
                if ( e->adjface[0]->visible ) e->adjface[0] = e->adjface[2]; 
                else e->adjface[1] = e->adjface[2];
                e->adjface[2] = NULL;
                }

        /* delete any edges marked deleted */
        for (i = 0 ; i < bad_edge_no ; i++ ) {
		e = bad_edges[i];
		if (1 == e->endpts[0]->order--) 
			*( bad_vertices + bad_vertex_no++ ) = e->endpts[0] ;
		if (1 == e->endpts[1]->order--) 
			*( bad_vertices + bad_vertex_no++ ) = e->endpts[1] ;
		DEL_QUEUE ( edges, e ) ;
		}

	adj_2_edge_no = bad_edge_no = 0;
}

/*------------------------------------------------------------------------
         Clean_faces runs through the face list and deletes any face
   marked visible.
  -----------------------------------------------------------------------*/
clean_faces()
{
	int i;
	for (i = 0 ; i < bad_face_no ; i++ ) DEL_QUEUE( faces, bad_faces[i] );
	bad_face_no = 0;
}

/*-------------------------------------------------------------------------
      Clean_vertices runs through the vertex list and deletes the 
   vertices that are marked as used but are not incident to any undeleted
   edges. It will also set the duplicate pointer to NULL.
  -------------------------------------------------------------------------*/
clean_vertices()
{
	struct tedge *e;
	struct tvertex *v ;
	int i;

        /* delete all vertices that are marked */
	for (i = 0 ; i < bad_vertex_no ; i++ )  
                     DEL_QUEUE( vertices, bad_vertices[i] );

	bad_vertex_no = 0;

        /* reset  duplicate pointer */
	for (i = 0 ; i < duplicate_vertex_no ; i++ )  
                (duplicate_vertices[i])->duplicate = NULL; 

	duplicate_vertex_no = 0;
   
}
