#include "2D-DT_defines.h"

/****************************************************************/
/*	Voronoi Diagram Routines.
/****************************************************************/

/****************************************************************/
/*	Graph Traversal Routines
/****************************************************************/

push_edge(stack,edge)
struct EDGE_STACK *stack;
EDGE_PTR edge;
{
    if (stack->ptr == stack_size) {
        printf("cannot push onto stack: stack is too large\n");
    }
    else {
	stack->elts[++stack->ptr] = edge;
    }
};

push_ring(stack, edge)
struct EDGE_STACK *stack;
EDGE_PTR edge;
{
    EDGE_PTR nex;
    nex = onext(edge);
    while (nex != edge) {
	if (seen(nex) == 0) {
	   seen(nex) = 1;
	   push_edge(stack, nex);
	}
	nex = onext(nex);
    }
};

push_nonzero_ring(stack, edge)
struct EDGE_STACK *stack;
EDGE_PTR edge;
{
    EDGE_PTR nex;
    nex = onext(edge);
    while (nex != edge) {
	if (seen(nex) != 0) {
	   seen(nex) = 0;
	   push_edge(stack, nex);
	}
	nex = onext(nex);
    }
};

zero_seen(my_stack,edge)
EDGE_PTR edge;
struct EDGE_STACK *my_stack;
{
    my_stack->ptr = 0;
    push_nonzero_ring(my_stack, edge);
    while (my_stack->ptr != 0) {
        edge = pop_edge(my_stack);
	push_nonzero_ring(my_stack, sym(edge));
    }
};
