#include "2D-DT_defines.h"

/****************************************************************/
/*	Quad-edge manipulation primitives
/****************************************************************/
EDGE_PTR makeedge(origin, destination)
VERTEX_PTR origin, destination;
{
    register EDGE_PTR temp, ans;
    temp = alloc_edge();
    ans = temp;

    onext(temp) = ans;
    orig(temp) = origin;
    onext(++temp) = ans + 3;
    onext(++temp) = ans + 2;
    orig(temp) = destination;
    onext(++temp) = ans + 1;

    return(ans);
};

splice(a,b)
EDGE_PTR a, b;
{
    EDGE_PTR alpha, beta, temp;
    alpha = rot(onext(a));
    beta = rot(onext(b));
    temp = onext(alpha);
    onext(alpha) = onext(beta);
    onext(beta) = temp;
    temp = onext(a);
    onext(a) = onext(b);
    onext(b) = temp;
};

swapedge(e)
EDGE_PTR e;
{
    EDGE_PTR a,b,syme;
    a = oprev(e);
    syme = sym(e);
    b = oprev(syme);
    splice(e, a);
    splice(syme, b);
    splice(e, lnext(a));
    splice(syme, lnext(b));
    orig(e) = dest(a);
    dest(e) = dest(b);
};
