#include <stdio.h>
#include <gl.h>
#include <device.h>
#include "knobs.h"

#define BUTTONH 30   /* Default button height */
#define ARROWM  4
#define ARROWY  (BUTTONH/2 - MITRE - ARROWM)

/*
 *   BUTTON_METHODS: Methods for handling a nice push
 *   button triggered on mouse up.
 */

/*
 *   Draw the complete button.
 */

int button_draw (control,mode)

ControlType *control;   /* The button's data structure */
int mode;               /* -1 - Dropshadow, 0 - inactive, 1 - active */

{
   int buffer;

   if (control->type != BUTTON)      /* Are we the right stuff? */
      return (1);

   buffer = getbuffer();
   frontbuffer (1);

   if (control->x_size == 0)         /* Autosizing */
   {
      if (control->style == 0) /* 3-D button */
         control->x_size = 2*TEXTMARGIN + 2*MITRE + strwidth(control->name);
      else
         control->x_size = 2*TEXTMARGIN + strwidth(control->name);
   }
   if (control->y_size == 0)
      control->y_size = BUTTONH;

   if (mode == -1)   /* Draw the drop shadow */
   {
      setpattern (1);      /* Checked pattern */
      KnobColor (3);       /* Black shadow */
      if (control->style == 0)   /* 3-D button */
      {
         rectf ((Coord) (control->x + DROPOFF), (Coord) (control->y - DROPOFF),
                (Coord) (control->x + control->x_size + DROPOFF),
                (Coord) (control->y + control->y_size - DROPOFF));
      }
      else if (control->style == 1)  /* Round edge button */
      {
         if (control->x_size > 2*CORNERRAD)  /* Major box */
            rectf ((Coord) (control->x + CORNERRAD + DROPOFF),
                   (Coord) (control->y - DROPOFF),
                   (Coord) (control->x + control->x_size + DROPOFF - CORNERRAD),
                   (Coord) (control->y + control->y_size - DROPOFF));
         if (control->y_size > 2*CORNERRAD)  /* Minor boxes */
         {
            rectf ((Coord) (control->x + DROPOFF),
                   (Coord) (control->y + CORNERRAD - DROPOFF),
                   (Coord) (control->x + DROPOFF + CORNERRAD),
                   (Coord) (control->y + control->y_size - DROPOFF -
                            CORNERRAD));
            rectf ((Coord) (control->x + control->x_size - CORNERRAD + DROPOFF),
                   (Coord) (control->y + CORNERRAD - DROPOFF),
                   (Coord) (control->x + control->x_size + DROPOFF),
                   (Coord) (control->y + control->y_size - DROPOFF -
                            CORNERRAD));
         }

         arcf ((Coord) (control->x + CORNERRAD + DROPOFF),
               (Coord) (control->y + CORNERRAD - DROPOFF),
               (Coord) (CORNERRAD), (Angle) 1800, (Angle) 2700);
         arcf ((Coord) (control->x + CORNERRAD + DROPOFF),
               (Coord) (control->y + control->y_size - DROPOFF - CORNERRAD),
               (Coord) (CORNERRAD), (Angle) 900, (Angle) 1800);
         arcf ((Coord) (control->x + control->x_size + DROPOFF - CORNERRAD),
               (Coord) (control->y + control->y_size - DROPOFF - CORNERRAD),
               (Coord) (CORNERRAD), (Angle) 0, (Angle) 900);
         arcf ((Coord) (control->x + control->x_size + DROPOFF - CORNERRAD),
               (Coord) (control->y + CORNERRAD - DROPOFF),
               (Coord) (CORNERRAD), (Angle) 2700, (Angle) 0);
      }
      setpattern (0);
   }
   else
   {

/*
 *   Draw the basic form.
 */
      if (control->style == 0)   /* 3-D button */
         KnobPanel (control->x, control->y, control->x_size, control->y_size);
      else if (control->style == 1) /* Rounded button */
      {
         KnobColor (0);   /* Brightest */
         if (control->x_size > 2*CORNERRAD)  /* Major box */
            rectf ((Coord) (control->x + CORNERRAD),
                   (Coord) (control->y),
                   (Coord) (control->x + control->x_size - CORNERRAD),
                   (Coord) (control->y + control->y_size));
         if (control->y_size > 2*CORNERRAD)  /* Minor boxes */
         {
            rectf ((Coord) (control->x),
                   (Coord) (control->y + CORNERRAD),
                   (Coord) (control->x + CORNERRAD),
                   (Coord) (control->y + control->y_size - CORNERRAD));
            rectf ((Coord) (control->x + control->x_size - CORNERRAD),
                   (Coord) (control->y + CORNERRAD),
                   (Coord) (control->x + control->x_size),
                   (Coord) (control->y + control->y_size - CORNERRAD));
         }

         arcf ((Coord) (control->x + CORNERRAD),
               (Coord) (control->y + CORNERRAD),
               (Coord) (CORNERRAD), (Angle) 1800, (Angle) 2700);
         arcf ((Coord) (control->x + CORNERRAD),
               (Coord) (control->y + control->y_size - CORNERRAD),
               (Coord) (CORNERRAD), (Angle) 900, (Angle) 1800);
         arcf ((Coord) (control->x + control->x_size - CORNERRAD),
               (Coord) (control->y + control->y_size - CORNERRAD),
               (Coord) (CORNERRAD), (Angle) 0, (Angle) 900);
         arcf ((Coord) (control->x + control->x_size - CORNERRAD),
               (Coord) (control->y + CORNERRAD),
               (Coord) (CORNERRAD), (Angle) 2700, (Angle) 0);
      }

      button_update (control, mode);  /* Fill in the blank */
   }
   if (!(buffer & 2))
      frontbuffer (0);
   
}

/*
 *   Update the button as if a change of status has occured.
 */

int button_update (control,mode)

ControlType *control;
int mode;      /* 0 - inactive, 1 - active */

{
   int buffer;

   if (control->type != BUTTON)      /* Are we the right stuff? */
      return (1);

   buffer = getbuffer();
   frontbuffer (1);

   if (mode == 0)  /* Inactive colors */
      KnobColor (1);
   else
      KnobColor (3);

/*
 *   Draw the edge piping.
 */
   if (control->style == 0)   /* 3-D button */
   {
      if (control->current)
         rectf ((Coord) (control->x + MITRE), (Coord) (control->y + MITRE),
                (Coord) (control->x + control->x_size - MITRE),
                (Coord) (control->y + control->y_size - MITRE));
      else
      {
         KnobColor (0);
         rectf ((Coord) (control->x + MITRE), (Coord) (control->y + MITRE),
                (Coord) (control->x + control->x_size - MITRE),
                (Coord) (control->y + control->y_size - MITRE));
         KnobColor (3);
         rect  ((Coord) (control->x + MITRE), (Coord) (control->y + MITRE),
                (Coord) (control->x + control->x_size - MITRE),
                (Coord) (control->y + control->y_size - MITRE));
      }
   }
   else if (control->style == 1) /* round button */
   {
      if (control->x_size > 2*CORNERRAD)  /* Major box */
      {
         move2 ((Coord) (control->x + CORNERRAD), (Coord) (control->y));
         draw2 ((Coord) (control->x + control->x_size - CORNERRAD),
                (Coord) (control->y));
         move2 ((Coord) (control->x + CORNERRAD),
                (Coord) (control->y + control->y_size));
         draw2 ((Coord) (control->x + control->x_size - CORNERRAD),
                (Coord) (control->y + control->y_size));
      }
      if (control->y_size > 2*CORNERRAD)  /* Minor boxes */
      {
         move2 ((Coord) (control->x), (Coord) (control->y + CORNERRAD));
         draw2 ((Coord) (control->x),
                (Coord) (control->y + control->y_size - CORNERRAD));
         move2 ((Coord) (control->x + control->x_size),
                (Coord) (control->y + CORNERRAD));
         draw2 ((Coord) (control->x + control->x_size),
                (Coord) (control->y + control->y_size - CORNERRAD));
      }

      arc  ((Coord) (control->x + CORNERRAD),
            (Coord) (control->y + CORNERRAD),
            (Coord) (CORNERRAD), (Angle) 1800, (Angle) 2700);
      arc  ((Coord) (control->x + CORNERRAD),
            (Coord) (control->y + control->y_size - CORNERRAD),
            (Coord) (CORNERRAD), (Angle) 900, (Angle) 1800);
      arc  ((Coord) (control->x + control->x_size - CORNERRAD),
            (Coord) (control->y + control->y_size - CORNERRAD),
            (Coord) (CORNERRAD), (Angle) 0, (Angle) 900);
      arc  ((Coord) (control->x + control->x_size - CORNERRAD),
            (Coord) (control->y + CORNERRAD),
            (Coord) (CORNERRAD), (Angle) 2700, (Angle) 0);
   }

/*
 *   Now draw the text label.
 */

   if (control->current)  /* Highlighted */
      KnobColor (0);
   else
   {
      if (mode == 0)  /* Inactive colors */
         KnobColor (1);
      else
         KnobColor (3);
   }

   cmov2 ((Coord) (control->x + 
          (control->x_size - strwidth(control->name))/2 + TEXTHFUDGE),
          (Coord) (control->y + (control->y_size - getheight())/2 +
                    TEXTVFUDGE));
   charstr (control->name);
/*
 *   Draw a checkmark if requested.
 */
   if (control->flag)   /* Draw a check mark */
   {
      move2 ( (Coord) (control->x + MITRE + ARROWM),
             (Coord) (control->y + BUTTONH/2 - 2));
      rdr2 ((Coord) ARROWY, (Coord) -ARROWY);
      rdr2 ((Coord) ARROWY, (Coord) (2*ARROWY + 2));
      rdr2 ((Coord) -1, (Coord) 1);
      rdr2 ((Coord) -(ARROWY - 1), (Coord) -(2*ARROWY + 3));
      rdr2 ((Coord) - (ARROWY - 1), (Coord) (ARROWY+1));
   }
   if (!(buffer & 2))
      frontbuffer (0);
}

/*
 *   Service a button, wait for a mouse up within the button.
 */

int button_service (control)

ControlType *control;

{
   int i,j, ret_code = 0;
   int buffer;
   if (control->type != BUTTON)      /* Are we the right stuff? */
      return (-1);

   if (mouse_state == 1 && mouse_transition)  /* Mouse going up */
   {
      if (mouse_x > control->x && mouse_y > control->y &&
          mouse_x < (control->x + control->x_size) &&
          mouse_y < (control->y + control->y_size))
      {
/*
 *   Bingo!!! Make the inside flash the correct number of times.
 */
         buffer = getbuffer();
         frontbuffer (1);

         for (i = 0 ; i < FLASHES ; i++)
         {
       
            KnobColor (2);
            if (control->style == 0) /* 3D button */
            {
               rectf ((Coord) (control->x + MITRE + 1),
                      (Coord) (control->y + MITRE + 1),
                      (Coord) (control->x + control->x_size - MITRE - 1),
                      (Coord) (control->y + control->y_size - MITRE - 1));
            }
            else if (control->style == 1) /* rounded buttons */
            {
               if (control->x_size > 2*CORNERRAD)  /* Major box */
                  rectf ((Coord) (control->x + CORNERRAD),
                         (Coord) (control->y + 1),
                         (Coord) (control->x + control->x_size - CORNERRAD),
                         (Coord) (control->y + control->y_size - 1));
               if (control->y_size > 2*CORNERRAD)  /* Minor boxes */
               {
                  rectf ((Coord) (control->x + 1),
                         (Coord) (control->y + CORNERRAD),
                         (Coord) (control->x + CORNERRAD),
                         (Coord) (control->y + control->y_size - CORNERRAD));
                  rectf ((Coord) (control->x + control->x_size - CORNERRAD),
                         (Coord) (control->y + CORNERRAD),
                         (Coord) (control->x + control->x_size - 1),
                         (Coord) (control->y + control->y_size - CORNERRAD));
               }

               arcf ((Coord) (control->x + CORNERRAD),
                     (Coord) (control->y + CORNERRAD),
                     (Coord) (CORNERRAD - 1), (Angle) 1800, (Angle) 2700);
               arcf ((Coord) (control->x + CORNERRAD),
                     (Coord) (control->y + control->y_size - CORNERRAD),
                     (Coord) (CORNERRAD - 1), (Angle) 900, (Angle) 1800);
               arcf ((Coord) (control->x + control->x_size - CORNERRAD),
                     (Coord) (control->y + control->y_size - CORNERRAD),
                     (Coord) (CORNERRAD - 1), (Angle) 0, (Angle) 900);
               arcf ((Coord) (control->x + control->x_size - CORNERRAD),
                     (Coord) (control->y + CORNERRAD),
                     (Coord) (CORNERRAD - 1), (Angle) 2700, (Angle) 0);
            }
            KnobColor (0);
            cmov2 ((Coord) (control->x + 
                   (control->x_size - strwidth(control->name))/2 + TEXTHFUDGE),
                   (Coord) (control->y + (control->y_size - getheight())/2 +
                             TEXTVFUDGE));
            charstr (control->name);
/*
 *   Draw a checkmark if requested.
 */
            if (control->flag)   /* Draw a check mark */
            {
               move2 ( (Coord) (control->x + MITRE + ARROWM),
                      (Coord) (control->y + BUTTONH/2 - 2));
               rdr2 ((Coord) ARROWY, (Coord) -ARROWY);
               rdr2 ((Coord) ARROWY, (Coord) (2*ARROWY + 2));
               rdr2 ((Coord) -1, (Coord) 1);
               rdr2 ((Coord) -(ARROWY - 1), (Coord) -(2*ARROWY + 3));
               rdr2 ((Coord) - (ARROWY - 1), (Coord) (ARROWY+1));
            }

            for (j = 0 ; j < FLASHDELAY ; j++)
               gsync ();   /* Wait the right amount of time */

            KnobColor (0);
            if (control->style == 0) /* 3D button */
            {
               rectf ((Coord) (control->x + MITRE + 1),
                      (Coord) (control->y + MITRE + 1),
                      (Coord) (control->x + control->x_size - MITRE - 1),
                      (Coord) (control->y + control->y_size - MITRE - 1));
            }
            else if (control->style == 1) /* rounded buttons */
            {
               if (control->x_size > 2*CORNERRAD)  /* Major box */
                  rectf ((Coord) (control->x + CORNERRAD),
                         (Coord) (control->y + 1),
                         (Coord) (control->x + control->x_size - CORNERRAD),
                         (Coord) (control->y + control->y_size - 1));
               if (control->y_size > 2*CORNERRAD)  /* Minor boxes */
               {
                  rectf ((Coord) (control->x + 1),
                         (Coord) (control->y + CORNERRAD),
                         (Coord) (control->x + CORNERRAD),
                         (Coord) (control->y + control->y_size - CORNERRAD));
                  rectf ((Coord) (control->x + control->x_size - CORNERRAD),
                         (Coord) (control->y + CORNERRAD),
                         (Coord) (control->x + control->x_size - 1),
                         (Coord) (control->y + control->y_size - CORNERRAD));
               }

               arcf ((Coord) (control->x + CORNERRAD),
                     (Coord) (control->y + CORNERRAD),
                     (Coord) (CORNERRAD - 1), (Angle) 1800, (Angle) 2700);
               arcf ((Coord) (control->x + CORNERRAD),
                     (Coord) (control->y + control->y_size - CORNERRAD),
                     (Coord) (CORNERRAD - 1), (Angle) 900, (Angle) 1800);
               arcf ((Coord) (control->x + control->x_size - CORNERRAD),
                     (Coord) (control->y + control->y_size - CORNERRAD),
                     (Coord) (CORNERRAD - 1), (Angle) 0, (Angle) 900);
               arcf ((Coord) (control->x + control->x_size - CORNERRAD),
                     (Coord) (control->y + CORNERRAD),
                     (Coord) (CORNERRAD - 1), (Angle) 2700, (Angle) 0);
            }
            KnobColor (3);
            cmov2 ((Coord) (control->x + 
                   (control->x_size - strwidth(control->name))/2 + TEXTHFUDGE),
                   (Coord) (control->y + (control->y_size - getheight())/2 +
                             TEXTVFUDGE));
            charstr (control->name);
/*
 *   Draw a checkmark if requested.
 */
            if (control->flag)   /* Draw a check mark */
            {
               move2 ( (Coord) (control->x + MITRE + ARROWM),
                      (Coord) (control->y + BUTTONH/2 - 2));
               rdr2 ((Coord) ARROWY, (Coord) -ARROWY);
               rdr2 ((Coord) ARROWY, (Coord) (2*ARROWY + 2));
               rdr2 ((Coord) -1, (Coord) 1);
               rdr2 ((Coord) -(ARROWY - 1), (Coord) -(2*ARROWY + 3));
               rdr2 ((Coord) - (ARROWY - 1), (Coord) (ARROWY+1));
            }

            for (j = 0 ; j < FLASHDELAY ; j++)
               gsync ();   /* Wait the right amount of time */
         }

         button_update (control);
         if (!(buffer & 2))
            frontbuffer (0);
         ret_code = 1;
      }
   }

   return (ret_code);
}

