/****************************************************************************
 * call_out.c
 * Author Joel Welling and Chris Nuuja
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
/*
The routines in this module define call_out routines for alisp.  To define
a new call_out, add an appropriate line to  both routines.
*/

#include <stdio.h>
#include "alisp.h"
#include "syscall.h"
#include "ge_error.h"
#ifdef incp3d
#include "p3d.h"
#include "matrix_ops.h"
#include "render_ctrl.h"
#endif

/* Needed externals */
 
/*	
	This is the routine that identifies a variable as a known call-out 
	routine.  If the name of the routine does not appear here, attempts 
	to call that routine will result in a UNKOWN CALL_OUT ROUTINE error 
*/
int is_callOut(name)
char *name;
{
	if (!strcmp(name,"shellcall"))			return(1);
#ifdef incp3d
	if (!strcmp(name,"make-vertex"))                return(1);
	if (!strcmp(name,"make-color"))                 return(1);
	if (!strcmp(name,"make-vector"))                return(1);
	if (!strcmp(name,"make-point"))                 return(1);
	if (!strcmp(name,"do-gob"))			return(1);
	if (!strcmp(name,"do-light"))			return(1);
	if (!strcmp(name,"do-ambient"))			return(1);
	if (!strcmp(name,"do-triangle"))		return(1);
	if (!strcmp(name,"do-polygon"))			return(1);
	if (!strcmp(name,"do-polyline"))		return(1);
	if (!strcmp(name,"do-polymarker"))		return(1);
	if (!strcmp(name,"do-mesh"))			return(1);
	if (!strcmp(name,"do-bezier"))			return(1);
	if (!strcmp(name,"do-sphere"))			return(1);
	if (!strcmp(name,"do-cylinder"))		return(1);
	if (!strcmp(name,"do-torus"))			return(1);
	if (!strcmp(name,"do-text"))			return(1);
	if (!strcmp(name,"do-free-gob"))		return(1);
	if (!strcmp(name,"dumpgob"))			return(1);
	if (!strcmp(name,"traverselights"))		return(1);
	if (!strcmp(name,"render"))			return(1);
	if (!strcmp(name,"set-camera"))			return(1);
	if (!strcmp(name,"setup"))			return(1);
	if (!strcmp(name,"reset"))			return(1);
	if (!strcmp(name,"make-translate"))		return(1);
	if (!strcmp(name,"make-rotate"))		return(1);
	if (!strcmp(name,"make-scale"))			return(1);
	if (!strcmp(name,"compose-transform"))		return(1);
	if (!strcmp(name,"make-identity"))		return(1);
	if (!strcmp(name,"toggle-debug"))		return(1);
	if (!strcmp(name,"make-material"))              return(1);
	if (!strcmp(name,"color-r"))                    return(1);
	if (!strcmp(name,"color-g"))                    return(1);
	if (!strcmp(name,"color-b"))                    return(1);
	if (!strcmp(name,"color-a"))                    return(1);
	if (!strcmp(name,"point-x"))                    return(1);
	if (!strcmp(name,"point-y"))                    return(1);
	if (!strcmp(name,"point-z"))                    return(1);
	if (!strcmp(name,"vector-x"))                   return(1);
	if (!strcmp(name,"vector-y"))                   return(1);
	if (!strcmp(name,"vector-z"))                   return(1);
	if (!strcmp(name,"vertex-x"))                   return(1);
	if (!strcmp(name,"vertex-y"))                   return(1);
	if (!strcmp(name,"vertex-z"))                   return(1);
	if (!strcmp(name,"vertex-clr"))                 return(1);
	if (!strcmp(name,"vertex-normal"))              return(1);
	if (!strcmp(name,"vertex-index"))               return(1);
#endif
	return(0);
}
/*
	This routine actually preforms the call out routine.  It matches 
	the routine name, which comes in as a string "call_name" to the  
	the appropriate function call					 
*/

NODE *apply_callOut(call_name,theArgs)
char *call_name;
NODE *theArgs;
{
#ifdef incp3d
	if (!strcmp(call_name, "make-vertex"))
	        return(vertex_create(theArgs));
	if (!strcmp(call_name, "make-color"))
	        return(color_create(theArgs));
	if (!strcmp(call_name, "make-vector"))
	        return(vector_create(theArgs));
	if (!strcmp(call_name, "make-point"))
	        return(point_create(theArgs));
	if (!strcmp(call_name, "dumpgob"))
		return( dumpgob( car(theArgs) ) );
	if (!strcmp(call_name, "setup"))
		return(setup( theArgs ));
	if (!strcmp(call_name, "reset"))
		return(reset( theArgs ));
	if (!strcmp(call_name, "traverselights"))
		return(traverselights(theArgs));
	if (!strcmp(call_name, "render"))
		return(render(theArgs));
	if (!strcmp(call_name, "set-camera"))
		return(set_camera(car(theArgs)));
	if (!strcmp(call_name, "do-gob"))
		return(do_gob(car(theArgs)));
	if (!strcmp(call_name, "do-light"))
		return(do_light(theArgs));
	if (!strcmp(call_name, "do-ambient"))
		return(do_ambient(theArgs));
	if (!strcmp(call_name, "do-triangle"))
		return(do_triangle(car(theArgs)));
	if (!strcmp(call_name, "do-polygon"))
		return(do_polygon(car(theArgs)));
	if (!strcmp(call_name, "do-polyline"))
		return(do_polyline(car(theArgs)));
	if (!strcmp(call_name, "do-polymarker"))
		return(do_polymarker(car(theArgs)));
	if (!strcmp(call_name, "do-mesh"))
		return(do_mesh(car(theArgs)));
	if (!strcmp(call_name, "do-bezier"))
		return(do_bezier(car(theArgs)));
	if (!strcmp(call_name, "do-sphere"))
		return(do_sphere());
	if (!strcmp(call_name, "do-cylinder"))
		return(do_cylinder());
	if (!strcmp(call_name, "do-torus"))
		return(do_torus(theArgs));
	if (!strcmp(call_name, "do-text"))
		return(do_text(theArgs));
	if (!strcmp(call_name, "do-free-gob"))
		return(do_free_gob(car(theArgs)));
	if (!strcmp(call_name, "toggle-debug"))
		return(do_toggle_debug());
	if (!strcmp(call_name, "make-rotate"))
		return(Make_Rotate(car(theArgs)));
	if (!strcmp(call_name, "make-scale"))
		return(Make_Scale(car(theArgs)));
	if (!strcmp(call_name, "make-translate"))
		return(Make_Translate(car(theArgs)));
	if (!strcmp(call_name, "compose-transform"))
		return(matrix_mult((Transformation)car(theArgs), 
			(Transformation)car(cdr(theArgs))));
	if (!strcmp(call_name, "make-identity"))
		return(Make_Identity());
	if (!strcmp(call_name, "make-material"))
	        return(material_create(car(theArgs)));
	if (!strcmp(call_name, "color-r"))
	        return(lisp_color_r(car(theArgs)));
	if (!strcmp(call_name, "color-g"))
	        return(lisp_color_g(car(theArgs)));
	if (!strcmp(call_name, "color-b"))
	        return(lisp_color_b(car(theArgs)));
	if (!strcmp(call_name, "color-a"))
	        return(lisp_color_a(car(theArgs)));
	if (!strcmp(call_name, "point-x"))
	        return(lisp_point_x(car(theArgs)));
	if (!strcmp(call_name, "point-y"))
	        return(lisp_point_y(car(theArgs)));
	if (!strcmp(call_name, "point-z"))
	        return(lisp_point_z(car(theArgs)));
	if (!strcmp(call_name, "vector-x"))
	        return(lisp_vector_x(car(theArgs)));
	if (!strcmp(call_name, "vector-y"))
	        return(lisp_vector_y(car(theArgs)));
	if (!strcmp(call_name, "vector-z"))
	        return(lisp_vector_z(car(theArgs)));
	if (!strcmp(call_name, "vertex-x"))
	        return(lisp_vertex_x(car(theArgs)));
	if (!strcmp(call_name, "vertex-y"))
	        return(lisp_vertex_y(car(theArgs)));
	if (!strcmp(call_name, "vertex-z"))
	        return(lisp_vertex_z(car(theArgs)));
	if (!strcmp(call_name, "vertex-clr"))
	        return(lisp_vertex_color(car(theArgs)));
	if (!strcmp(call_name, "vertex-normal"))
	        return(lisp_vertex_normal(car(theArgs)));
	if (!strcmp(call_name, "vertex-index"))
	        return(lisp_vertex_index(car(theArgs)));
#endif
	if (!strcmp(call_name, "shellcall"))
		return(shellcall(theArgs));
	ger_error("ERROR, unknown call_out routine %s ",call_name);
	return(NIL);
}

void shutdown_callOut()
/* 
This routine does anything needed to shut down software connected
to alisp via the callout interface.
*/
{
#ifdef incp3d
      terminate();
#endif
}
