/****************************************************************************
 * alisp.c
 * Author Chris Nuuja
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "alisp.h"
#include "parse.h"

/*command-line arguements*/
int	gargc;
char	**gargv;

/* Some global nodes */
NODE	*NIL,*TRUE_NODE;

/* 
   When SESSION_END is non zero, either the end of the file parsed is reached,
   or quit primitive
*/
int SESSION_END=0;

/*defstruct parsing elements*/
char	*defstruct_name;    /*used to hold name in defstruct*/
char	**defstruct_field;  /*used to hold field in defstruct*/
char	**defstruct_list;   /*used to hold the result of parse_defstruct()*/
int	field_num;	    /*number of fields in defstruct*/
short	wipeout;	    /*set when end of defstruct_list is reached*/

/* Files to read */
G_FILES	*f_stack;

/*main will set the global vars gargc and gargv to
 *argc and argv to be used in open_nxt_file() in 
 *lexer.c.  Then it will call parse_stream() to 
 *execute the program*/
alisp(argc, argv)
int argc;
char *argv[];
{

    gargc = argc;
    gargv = argv; 

    fprintf(stderr,"\n\n:>");
    setup_env();
    /* setup parse initializes file stack  */
    setup_parse();
    parse();
    cleanup_env();
    cleanup_parse();
    shutdown_callOut();

    return(1);
}
