;/****************************************************************************
; * P3D device dependent definitions file
; * Author Joel Welling and Chris Nuuja
; * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
; *
; * Permission use, copy, and modify this software and its documentation
; * without fee for personal use or use within your organization is hereby
; * granted, provided that the above copyright notice is preserved in all
; * copies and that that copyright and this permission notice appear in
; * supporting documentation.  Permission to redistribute this software to
; * other organizations or individuals is not granted;  that must be
; * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
; * University make any representations about the suitability of this
; * software for any purpose.  It is provided "as is" without express or
; * implied warranty.
; *****************************************************************************/

;The following provide the struct-like representation of P3D basic structs
(defun make-point (&key (x 0.0) (y 0.0) (z 0.0))
  (~make-point x y z))
(defun point-x (&rest pnt) (~point-x pnt))
(defun point-y (&rest pnt) (~point-y pnt))
(defun point-z (&rest pnt) (~point-z pnt))

(defun make-vector (&key (x 0.0) (y 0.0) (z 0.0))
  (~make-vector x y z))
(defun vector-x (&rest vec) (~vector-x vec))
(defun vector-y (&rest vec) (~vector-y vec))
(defun vector-z (&rest vec) (~vector-z vec))

(defun make-color (&key (r 0.8) (g 0.8) (b 0.8) (a 1.0))
  (~make-color r g b a))
(defun color-r (&rest clr) (~color-r clr))
(defun color-g (&rest clr) (~color-g clr))
(defun color-b (&rest clr) (~color-b clr))
(defun color-a (&rest clr) (~color-a clr))

(defun make-vertex (&key (x 0.0) (y 0.0) (z 0.0) 
			 (clr nil) (normal nil) (index 0))
  (~make-vertex x y z clr normal index))
(defun vertex-x (&rest vtx) (~vertex-x vtx))
(defun vertex-y (&rest vtx) (~vertex-y vtx))
(defun vertex-z (&rest vtx) (~vertex-z vtx))
(defun vertex-clr (&rest vtx) (~vertex-clr vtx))
(defun vertex-normal (&rest vtx) (~vertex-normal vtx))
(defun vertex-index (&rest vtx) (~vertex-index vtx))

;These are the basic definitions for P3D.
(defun p3d-setup (p3d-renderer p3d-device p3d-controller p3d-startframe 
			     p3d-framecopies p3d-outfile p3d-hints)
  (~setup p3d-renderer p3d-device p3d-controller p3d-startframe 
	  p3d-framecopies p3d-outfile p3d-hints))
(defun do-sphere () (~do-sphere))
(defun do-cylinder () (~do-cylinder))
(defun do-torus (bigradius smallradius) (~do-torus bigradius smallradius))
(defun do-polyline (&rest args) (~do-polyline args))
(defun do-polymarker (&rest args) (~do-polymarker args))
(defun do-polygon (&rest args) (~do-polygon args))
(defun do-triangle (&rest args) (~do-triangle args))
(defun do-mesh (&rest args) (~do-mesh args))
(defun do-bezier (&rest args) (~do-bezier args))
(defun do-text (txtpoint uvec vvec txtstring)
	(~do-text txtpoint uvec vvec txtstring))
(defun do-light (location lightcolor) (~do-light location lightcolor))
(defun do-ambient (lightcolor) (~do-ambient lightcolor))
(defun make-translate (&rest args) (~make-translate args))
(defun make-rotate (&rest args) (~make-rotate args))
(defun make-scale (&rest args) (~make-scale args))
(defun make-identity () (~make-identity))
(defun compose-transform (trans1 trans2) (~compose-transform trans1 trans2))

;This function sees each new gob as it is defined.
(defun do-gob (thisgob)
	(~do-gob thisgob))
;	(let ((result (~do-gob thisgob )))
;		(setf (aref thisgob 3) nil)
;		result))

;This function frees memory associated with a gob, destroying it.
(defun do-free-gob (thisgob)
	(~do-free-gob thisgob)
	(setf (gob-idnum thisgob) nil)
	(setf (gob-parent-count thisgob) nil)
	(setf (gob-primitive thisgob) nil)
	(setf (gob-attr thisgob) nil)
	(setf (gob-transform thisgob) nil)
	(setf (gob-children thisgob) nil)
	)
 
;This function renders the given object with the given 
;attributes  and transformation by traversing
;the geometry DAG descending from the object.
;In this implementation it is completely implemented as a call-out.
(defun render (object current-trans current-attr)
	(~render object current-trans current-attr))

;This function traverses the DAG depending from the given object, defining
;a light when it finds an appropriate leaf node.
;In this implementation it is completely implemented as a call-out.
(defun traverselights (object current-trans current-attr)
	(~traverselights object current-trans current-attr))

;This function sets the camera.  In this implementation it is completely
; implemented as a call-out.
(defun set-camera (object)
	(~set-camera object))

;This function ties in creation of materials, a user data type.
(defun make-material (&rest args) (~make-material args))

