---------------------------------------------------------------------------
                                 P3D:  

   Software for 3D Modelling from the Pittsburgh Supercomputing Center
---------------------------------------------------------------------------

The Pittsburgh Supercomputing Center is pleased to provide a free set
of tools for the construction and display of 3D models.  These tools
are based around P3D, which is a metafile format for the storage of 3D
models.  P3D stands for Pittsburgh Three Dimensional, but the P might
also stand for Programmable.  A P3D file is in fact a program written
in a language called Common Lisp, with a small number of extensions
for doing 3D modelling.  These programs are generated automatically by
various applications, just as text formatters generate programs in the
Postscript page description language, there so is no need to learn
lisp to use P3D.  Like Postscript, the programmability of P3D makes it
easy to adapt an application to generate the model file.

The current release (2.1) of the P3D software runs on Unix and VMS
systems.  This release contains a specification for the P3D format
(see the document p3d_descr.doc or p3d_descr.ps), and a number of
programs falling into two classes.  Some programs (found in the
'modelbuilders' subdirectory of this distribution) generate P3D
models, while others (found in the 'src' subdirectory) display them.
Additional contributed software can be found in the 'contrib'
subdirectory.

                         MODEL GENERATORS

There are 5 model generators included in this release.  Each of these
has documentation provided in the 'doc' subdirectory of its directory
in the 'modelbuilders' directory tree.

Probably the most useful generator is DrawP3D, a general 3D subroutine
library capable of producing P3D files as output.  DrawP3D is a
hierarchical graphics system like PHIGS or Dore, although it is
simpler than either.  It can draw all the P3D primitives (spheres,
cylinders, tori, polypoints, polylines, polygons, triangle strips,
generalized meshes, text, and Bezier patches), and supports a wide
range of inheritable attributes.  Some higher-level facilities are
provided as well.  The nicest of these are the facilities for
extracting isosurfaces and Z surfaces from gridded or ungridded data.
A "Marching Cubes" algorithm is used to produce isosurfaces from 3D
gridded data; Dirichlet tesselation followed by a "Marching Tets"
algorithm is used with ungridded data.  DrawP3D is callable from C or
Fortran, and a partial C++ interface exists as well.  We hope
eventually to make it possible to use DrawP3D interactively, but for
the moment it can only be used to produce P3D metafiles.

Another model generator provides a command line interface to the
Marching Cubes algorithm.  It can be used to extract an isosurface
from a 3D rectangular array of data, and color it if desired.  This
tool, marchp3d, currently uses the Marching Cubes implementation from
the Scry package produced at Lawrence Berkley Labs; it will be
switched over to our Marching Cubes algorithm (as used in DrawP3D) in
a later release.

The movietop3d model generator converts Movie.BYU format geometry
files to P3D format.  If you have files in this format, this tool can
be used to import them into P3D.  Movie.BYU displacements and scalar
fields are supported.

PDBModel is a simple converter for producing CPK models from molecular
coordinate data in Protien Database format.  This tool is presented
mainly as an example.  We have much better tools for doing molecular
dynamics with P3D, but they are too complex to include with this
distribution.  Contact us (for example, welling@psc.edu) for details.

The 'flyby' subdirctory of the modelbuilders directory tree contains
trace_snaps, a simple tool for producing fly-bys of P3D models by
spline interpolation.

                            RENDERERS

A renderer is a program which takes a P3D file and produces an image
or a set of images from it.  This release contains nine renderers,
ranging from high-speed interactive renderers to interfaces for ray
tracers.  A renderer on a fast, 3D modelling workstation might read a
P3D file and display the model on screen, allowing you to rotate the
model as desired to see any side of it.  A simpler renderer might draw
a wire frame image of the same P3D file on a tektronix screen.  A high
quality renderer will allow nice, antialiased images to be produced
from the same P3D models, at the cost of additional rendering time.

The P3D software supports six high-speed renderers.  The most widely
used is Painter, which uses the Painter's Algorithm to render models
on any device supported by the PSC's GPLOT software.  This includes X
Window System platforms, Tektronix terminals, Postscript, and CGM, the
ANSI/ISO standard format for 2D images.  (For obvious reasons building
Painter requires our GPLOT software, available by anonymous FTP from
ftp.psc.edu).  Renderers are also provided for generic PHIGS, DEC and
Sun PHIGS+, Silicon Graphics GL, and Stardent/Kubota's Dore.

We support the following three high-quality renderers.  For high-
quality images with free software, we have an interface to the ART ray
tracer, provided with the VORT package.  VORT is available by
anonymous FTP from gondwana.ecr.mu.oz.au; we have been working
together with the authors and there is now an excellent degree of
compatibility between ART and P3D.  We also support a partial
interface between P3D and the Rayshade ray tracer (regrettably still
version 3.0); that code is included in this distribution.  For
higher-speed high quality rendering, we are pleased to support an
interface to Pixar's Renderman standard.

The renderers are available in two forms: non-interactive and
interactive.  In either case any of the above renderers can be used.
The first form just marches through the P3D file, showing each view of
each model that the P3D file specifies.  The traditional name for this
executable is render-p3d (render_p3d on VMS).  The second form pauses
each time the P3D file tells it to show a view, and lets the user
rotate the view on the screen, zoom in and out, and so on.
Traditionally this form is called display-p3d (display_p3d on VMS) if
it uses a keyboard user interface, mp3d if it uses a Motif user
interface, olp3d with an Open Look interface, or glp3d with a Silicon
Graphics GL interface.  Each of these programs take a P3D model as a
command line argument;  they are all pretty self-explanatory but some
have documentation in this ('doc') directory.

There are also two utilities for printing out readable versions of the
models in P3D files, useful mostly for debugging.  They are dump-p3d
and tdump-p3d (dump_p3d and tdump_p3d on VMS); they show the elements
of the model as they are being defined and as they are being rendered
respectively.


                         DOCUMENTATION

Documentation for the P3D interpreter and renderers is to be found in
the 'doc' subdirectory of the main P3D directory tree, where you found
this document.  General information is given for the package, and some
additional information is given for the individual renderers and user
interfaces.  The best advice for dealing with this is just to browse;
unfortunately it is not in man page format or any other standard
format.

Documentation for individual model generators is given in the 'doc'
subdirectories of their individual directories of the 'modelbuilders'
subtree.  See in particular the documentation and examples for DrawP3D
in p3d/modelbuilders/drawp3d/doc.


                          LOAD FILES

The subtree p3d/load includes a set of .lsp files which are loaded by
the P3D interpreter as it begins rendering a P3D model.  The location
of that subdirectory is compiled into the renderers;
it is set by the specification of the root path given in the
config.imake file during installation.  

The P3D renderers must find these files in order to run.  They will
first look in the current directory;  this allows replacement of these
files with local versions if desired.  (For example, see the
description of p3d_dflts.lsp in render-p3d.t).  They then check for
the existence of the environment variable P3DLOADDIR.  If it is set to
a directory name, that directory is searched for the load files.  If
it is not set, the compiled-in directory is searched.  


                          SAMPLES

The subtree p3d/samples contains a number of interesting and useful
P3D models.  The best approach to them is simply to browse through
them with one of the P3D renderers.


                       FINAL COMMENTS

We have a facility for producing high-quality animations from P3D
model data.  If you are interested in information about this process,
please contact us at welling@psc.edu.  All the necessary software is
free, but the hardware is nontrivial.

All the P3D software is available to be copied and run at your home
site.  The software is available by anonymous FTP from ftp.psc.edu, in
the pub/p3d directory.  If you take a copy of the software, please
send mail to welling@psc.edu saying you have done so so that we can
inform you of updates and bug fixes.  If you have questions, comments,
or requests about P3D, please send them also.  The project is still
under way; your suggestions can make a big difference in the
facilities we provide and the order in which we provide them.



