Olp3d is a tool for examining models in a P3D model file.  It uses a
point-and-click user interface based on Open Look to control a
renderer which can rapidly draw 3D models.  Olp3d is the name given at
the PSC to the version of display-p3d which uses this Open Look
interface with the Painter renderer.  Other combinations are also
possible; see for example display-p3d.t.

On the PSC machines, olp3d uses the Painter renderer.  This renderer
uses lines and polygons to draw objects from back to front, so that
near things cover up things which are farther away.  This is called
the Painter's Algorithm, because it is what real painters supposedly
do.  This algorithm is fairly fast and general, but it is not perfect.
Sometimes, from some angles, display-p3d will show an object which
should be hidden by another object, or vice versa.  We're sorry about
this, but using this simple renderer allows display-p3d to be used by
users with the widest possible range of home equipment.  The algorithm
will work best if all the objects (polygons, lines, etc.) in a model
are around the same size.

Olp3d draws on your workstation or X terminal screen using one of the
two X Window System device drivers for our CGM translator, GPlot.  By
default the "xws" device driver is used; users with monochrome
displays may prefer the "xl" device driver.  To change the device
driver, do the following.  If you want to use device "xl", driver, for
example) place a file named p3d_dflts.lsp in the directory from which
you will be running olp3d.  The file should contain the following line:

	(setq p3d-device "xl")

When you start up olp3d, that file will be read and the "xl" device
will be used.  A number of other parameters, for example the default
attributes used by olp3d, can be changed by the same mechanism.  We
hope to add a more convenient mechanism in the future.  Note that only
the two devices "xws" and "xl" will work with olp3d; to use other GPlot
device drivers use display-p3d (a similar executable built with a
keyboard user interface instead of Motif).  Note also that the
settings in your p3d_dflts.lsp file will effect other P3D renderers,
so it is necessary to keep careful track of them if you are switching
between olp3d and some other P3D renderer.

Once the appropriate display device is set, you can proceed to display
your P3D file.  If the file you want to examine is mymodel.p3d, the
appropriate command is:

% olp3d mymodel.p3d

When the command is entered, the lisp code which makes up the model
will be parsed by the lisp interpreter within display-p3d.  (If you
want to use the interpreter directly, give the display-p3d command
without a file name).  

As the program starts up, a new window will open on your display;
when the first model in your file has been loaded it will be displayed
in that window.  Text will continue to be output to the window in
which you started olp3d.  This text is sometimes informative, but if
you wish to avoid it (for example, to run olp3d in the background),
redirect both the standard output and standard error to /dev/null.
On Unix systems, the command to run olp3d in the background would be:

% olp3d mymodel.p3d >& /dev/null &

If you wish to start up olp3d automatically, or otherwise wish to start
it without providing a model file name, use the name mouse_strt.p3d.
This file is stored in a location from which it can be automatically
found and loaded, so it provides a convenient first model for the
renderer.

Once olp3d has started, you will have an interactive window in which
to view your P3D model.  The window can be resized at any time, by
dragging on the corners of the window in the usual way.  

There are two pull-down menus in the window.  The 'File' menu contains
options which allow you to load a new p3d file, move on the the next
model in the current file, or quit.  The 'Controls' menu contains a
button which will produce a distance control.  To move the viewpoint
nearer to or farther from the model, slide the slider in the distance
control that this menu item produces.  (Note that if you get too near
or too far, your model will disappear as it moves outside the hither
or yon clipping distances in effect).

To understand how to rotate the model, imagine it embedded in a
transparent crystal ball.  The model is rotated by pressing the left
mouse button while the mouse is in one place on the model, dragging
with the mouse button down, and then releasing the button.  The effect
is as if the mouse were a finger being used to roll the ball in which
the model is embedded.  This is a hard thing to describe, but if you
try the experiment a few times while visualizing the crystal ball, it
will become fairly obvious.

The model can be translated (moved without rotation) by dragging
across it with the middle mouse button pressed.  When the button is
released, the model will move to its new location.  The effect is as
if the mouse had been used to grab the model and drag it to a new
location.  Note that you can only move the model in the plane of the
screen this way.  To move the model in the third dimension, rotate the
model 90 degrees (as described above) and then translate it.

In addition to supporting most of the usual X Window System command
line options, olp3d supports the command line option -captive.  This
option prevents new model files from being opened from olp3d's 'File'
menu. 

If you are using the "xws" device driver and the colors of your model
don't look correct, it may be because the software is having
difficulty controlling the color map of your display.  A quick fix is
to try the Unix command "xstdcmap -all".  If this doesn't work, call
PSC user services or send mail to welling@psc.edu for advice.  Color
map handling is unfortunately rather vendor-dependent and it is not
always easy to convince the display to produce the colors desired.

