
                       P3D Usage Examples

Example 1: Setting the default device for the Painter renderer to be the
---------  Sun CGI device driver.

The PSC's graphics software (including GPlot) includes a device driver
for Sun workstations.  In GPlot, you get access to that driver by
specifying /dev=sun (or -dsun on Unix) on the command line.  To make
P3D draw to the same device, create a file in the directory from which
you will be running P3D with the name 'p3d_dflts.lsp'.  The file
should contain the line

(setq p3d-device "sun")

When you run display-p3d or render-p3d, the program will find your file
and use it to override the default output device, so that your model
gets drawn properly in a workstation window.


Example 2: Looking at a P3D model with display-p3d
---------

Suppose you have a P3D file named file.p3d .  (If you want to try this
out, you can get one of the sample files from /usr/local/p3d/samples
(p3d$root:[samples] on VMS).  camel.p3d is a good example).  We will
also assume that you are working at a Tektronix terminal or a program
emulating a Tektronix terminal, and that you haven't changed the default
device driver (see example 1) so that the appropriate device driver will
be used.  The Unix command to start display-p3d are the following:

$ display-p3d file.p3d

(This assumes that you have /usr/local/p3d in your path).  On VMS, the
commands are:

$ setup p3d   (a PSC command that need only be given once per login session)
$ display_p3d file.p3d  (note the underscore)

Some time will pass while the program reads in your p3d file;  if the
machine is heavily loaded or if your model is quite big it can take
several minutes.  Then the model will be drawn on your screen.

After the model is drawn, a short message will appear offering you
help information.  If you type 'h (ret)' or '? (ret)' (where (ret)
means pressing the return key) the program will give a list of the
command keys it recognizes.  If you type 'u', 'd', 'l', 'r', 'i', or
'o' (all followed by (ret), the model will be redrawn on your screen
from a new viewpoint.  'u' moves you up, 'd' moves you down, 'l' moves
left, 'r' moves right, 'i' moves in, and 'o' moves out.  If you type
some integer, like 10, before you type a command key you will move
that many times as far.  If there is more than one model in your P3D
file, you can type 'q' to go on to the next one.  (There is only one
in camel.p3d).  If you want to exit display-p3d completely, type
'e' (again followed by (ret)).

There are a couple of ways to get messed up in this process.  The simplest
is to be looking somewhere where your model isn't.  If the generator that
produced your model is working properly, this shouldn't happen, but if
you have written your P3D file yourself it might.  If it happens, one
thing you can do is to look around until you see the model, but this
can take a lot of looking.  The other option is to go back and check
the 'camera' information specified in the P3D file, to make sure it's
pointing in a reasonable direction.

Another way that things can go wrong has to do with two special distances
called the hither and yon clipping distances.  Only things which are
farther than the hither distance and closer than the yon distance will
be drawn.  This means that it's possible to be looking straight at your
model and still not see it, if it is too close or too far away.  If the
program that generated your P3D file is working properly, this shouldn't
happen right away when you run display-p3d.  (If you have created the
P3D file yourself, see the comments in the last paragraph).  If you can
originally see the model, and then zoom in or out until suddenly all or
part of the model disappears, this may be the reason why.  To make it
reappear, just zoom back the other way.  You can change the hither and
yon distances easily by editing the P3D file.  You should find the
place where the 'camera' is specified, and just change the two clearly
labeled numbers that appear there.

One other thing to be careful of is zooming in to the very center of your
model.  Each time you use the 'i' command, you move inward by 10% of the
distance to the point you started out looking at.  If you use a command
like '10i', you will move all the way to the center.  The renderer may
crash, and in any case you will not be able to move back because even
if you say '10o' you will only be moving 10 times 10% of a zero distance.
The moral of this is that you should move inward in reasonably small
steps.

