Dore Demo User Interface
------------------------

File: dore_ui.c, other Dore DUI routines

Works with renderers: Dore renderer driver only

Interaction: by keyboard strokes, dial box, etc.

Required Hooks: 
	ren_dore_objhook, which returns the Dore object corresponding to a
	given gob:

		DtObject ren_dore_objhook(thisgob)
		gob thisgob;


Light support: none (DUI chooses lights)

Camera support: none (DUI chooses camera)

Model support: full

Auxiliary routines:
	ui_free is a noop; the Dore representation of a gob is never freed.
	ui_setup substitutes "none" for the device and controller.

Comments:
	This user interface provides an interface between P3D and the Dore
	Demo User Interface.  The entire P3D file is parsed, and all 
	calls to ui_render result in the gob to be rendered being added
	to a list, which is saved.  When parsing is complete, that list
	is used by the DUI software to render the models.  Multiple
	models in a single P3D file can thus be 'animated' by DUI to
	show time evolution.  The models can be manipulated by any
	method normally available to DUI, but only after the P3D file
	has been completely traversed and lisp parsing is complete.

	The main routine for this user interface is within the DUI
	software.  That software calls dore_ui.c via the geom_spec
	entry point.  The DUI software handles initialization of DORE,
	so the Dore renderer must not do so.  This is accomplished by
	passing it the device "none".


	
	


