/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/MenuShell.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/DrawnB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/Label.h>
#include <Xm/Form.h>

#include "view.h"
#include "doodle.h"

#include "d_arrow.xbm"
#include "d_box.xbm"
#include "d_doodle.xbm"
#include "d_erase.xbm"
#include "d_erasebox.xbm"
#include "d_line.xbm"
#include "d_oval.xbm"
#include "d_text.xbm"
#include "d_asel.xbm"
#include "d_psel.xbm"
#include "d_lsel.xbm"
#include "d_hlsel.xbm"
#include "d_vlsel.xbm"


#define BUT_DIM		15

#ifndef MALLOC
#define MALLOC  malloc
#define FREE    free
#endif


extern Widget InitPen();
extern Widget InitPenMenu();
extern void CBGrabProc();
extern void CBClearDrawArea();
extern void CBSetPaste();
extern void CBSetPasteNoBack();
extern void CBSetLine();
extern void CBSetArrow();
extern void CBSetOval();
extern void CBSetBox();
extern void CBSetFreehand();
extern void CBSetText();
extern void CBSetErase();
extern void CBSetEraseBlock();
extern void CBSetAreaSelect();
extern void CBSetLineSelect();
extern void CBSetXLineSelect();
extern void CBSetYLineSelect();
extern void CBSetPointSelect();
extern void CBSetGlobalPointer();
extern void CBDoContour();
extern void DrawPenPointer();
extern void SetButton();
extern void UnsetButton();
extern unsigned long BestColor();


extern Display *myDpy;
extern GC drawAreaGC;


void
CBExposeColor(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	struct match_rec *mptr = (struct match_rec *)client_data;
	Cardinal i;
	Arg argList[10];
	unsigned long pixel;
	DColor dc;

	dc.red = mptr->red;
	dc.green = mptr->green;
	dc.blue = mptr->blue;

	pixel = 0;
	pixel = BestColor(mptr->V->cData, &dc);

	i = 0;
	XtSetArg(argList[i], XmNbackground, pixel); i++;
	XtSetValues(w, argList, i);
}


void
CBMatchColor(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	struct match_rec *mptr = (struct match_rec *)client_data;
	Cardinal i;
	Arg argList[10];
	unsigned long pixel;
	DColor dc;

	dc.red = mptr->red;
	dc.green = mptr->green;
	dc.blue = mptr->blue;

	pixel = 0;
	pixel = BestColor(mptr->V->cData, &dc);

	i = 0;
	XtSetArg(argList[i], XmNbackground, pixel); i++;
	XtSetValues(w, argList, i);

	mptr->V->doodleColor = pixel;
	DrawPenPointer(mptr->V);

	if (mptr->V->matchButton)
	{
		if (mptr->V->matchButton->widget != w)
		{
			UnsetButton(mptr->V->matchButton->widget);
			mptr->V->matchButton = mptr;
			SetButton(mptr->V->matchButton->widget);
		}
		else
		{
			UnsetButton(mptr->V->matchButton->widget);
			mptr->V->matchButton = NULL;
		}
	}
	else
	{
		mptr->V->matchButton = mptr;
		SetButton(mptr->V->matchButton->widget);
	}
}


/*
 * Create a doodle overlay toolbox off the passed main form and menubar.
 * Returns the widget id of the main form widget.
 */
Widget
InitOverlayTools(V, mainform, menuBar, oform, pform)
	View *V;
	Widget mainform;
	Widget menuBar;
	Widget *oform;
	Widget *pform;
{
	int cnt;
	Cardinal i;
	Arg argList[30];
	Widget form, pal;
	Widget form1, form2;
	Widget b, b1, b2;
	Widget pen;
	Widget overlayPulldown;
	XmString label;
	struct match_rec *mptr;
	Pixmap button_pix;
	Pixel fg, bg;

	i = 0;
        XtSetArg(argList[i], XmNforeground, &fg); i++;
        XtSetArg(argList[i], XmNbackground, &bg); i++;
        XtGetValues(menuBar, argList, i);

	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, menuBar); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNresizable, False); i++;
	form = XmCreateForm(mainform, "ToolForm", argList, i);
	XtManageChild(form);

	pal = InitPen(V, form);
	V->colorpal = pal;

	/*
	 * The selection tools
	 */
    if ((V->type == V_RASTER)||(V->type == V_SHEET))
    {

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_psel_bits, d_psel_width, d_psel_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, pal); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetPointSelect, (caddr_t)V);
	XtManageChild(b);
	b1 = b;

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_asel_bits, d_asel_width, d_asel_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b1); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetAreaSelect, (caddr_t)V);
	XtManageChild(b);
	b2 = b;
    }

    if (V->type == V_RASTER)
    {

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_hlsel_bits, d_hlsel_width, d_hlsel_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b1); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, pal); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetXLineSelect, (caddr_t)V);
	XtManageChild(b);
	b1 = b;

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_vlsel_bits, d_vlsel_width, d_vlsel_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b2); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b1); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetYLineSelect, (caddr_t)V);
	XtManageChild(b);
	b2 = b;

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_lsel_bits, d_lsel_width, d_lsel_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b1); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, pal); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetLineSelect, (caddr_t)V);
	XtManageChild(b);
	b1 = b;

/* FUTURE
	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_erasebox_bits, d_erasebox_width, d_erasebox_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b2); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b1); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetEraseBlock, (caddr_t)V);
	XtManageChild(b);
	b2 = b;
 FUTURE */
    }

	/*
	 * Put the overlay control tools in a separate form
	 */
	i = 0;
    if ((V->type == V_WHITEBOARD)||(V->type == V_TEXT))
    {
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
    }
    else
    {
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b1); i++;
	XtSetArg(argList[i], XmNtopOffset, 3); i++;
    }
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, pal); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	form1 = XmCreateForm(form, "OverlayForm", argList, i);
	XtManageChild(form1);

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_doodle_bits, d_doodle_width, d_doodle_height,
		fg, bg, 8);

	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form1, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetFreehand, (caddr_t)V);
	XtManageChild(b);
	b1 = b;

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_line_bits, d_line_width, d_line_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b1); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form1, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetLine, (caddr_t)V);
	XtManageChild(b);
	b2 = b;

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_oval_bits, d_oval_width, d_oval_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b1); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form1, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetOval, (caddr_t)V);
	XtManageChild(b);
	b1 = b;

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_box_bits, d_box_width, d_box_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b2); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b1); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form1, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetBox, (caddr_t)V);
	XtManageChild(b);
	b2 = b;

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_arrow_bits, d_arrow_width, d_arrow_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b1); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form1, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetArrow, (caddr_t)V);
	XtManageChild(b);
	b1 = b;

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_text_bits, d_text_width, d_text_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b2); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b1); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form1, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetText, (caddr_t)V);
	XtManageChild(b);
	b2 = b;

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_erase_bits, d_erase_width, d_erase_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b1); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form1, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetErase, (caddr_t)V);
	XtManageChild(b);
	b1 = b;

	button_pix = XCreatePixmapFromBitmapData(myDpy,
		DefaultRootWindow(myDpy),
		d_erasebox_bits, d_erasebox_width, d_erasebox_height,
		fg, bg, 8);
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, b2); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b1); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNlabelPixmap, button_pix); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form1, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetEraseBlock, (caddr_t)V);
	XtManageChild(b);
	b2 = b;

	/*
	 * color buttons in a separate form
	 */
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET);i++;
	XtSetArg(argList[i], XmNbottomWidget, pal); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, pal); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	form2 = XmCreateForm(form, "PaletteForm", argList, i);
	XtManageChild(form2);

	cnt = 0;
	mptr = (struct match_rec *)MALLOC(sizeof(struct match_rec));
	mptr->V = V;
	mptr->red = 0;
	mptr->green = 255;
	mptr->blue = 255;
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM);i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNwidth, BUT_DIM); i++;
	XtSetArg(argList[i], XmNheight, BUT_DIM); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form2, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBMatchColor, (caddr_t)mptr);
	XtAddCallback(b, XmNexposeCallback, CBExposeColor, (caddr_t)mptr);
	XtManageChild(b);
	b2 = b;
	mptr->widget = b;
	V->buttonPal[cnt] = mptr;
	cnt++;

	mptr = (struct match_rec *)MALLOC(sizeof(struct match_rec));
	mptr->V = V;
	mptr->red = 255;
	mptr->green = 0;
	mptr->blue = 255;
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM);i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b2); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNwidth, BUT_DIM); i++;
	XtSetArg(argList[i], XmNheight, BUT_DIM); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form2, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBMatchColor, (caddr_t)mptr);
	XtAddCallback(b, XmNexposeCallback, CBExposeColor, (caddr_t)mptr);
	XtManageChild(b);
	b2 = b;
	mptr->widget = b;
	V->buttonPal[cnt] = mptr;
	cnt++;

	mptr = (struct match_rec *)MALLOC(sizeof(struct match_rec));
	mptr->V = V;
	mptr->red = 255;
	mptr->green = 255;
	mptr->blue = 0;
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM);i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b2); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNwidth, BUT_DIM); i++;
	XtSetArg(argList[i], XmNheight, BUT_DIM); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form2, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBMatchColor, (caddr_t)mptr);
	XtAddCallback(b, XmNexposeCallback, CBExposeColor, (caddr_t)mptr);
	XtManageChild(b);
	b2 = b;
	b1 = b;
	mptr->widget = b;
	V->buttonPal[cnt] = mptr;
	cnt++;

	mptr = (struct match_rec *)MALLOC(sizeof(struct match_rec));
	mptr->V = V;
	mptr->red = 255;
	mptr->green = 0;
	mptr->blue = 0;
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_WIDGET);i++;
	XtSetArg(argList[i], XmNbottomWidget, b1); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNwidth, BUT_DIM); i++;
	XtSetArg(argList[i], XmNheight, BUT_DIM); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form2, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBMatchColor, (caddr_t)mptr);
	XtAddCallback(b, XmNexposeCallback, CBExposeColor, (caddr_t)mptr);
	XtManageChild(b);
	b2 = b;
	mptr->widget = b;
	V->buttonPal[cnt] = mptr;
	cnt++;

	mptr = (struct match_rec *)MALLOC(sizeof(struct match_rec));
	mptr->V = V;
	mptr->red = 0;
	mptr->green = 255;
	mptr->blue = 0;
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_WIDGET);i++;
	XtSetArg(argList[i], XmNbottomWidget, b1); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b2); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNwidth, BUT_DIM); i++;
	XtSetArg(argList[i], XmNheight, BUT_DIM); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form2, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBMatchColor, (caddr_t)mptr);
	XtAddCallback(b, XmNexposeCallback, CBExposeColor, (caddr_t)mptr);
	XtManageChild(b);
	b2 = b;
	mptr->widget = b;
	V->buttonPal[cnt] = mptr;
	cnt++;

	mptr = (struct match_rec *)MALLOC(sizeof(struct match_rec));
	mptr->V = V;
	mptr->red = 0;
	mptr->green = 0;
	mptr->blue = 255;
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_WIDGET);i++;
	XtSetArg(argList[i], XmNbottomWidget, b1); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b2); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNwidth, BUT_DIM); i++;
	XtSetArg(argList[i], XmNheight, BUT_DIM); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form2, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBMatchColor, (caddr_t)mptr);
	XtAddCallback(b, XmNexposeCallback, CBExposeColor, (caddr_t)mptr);
	XtManageChild(b);
	b2 = b;
	b1 = b;
	mptr->widget = b;
	V->buttonPal[cnt] = mptr;
	cnt++;

	mptr = (struct match_rec *)MALLOC(sizeof(struct match_rec));
	mptr->V = V;
	mptr->red = 0;
	mptr->green = 0;
	mptr->blue = 0;
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_WIDGET);i++;
	XtSetArg(argList[i], XmNbottomWidget, b1); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNwidth, BUT_DIM); i++;
	XtSetArg(argList[i], XmNheight, BUT_DIM); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form2, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBMatchColor, (caddr_t)mptr);
	XtAddCallback(b, XmNexposeCallback, CBExposeColor, (caddr_t)mptr);
	XtManageChild(b);
	b2 = b;
	mptr->widget = b;
	V->buttonPal[cnt] = mptr;
	cnt++;

	mptr = (struct match_rec *)MALLOC(sizeof(struct match_rec));
	mptr->V = V;
	mptr->red = 255;
	mptr->green = 255;
	mptr->blue = 255;
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_WIDGET);i++;
	XtSetArg(argList[i], XmNbottomWidget, b1); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b2); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNwidth, BUT_DIM); i++;
	XtSetArg(argList[i], XmNheight, BUT_DIM); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form2, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBMatchColor, (caddr_t)mptr);
	XtAddCallback(b, XmNexposeCallback, CBExposeColor, (caddr_t)mptr);
	XtManageChild(b);
	b2 = b;
	mptr->widget = b;
	V->buttonPal[cnt] = mptr;
	cnt++;

	mptr = (struct match_rec *)MALLOC(sizeof(struct match_rec));
	mptr->V = V;
	mptr->red = 128;
	mptr->green = 128;
	mptr->blue = 128;
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_WIDGET);i++;
	XtSetArg(argList[i], XmNbottomWidget, b1); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, b2); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNwidth, BUT_DIM); i++;
	XtSetArg(argList[i], XmNheight, BUT_DIM); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetArg(argList[i], XmNmarginWidth, 0); i++;
	XtSetArg(argList[i], XmNmarginHeight, 0); i++;
	XtSetArg(argList[i], XmNhighlightThickness, 0); i++;
	b = XmCreateDrawnButton(form2, "Button", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBMatchColor, (caddr_t)mptr);
	XtAddCallback(b, XmNexposeCallback, CBExposeColor, (caddr_t)mptr);
	XtManageChild(b);
	b2 = b;
	b1 = b;
	mptr->widget = b;
	V->buttonPal[cnt] = mptr;
	cnt++;

	V->matchButton = NULL;

	*oform = form1;
	*pform = form2;
	return(form);
}

