/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: selection.c,v 1.2 1993/07/14 14:53:26 gbourhis Exp $";
#endif


#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include "view.h"
#include "viewer.h"


extern void DrawText();
extern void PixelText();


extern Display *myDpy;
extern GC invGC;
extern XFontStruct *drawFont;
extern int Swidth, Sheight, Sascent;


static View *myV;


static void SelectionReceived PARAMS((Widget, XtPointer, Atom *, Atom *,
				      XtPointer, unsigned long *, int *));


void
InsertSelText(value, length)
	char *value;
	unsigned long length;
{
	int i;
	int dir, ascent, descent;
	XCharStruct all;

	for (i=0; i<length; i++)
	{
		XFillRectangle(myDpy, XtWindow(myV->drawArea), invGC,
			myV->text_x, (myV->text_y - Sascent), Swidth, Sheight);
		if (value[i] != '\n')
		{
			DrawText(myV, &value[i], 1, myV->text_x, myV->text_y,
				myV->doodleColor);
			PixelText(myV, &value[i], 1, myV->text_x, myV->text_y,
				myV->doodleColor);
		}
		XTextExtents(drawFont, &value[i], 1, &dir,
			&ascent, &descent, &all);
		if (value[i] == '\n')
		{
			myV->text_y = myV->text_y + Sheight;
			myV->text_x = myV->ret_x;
		}
		else
		{
			myV->text_x = myV->text_x + all.width;
		}
		XFillRectangle(myDpy, XtWindow(myV->drawArea), invGC,
			myV->text_x, (myV->text_y - Sascent), Swidth, Sheight);
	}
	XFlush(myDpy);
}



/*
 * All the following code to deal with selections was stolen shamelessly from
 * the Athena Text Widget.
 */

struct SelectionList {
	String *params;
	Cardinal count;
	Time time;
};


static void
GetSelection(w, time, params, num_params)
	Widget w;
	Time time;
	String *params;                 /* selections in precedence order */
	Cardinal num_params;
{
	Atom selection;
	int buffer;

	selection = XInternAtom(XtDisplay(w), *params, False);
	switch (selection)
	{
		case XA_CUT_BUFFER0: buffer = 0; break;
		case XA_CUT_BUFFER1: buffer = 1; break;
		case XA_CUT_BUFFER2: buffer = 2; break;
		case XA_CUT_BUFFER3: buffer = 3; break;
		case XA_CUT_BUFFER4: buffer = 4; break;
		case XA_CUT_BUFFER5: buffer = 5; break;
		case XA_CUT_BUFFER6: buffer = 6; break;
		case XA_CUT_BUFFER7: buffer = 7; break;
		default:	     buffer = -1;
	}
	if (buffer >= 0)
	{
		int nbytes;
		unsigned long length;
		int fmt8 = 8;
		Atom type = XA_STRING;
		char *line = XFetchBuffer(XtDisplay(w), &nbytes, buffer);

		if (length = nbytes)
		    SelectionReceived(w, NULL, &selection, &type,
					(caddr_t)line, &length, &fmt8);
		else if (num_params > 1)
		    GetSelection(w, time, (params + 1), (num_params - 1));
	}
	else
	{
		struct SelectionList* list;

		if (--num_params)
		{
			list = XtNew(struct SelectionList);
			list->params = params + 1;
			list->count = num_params;
			list->time = time;
		}
		else
		{
			list = NULL;
		}
		XtGetSelectionValue(w, selection, XA_STRING, SelectionReceived,
					(XtPointer)list, time);
	}
}


static void
SelectionReceived(w, client_data, selection, type, value, length, format)
	Widget w;
	XtPointer client_data;
	Atom *selection, *type;
	XtPointer value;
	unsigned long *length;
	int *format;
{
	if (*type == 0 /*XT_CONVERT_FAIL*/ || *length == 0)
	{
		struct SelectionList* list =
				(struct SelectionList*)client_data;
		if (list != NULL)
		{
			GetSelection(w, list->time, list->params, list->count);
			XtFree(client_data);
		}
		return;
	}

	InsertSelText(value, *length);

	XtFree(client_data);
	XFree(value);      /* the selection value should be freed with XFree */
}


void
PutSelection(V, w, BuEvent)
	View *V;
	Widget w;
	XButtonPressedEvent *BuEvent;
{
	String params[2];

	myV = V;
	params[0] = (String)MALLOC(strlen("PRIMARY") + 1);
	strcpy(params[0],"PRIMARY");
	params[1] = (String)MALLOC(strlen("CUT_BUFFER0") + 1);
	strcpy(params[1],"CUT_BUFFER0");

	GetSelection(w, BuEvent->time, params, 2);
}

