/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: ras.c,v 1.10 1993/11/05 20:21:09 gbourhis Exp $";
#endif

/* $Log: ras.c,v $
 * Revision 1.10  1993/11/05  20:21:09  gbourhis
 * in MakeRaster(), if type is D_INT, convert min/max to float.
 *
 * Revision 1.9  1993/09/01  20:27:25  davet
 * Changed the default pen width to 5
 *
 * Revision 1.8  1993/06/16  21:52:58  gbourhis
 * bug fix: replace strlen(cdat->name+1) by strlen(cdat->name)+1
 *
 */

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <Xm/MenuShell.h>
#include <Xm/RowColumn.h>
#include <Xm/DrawingA.h>
#include <Xm/ScrollBar.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/Label.h>
#include <Xm/DialogS.h>
#include <Xm/Separator.h>

#include <netdb.h>
#include <sys/socket.h>


#include "portable.h"
#include "view.h"
#include "viewer.h"
#include "doodle.h"
#include "mode.h"
#include "netdata.h"
#include "net.h"
#include "profUI.h"
#include "huePal.h"


#define DEF_BLACK	BlackPixel(myDpy, DefaultScreen(myDpy))
#define DEF_WHITE	WhitePixel(myDpy, DefaultScreen(myDpy))
#define DEF_CMAP	DefaultColormap(myDpy, DefaultScreen(myDpy))
#define	SHADOW	1
#define	WB_WIDTH	400
#define	WB_HEIGHT	400


extern void CBPrintImage();
extern void CBPrintOverlay();
extern void CBPrintOverlayWithImage();
extern boolean magnify();
#ifdef MAC_COMPAT
extern void WhiteboardMap();
#endif /* MAC_COMPAT */
extern int CreateRasterFromFloat();
extern int CreateRasterFromInt();
extern Profile *ProfileCreate();
extern void CBPublish();
extern void CBMakePrivate();
extern void CBMakeSheet();
extern void CBRasSaveImage();
extern void CBRasSaveOverlay();
extern void CBRasSaveImageOverlay();
extern void CBViewOverlay();
extern void CBViewEntirePal();
extern void CBSelection();
extern void CBRasterResize();
extern void CBExposeDoodle();
extern void CBDrawAreaPress();
extern void CBDrawAreaMove();
extern void CBDrawAreaRelease();
extern void CBDrawAreaKeyPress();
extern void CBClearDrawArea();
extern void CBGrabProc();
extern void CBDone();
extern void SetMode();
extern Cdata *CopyCdata();
extern Cdata *CdataSearchByName();
extern Widget InitOptions();
extern Widget InitOverlayTools();
extern Widget RegisterPalMenu();
extern void InitSelMenu();
extern void RegisterData();
extern void ConvertXColorsToRGB();


extern Widget doodleToggle;

extern NetPort *outP;
extern Display *myDpy;
extern Pixmap drawPix;
extern Pixmap doodlePix;
extern Widget	rootWidget;
extern char *UserID;

/* static Widget lineToggle;
static Widget areaToggle; */
static Widget	mainWindow;
static Widget	scrollWindow;
static Widget	drawArea;
static Widget	menuBar;
static Widget	pulldown;
extern XColor systemCCells[256];

static int WhiteCnt = 1;
static int ImageCnt = 1;



void
CBDoContour(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;
	int indx;
	unsigned long mask1, mask2;
	DColor color;
	XColor *xcolor;

	if (V->type != V_RASTER)
	{
		return;
	}

	indx = V->doodleColor;
	xcolor = XColorCellOfView(V, indx);
	color.red = xcolor->red / 256;
	color.green = xcolor->green / 256;
	color.blue = xcolor->blue / 256;

	ContourOverlayInterface(V->cData, &color);
}


void
CBSetMode(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
}


void
CBSetAreaSelect(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, AREASEL);
}


void
CBSetLineSelect(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, LINESEL);
}


void
CBSetXLineSelect(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, XLINESEL);
}


void
CBSetYLineSelect(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, YLINESEL);
}


void
CBSetPointSelect(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, POINTSEL);
}


void
CBSetGlobalPointer(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, GLOBALPOINT);
}


void
CBSetPaste(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, PASTE);
}


void
CBSetPasteNoBack(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, PASTENOBACK);
}


void
CBSetLine(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, LINE);
}


void
CBSetArrow(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, ARROW);
}


void
CBSetOval(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, OVAL);
}


void
CBSetBox(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, BOX);
}


void
CBSetFreehand(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, FREEHAND);
}


void
CBSetText(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, TEXT);
}


void
CBSetErase(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, ERASE);
}


void
CBSetEraseBlock(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	SetMode(w, V, ERASEBLOCK);
}


void
CBSetPolyview(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	if (strcmp(V->cData->name, "Polyview 3.0 Image") != 0)
	{
		XmToggleButtonGadgetSetState(w, False, False);
		return;
	}

	SetMode(w, V, POLYVIEW);
}



View *
InitView(vroot, data, ispub)
	Widget vroot;
	Cdata *data;
	Boolean ispub;
{
	View *V;
	Widget viewshell;
	Widget toolform;
	Widget overlayform;
	Widget paletteform;
	Widget b;
	Arg argList[30];
	Cardinal i;
	XmString label;
	char tlab[256];

	if (!(V = (View *)MALLOC(sizeof(View))))
	{
		fprintf(stderr,"Out of Memory\n");
		exit(1);
	}
	if (strncmp(data->name, "Whiteboard", 10) == 0)
	{
		V->type = V_WHITEBOARD;
	}
	else
	{
		V->type = V_RASTER;
	}
	V->cData = data;

	if (ispub == True)
	{
		sprintf(tlab, "Public %s", data->name);
	}
	else
	{
		sprintf(tlab, "Private %s", data->name);
	}

	/*
	 * Set some necessary resources on the top level shell widget.
	 */
	i = 0;
	if (data->hasPalette)
	  {
	    XtSetArg(argList[i], XtNbackground, 0); i++;
	    XtSetArg(argList[i], XtNcolormap, data->pal->Rcmap); i++;
	  }
	XtSetArg(argList[i], XmNallowShellResize, True); i++;
        XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        XtSetArg(argList[i], XmNdeleteResponse, XmUNMAP); i++;
	viewshell = XtCreatePopupShell(tlab, topLevelShellWidgetClass,
					vroot, argList, i);

	/*
	 * Create the main window area, which is a form widget containing
	 * a menubar, and a scrolled window.
	 */
	i = 0;
	if (data->hasPalette)
	  {
	    XtSetArg(argList[i], XtNcolormap,
		     DefaultColormapOfScreen(XtScreen(viewshell))); i++;
	  }
        XtSetArg(argList[i], XmNresizePolicy, XmRESIZE_GROW); i++;
	mainWindow = XmCreateForm(viewshell, tlab, argList, i);
	XtManageChild(mainWindow);

	/*
	 * Create the menubar to hang all our menus off of
	 */
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	menuBar = XmCreateMenuBar(mainWindow, tlab, argList, i);
	XtManageChild(menuBar);


	/*
	 * File menu
	 */
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	pulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateSimple("File");
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'F'); i++;
	b = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Publish");
        XtSetArg(argList[i], XmNmnemonic, 'u'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBPublish, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Private Copy");
        XtSetArg(argList[i], XmNmnemonic, 'r'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBMakePrivate, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	if (V->type != V_WHITEBOARD)
	{
		i = 0;
		label = XmStringCreateSimple("Make Spreadsheet");
		XtSetArg(argList[i], XmNmnemonic, 'M'); i++;
		XtSetArg(argList[i], XmNlabelString, label); i++;
		b = XmCreatePushButtonGadget(pulldown, "menuButton", argList,i);
		XtAddCallback(b, XmNactivateCallback, CBMakeSheet, (caddr_t)V);
		XtManageChild(b);
		XmStringFree(label);
	}

	i = 0;
	b = XmCreateSeparator(pulldown, "separator", argList, i);
	XtManageChild(b);

	if (V->type != V_WHITEBOARD)
	{
		i = 0;
		label = XmStringCreateSimple("Print Image");
		XtSetArg(argList[i], XmNmnemonic, 'P'); i++;
		XtSetArg(argList[i], XmNlabelString, label); i++;
		b = XmCreatePushButtonGadget(pulldown, "menuButton", argList,i);
		XtAddCallback(b, XmNactivateCallback, CBPrintImage,
			(caddr_t)V);
		XtManageChild(b);
		XmStringFree(label);
	}

	i = 0;
	if (V->type == V_WHITEBOARD)
	{
		label = XmStringCreateSimple("Print...");
	}
	else
	{
		label = XmStringCreateSimple("Print Overlay");
	}
	XtSetArg(argList[i], XmNmnemonic, 'P'); i++;
	XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList,i);
	XtAddCallback(b, XmNactivateCallback, CBPrintOverlay, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	if (V->type != V_WHITEBOARD)
	{
		i = 0;
		label = XmStringCreateSimple("Print Overlay + Image");
		XtSetArg(argList[i], XmNmnemonic, 'P'); i++;
		XtSetArg(argList[i], XmNlabelString, label); i++;
		b = XmCreatePushButtonGadget(pulldown, "menuButton", argList,i);
		XtAddCallback(b, XmNactivateCallback, CBPrintOverlayWithImage,
			(caddr_t)V);
		XtManageChild(b);
		XmStringFree(label);
	}

	i = 0;
	b = XmCreateSeparator(pulldown, "separator", argList, i);
	XtManageChild(b);

	if (V->type != V_WHITEBOARD)
	{
		i = 0;
		label = XmStringCreateSimple("Save Image");
		XtSetArg(argList[i], XmNmnemonic, 'I'); i++;
		XtSetArg(argList[i], XmNlabelString, label); i++;
		b = XmCreatePushButtonGadget(pulldown, "menuButton", argList,i);
		XtAddCallback(b, XmNactivateCallback, CBRasSaveImage,
			(caddr_t)V);
		XtManageChild(b);
		XmStringFree(label);
	}

	i = 0;
	if (V->type == V_WHITEBOARD)
	{
		label = XmStringCreateSimple("Save");
	}
	else
	{
		label = XmStringCreateSimple("Save Overlay");
	}
        XtSetArg(argList[i], XmNmnemonic, 'S'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBRasSaveOverlay, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	if (V->type != V_WHITEBOARD)
	{
		i = 0;
		label = XmStringCreateSimple("Save Image + Overlay");
		XtSetArg(argList[i], XmNmnemonic, 'S'); i++;
		XtSetArg(argList[i], XmNlabelString, label); i++;
		b = XmCreatePushButtonGadget(pulldown, "menuButton", argList,i);
		XtAddCallback(b, XmNactivateCallback, CBRasSaveImageOverlay,
			(caddr_t)V);
		XtManageChild(b);
		XmStringFree(label);
	}

	i = 0;
	b = XmCreateSeparator(pulldown, "separator", argList, i);
	XtManageChild(b);

	i = 0;
	label = XmStringCreateSimple("Close Window");
        XtSetArg(argList[i], XmNmnemonic, 'C'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBDone, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	/*
	 * Edit menu
	 */
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	pulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateSimple("Edit");
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'E'); i++;
	b = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

	if (V->type != V_WHITEBOARD)
	{
		i = 0;
		label = XmStringCreateSimple("Show Overlay");
		XtSetArg(argList[i], XmNlabelString, label); i++;
		XtSetArg(argList[i], XmNmnemonic, 'S'); i++;
		XtSetArg(argList[i], XmNset, True); i++;
		XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
		b = XmCreateToggleButtonGadget(pulldown, "viewer", argList, i);
		XtAddCallback(b, XmNvalueChangedCallback, CBViewOverlay,
			(caddr_t)V);
		XtManageChild(b);
		XmStringFree(label);
	}

	i = 0;
	if (V->type == V_WHITEBOARD)
	{
		label = XmStringCreateSimple("Clear Whiteboad");
	}
	else
	{
		label = XmStringCreateSimple("Clear Overlay");
	}
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'l'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBClearDrawArea, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	b = XmCreateSeparator(pulldown, "separator", argList, i);
	XtManageChild(b);

	i = 0;
	label = XmStringCreateSimple("Copy");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'C'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBGrabProc, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Paste");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'P'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetPaste, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Paste (No Back)");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'N'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetPasteNoBack, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	b = XmCreateSeparator(pulldown, "separator", argList, i);
	XtManageChild(b);

	V->palPulldown = RegisterPalMenu(V, pulldown);
	
	i = 0;
	label = XmStringCreateSimple("Use Palette");
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'U'); i++;
        XtSetArg(argList[i], XmNsubMenuId, V->palPulldown); i++;
	b = XmCreateCascadeButton(pulldown, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Use Entire Palette");
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'E'); i++;
	XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	b = XmCreateToggleButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBViewEntirePal, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);
	V->viewEntirePal = XmToggleButtonGadgetGetState(b);

	V->optionMenu = (Widget) 0;
	V->operationMenu = (Widget) 0;
	if (V->type != V_WHITEBOARD)
	{
		InitSelMenu(V, menuBar);
	}

	/*
	 * Now is only Width menu
	 */
	V->optionMenu = InitOptions(V, menuBar);

	/*
	 * InitOverlayTools sets up the toolbox and sets V->colorpal
	 */
	toolform = InitOverlayTools(V, mainWindow, menuBar,
		&overlayform, &paletteform);

	/*
	 * Create the scrolled window for the image
	 */
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, menuBar); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
/*
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
*/
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, toolform); i++;
        XtSetArg(argList[i], XmNvisualPolicy, XmVARIABLE); i++;
	if (V->type == V_WHITEBOARD)
	{
		XtSetArg(argList[i], XmNscrollBarDisplayPolicy, XmSTATIC); i++;
		XtSetArg(argList[i], XmNscrollingPolicy, XmAPPLICATION_DEFINED);
		i++;
	}
	else
	{
		XtSetArg(argList[i], XmNscrollBarDisplayPolicy, XmAS_NEEDED);
		i++;
		XtSetArg(argList[i], XmNscrollingPolicy, XmAUTOMATIC); i++;
	}
	XtSetArg(argList[i], XmNshadowThickness, SHADOW); i++;
	XtSetArg(argList[i], XmNwidth, (data->xdim + (2 * SHADOW))); i++;
	XtSetArg(argList[i], XmNheight, (data->ydim + (2 * SHADOW))); i++;
	scrollWindow = XmCreateScrolledWindow(mainWindow, "viewer", argList, i);
	XtManageChild(scrollWindow);

	i = 0;
        XtSetArg(argList[i], XmNwidth, data->xdim); i++;
        XtSetArg(argList[i], XmNheight, data->ydim); i++;
        XtSetArg(argList[i], XmNbackground, DEF_WHITE); i++;
	drawArea = XmCreateDrawingArea(scrollWindow, "viewer", argList, i);
	XtManageChild(drawArea);

	/*
	 * Because the scrolled window reparents this beastie
	 */
	i = 0;
        XtSetArg(argList[i], XmNbackground, DEF_WHITE); i++;
	XtSetValues(XtParent(drawArea), argList, i);

	V->shell = viewshell;
	V->drawArea = drawArea;
/*
	V->colorpal = (Widget)NULL;
*/
	V->toolform = overlayform;
	V->palform = paletteform;
	V->rowwin = (Widget)NULL;
	V->colwin = (Widget)NULL;
	V->vscroll = (Widget)NULL;
	V->hscroll = (Widget)NULL;
	V->lastToggle = (Widget)NULL;
	V->dialog = (Widget)NULL;
	V->cutbuffer = (XImage *)NULL;
	V->drawPix = (Pixmap)NULL;
	V->doodlePix = (Pixmap)NULL;
	V->Doodles = (Dptr *)NULL;
	V->isUp = False;
	V->ispub = ispub;
	V->viewOverlay = True;
	V->areaSelect = False;
	V->area_x1 = -1;
	V->area_y1 = -1;
	V->area_x2 = -1;
	V->area_y2 = -1;
	V->lineSelect = False;
	V->pointSelect = False;
	V->Mode = NONE;
#ifdef MAC_COMPAT
	V->doodleWidth = 5;
	/*
	 * On the Mac White = Transparent.  So for a Mac pick a default
	 * doodle color that is real unlikely to be white.
	 */
	V->doodleColor = 128;
#else
	V->doodleWidth = 5;
	V->doodleColor = DEF_BLACK;
#endif /* MAC_COMPAT */
	V->next = NULL;
	data->V = V;

	XtAddEventHandler(V->drawArea, ExposureMask, 0, CBExposeDoodle,
				(caddr_t)V);
	XtAddEventHandler(XtParent(V->drawArea), StructureNotifyMask, 0,
				CBRasterResize, (caddr_t)V);
	XtAddEventHandler(V->drawArea, ButtonPressMask, 0, CBDrawAreaPress,
				(caddr_t)V);
	XtAddEventHandler(V->drawArea, ButtonMotionMask, 0, CBDrawAreaMove,
				(caddr_t)V);
	XtAddEventHandler(V->drawArea, ButtonReleaseMask, 0, CBDrawAreaRelease,
				(caddr_t)V);
	XtAddEventHandler(V->drawArea, KeyPressMask, 0, CBDrawAreaKeyPress,
				(caddr_t)V);
/*
	XtAddEventHandler(drawArea, ButtonReleaseMask, 0, CBSelection, NULL);
*/

	return(V);
}

static GenericPtr
IntBuildRaster(dataBuff, type, xdim, ydim, xmag, ymag, interp, min, max)
     float *dataBuff;
     int type;
     int xdim;
     int ydim;
     int xmag;
     int ymag;
     Bool interp;
     IntOrFloat min; 
     IntOrFloat max; 
{
  unsigned char *rdata, *mdata;
  
  if (type == D_INT)
    {
      if (CreateRasterFromInt(dataBuff, &rdata,
			      xdim, ydim, min.i, max.i, (char)1) == 0)
	return (GenericPtr)NULL;
    }
  else
    {
      if (CreateRasterFromFloat(dataBuff, &rdata,
				xdim, ydim, min.f, max.f, (char)1) == 0)
	return (GenericPtr)NULL;
    }
  
  if ((xmag != 1)||(ymag != 1))
    {
      mdata = (unsigned char *)
	MALLOC(xdim * xmag * ydim * ymag);
      
      if (interp && mdata != (GenericPtr)NULL)
	interpolate_float(rdata, mdata, 0, 0,
			  xdim - 1, ydim - 1,
			  xdim, ydim,
			  xdim * xmag, ydim * ymag);
      else if (mdata != (GenericPtr)NULL)
	magnify(rdata, mdata, 0, 0,
		xdim - 1, ydim - 1,
		xdim, ydim, xdim * xmag, ydim * ymag);
      
      FREE(rdata);
    }
  else
    {
      mdata = rdata;
    }
  return (GenericPtr)mdata;
}

int
BuildRasterbuff(d, xmag, ymag, interp, min, max)
     Cdata *d;
     int xmag;
     int ymag;
     Bool interp;
     IntOrFloat min; 
     IntOrFloat max; 
{

  d->buff = (char *)IntBuildRaster(d->fbuff, d->type, d->xdim, d->ydim,
				   xmag, ymag, interp, min, max);
  if (d->buff == (char *)NULL) {
    ErrMesg("Out of Memory\n");
    return 0;
  }
  d->xdim *= xmag;
  d->ydim *= ymag;
  d->xmag = xmag;
  d->ymag = ymag;

  return 1;
}

void
MakeRaster(V, xmag, ymag, interp, min, max)
     View *V;
     int xmag, ymag;
     Boolean interp;
     IntOrFloat min; 
     IntOrFloat max; 
{
	Data *data;
	Cdata *cdat = V->cData;
	Palette *palette;

	if (!strcmp(cdat->name+strlen(cdat->name)-5, " COPY"))
	  {
		fprintf(stderr, "CANNOT COPY A COPY!!\n");
		return;
	  }
	data = DataNew();
	if (!data)
		return;
	data->label = (char *)MALLOC(strlen(cdat->name) + 6);
	strcpy(data->label, cdat->name);
	strcat(data->label, " COPY");
	data->entity = ENT_Internal;
	data->view_type = V_RASTER;
	data->dot = DOT_Array;
	data->dost = DOST_Char;
	data->rank = 2;
	data->data =
	  IntBuildRaster(cdat->fbuff, cdat->type, cdat->xdim,
			 cdat->ydim, xmag, ymag, (Bool)interp, min, max);
	if (data->data == (GenericPtr)NULL) {
		ErrMesg("Out of Memory\n");
		return;
	      }
	data->dim[0] = cdat->xdim*xmag;
	data->dim[1] = cdat->ydim*ymag;
	if (V->type == V_SHEET) {
		data->associated = (char *)MALLOC(strlen(cdat->name)+1);
		strcpy(data->associated,cdat->name);
	}
	if (cdat->type == D_INT) {
		data->min.f = (float)min.i;
		data->max.f = (float)max.i;
	}
	else {
		data->min = min;
		data->max = max;
	}
	data->expandX = (float)xmag;
	data->expandY = (float)ymag;

	if (cdat->hasPalette)
	  {
		palette = cdat->pal;
		data->group = DataNew();
		data->group->label = (char *)
					MALLOC(strlen(palette->name) + 1);
		strcpy(data->group->label, palette->name);
		data->group->entity = ENT_Internal;
		data->group->dot = DOT_Palette8;
		data->group->dost = DOST_Char;
		data->group->rank = 1;
		data->group->dim[0] = 768;
		data->group->data = palette->rgb;
		data->group->group = NULL;
	  }
	else
	  {
		data->group = NULL;
	  }
	if (V->type == V_3DPANEL) {
		FREE(cdat->fbuff);
		FREE(cdat->name);
		FREE(cdat);
		V->cData = NULL;
	}
	(void)NetSendDataObject(outP, data, True, True,
				"MakeRaster");
}




View *
NewRast(data, ispub)
	Cdata *data;
	Boolean ispub;
{
	View *V;

	V = InitView(rootWidget, data, ispub);
#ifdef MAC_COMPAT
	if (strcmp(data->name, "Whiteboard") == 0)
	{
		XtAddCallback(V->shell, XtNpopupCallback,
			      WhiteboardMap, (caddr_t)V);
	}
	else
	{
#endif /* MAC_COMPAT */
	XtPopup(V->shell, XtGrabNone);
	V->cmap = DefaultColormap(myDpy, XDefaultScreen(myDpy));
#ifdef MAC_COMPAT
	}
#endif /* MAC_COMPAT */
	return(V);
}


#ifdef MAC_COMPAT
void
StartWhiteboard()
{
	int i;
	char name[256];
	char *title;
	unsigned char *ptr;
	unsigned char *data;
	unsigned char *pdata;
	unsigned char white;
	XColor ccells[256];
	Data *d;

	d = NULL;
	sprintf(name, "Whiteboard");

	if (!(data = (unsigned char *) MALLOC(WB_WIDTH * WB_HEIGHT)))
        {
                fprintf(stderr,"Out of Memory for data for %s\n", name);
                return;
        }
	white = (unsigned char)DEF_WHITE;
	ptr = data;
	for (i=0; i < (WB_WIDTH * WB_HEIGHT); i++)
	{
		*ptr++ = white;
	}

	if (!(title = (char *) MALLOC(strlen(name) + 1)))
	{
		fprintf(stderr, "Can't allocate memory for title\n");
		return;
	}
	strcpy(title, name);

	if (!(pdata = (unsigned char *) MALLOC(768)))
	{
		fprintf(stderr, "Can't allocate memory for palette\n");
		return;
	}

/* DDT
	for (i=0; i<256; i++)
	{
		ccells[i].pixel = i;
	}
	XQueryColors(myDpy, DEF_CMAP, ccells, 256);
	ConvertXColorsToRGB(ccells, pdata);
*/
	ConvertSEQtoRGB(huePal,pdata);
	

	d = DataNew();
        d->label = title;
        d->dot = DOT_Array;
        d->dost = DOST_Char;
        d->dim[0] = WB_WIDTH;
        d->dim[1] = WB_HEIGHT;
        d->rank = 2;
	d->data = (char *)data;
	NetRISDistribute(&d, "NewWhite");

	NetPALDistribute(title, pdata, title, "NewWhite");
}
#endif /* MAC_COMPAT */


void
NewWhiteboard()
{
	int i;
	char name[256];
	char *title;
	unsigned char *ptr;
	unsigned char *data;
	unsigned char *pdata;
	unsigned char white;
	XColor ccells[256];
	Cdata *d;

	d = NULL;
	sprintf(name, "Whiteboard %d", WhiteCnt);
        while((d = CdataSearchByName(name)) != NULL)
        {
                WhiteCnt++;
		sprintf(name, "Whiteboard %d", WhiteCnt);
        }
	WhiteCnt++;

	if (!(data = (unsigned char *) MALLOC(WB_WIDTH * WB_HEIGHT)))
        {
                fprintf(stderr,"Out of Memory for data for %s\n", name);
                return;
        }
	white = (unsigned char)DEF_WHITE;
	ptr = data;
	for (i=0; i < (WB_WIDTH * WB_HEIGHT); i++)
	{
		*ptr++ = white;
	}

	if (!(title = (char *) MALLOC(strlen(name) + 1)))
	{
		fprintf(stderr, "Can't allocate memory for title\n");
		return;
	}
	strcpy(title, name);

	if (!(pdata = (unsigned char *) MALLOC(768)))
	{
		fprintf(stderr, "Can't allocate memory for palette\n");
		return;
	}

/* DDT
	for (i=0; i<256; i++)
	{
		ccells[i].pixel = i;
	}
	XQueryColors(myDpy, DEF_CMAP, ccells, 256);
	ConvertXColorsToRGB(ccells, pdata);
*/
	ConvertSEQtoRGB(huePal,pdata);

	NetSendRaster8Group(outP, title, data, WB_WIDTH, WB_HEIGHT, pdata,
		FALSE, TRUE, "NewWhite");
}



void
CBNewWhiteboard(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	NewWhiteboard();
}


void
MakePrivateRaster(V)
	View *V;
{
	View *newV;
	Cdata *newData;
	int new;
	char name[256];
	char *hold_name;

	newData = NULL;
	sprintf(name, "%s: Image %d", UserID, ImageCnt);
        while((newData = CdataSearchByName(name)) != NULL)
        {
                ImageCnt++;
		sprintf(name, "%s: Image %d", UserID, ImageCnt);
        }
	ImageCnt++;

	hold_name = V->cData->name;
	V->cData->name = name;
	new = 0;
	newData = CopyCdata(V->cData, &new);
	V->cData->name = hold_name;
	if ((newData == NULL)||(!new))
	{
		return;
	}
	strcpy(newData->name, name);
	if (newData->type == D_FLOAT || newData->type == D_INT)
	  newData->buff = V->cData->buff;

	newV = InitView(rootWidget, newData, False);
	RegisterData(newData);
	XtPopup(newV->shell, XtGrabNone);
	newV->cmap = DefaultColormap(myDpy, XDefaultScreen(myDpy));
	NewCdata(newV);
}
