/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: main.c,v 1.19 1993/11/24 21:16:54 gbourhis Exp $";
#endif

/* $Log: main.c,v $
 * Revision 1.19  1993/11/24  21:16:54  gbourhis
 * disconnect from the server in case of crash or interrupt.
 * change version string to 1.2.1
 * little fix in CBRasterResize()
 * Some changes in resources names.
 *
 * Revision 1.18  1993/09/01  19:57:27  davet
 *  the Spreadsheet could not deal with variable sized fonts.
 *  Collage will load up a fixed size font for the spreadsheet rather than
 *  use the default font wich is used for the rest of the application.
 *  added the drawFont resource.
 *
 * Revision 1.17  1993/08/27  22:16:50  davet
 * added scaleImage resources.
 * Also, userID code so that it wouldn't include passwd chfn garbage info
 *
 * Revision 1.16  1993/08/23  21:06:27  davet
 * added initialization for the net configuration module
 *
 * Revision 1.15  1993/08/05  17:07:14  gbourhis
 * Add  casting for parameter type checking.
 *
 * Revision 1.14  1993/07/20  19:53:00  gbourhis
 * change version string to 1.2 Beta; don't call Intro() if -load option.
 *
 * Revision 1.13  1993/07/16  01:52:14  davet
 * added chat box support.
 *
 * Revision 1.12  1993/07/13  21:16:16  gbourhis
 * call NetInit() with UserID arg.
 *
 * Revision 1.11  1993/07/07  15:47:22  gbourhis
 * register GotDol() for NETDOL type.
 *
 */

#include <stdio.h>
#include <values.h>	/* to get MAXINT */
#include <signal.h>
#include <string.h>

#ifdef SYSV
#include <sys/types.h>
#endif
#include <pwd.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/Text.h>
#include <Xm/MenuShell.h>
#include <Xm/RowColumn.h>
#include <Xm/DrawingA.h>
#include <Xm/ScrollBar.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/Label.h>

#include <netdb.h>
#include <sys/socket.h>


#include "collageP.h"
#include "list.h"
#include "view.h"
#include "viewer.h"
#include "doodle.h"
#include "mode.h"
#include "net.h"

#include "In.xbm"
#include "Out.xbm"

#define DEF_WHITE	WhitePixel(myDpy, DefaultScreen(myDpy))
#define DEF_BLACK	BlackPixel(myDpy, DefaultScreen(myDpy))
#define DEF_DEPTH	DefaultDepth(myDpy, DefaultScreen(myDpy))
#define DEF_ROOT	DefaultRootWindow(myDpy)


/* static Cdata *currentObject = (Cdata *) 0;
   View *baseView = (View *) 0; */

List	fileLoadList;

extern void Intro();
extern void RegisterPopup();
extern void InitPal();
extern void PalSetup();
extern void TextSetup();
extern void TextExit();
extern void HistSetup();
extern void ProfileSetup();
extern void AnimationSetup();
extern void AnimationExit();
extern void SetLineMode();
extern void SetAreaMode();
extern void CBSelection();
extern void CBClearDrawArea();
extern View *InitControl();
/* extern View *InitView(); */
extern void InitUIMesg();
extern void GotTxt();
extern void GotSds();
extern void GotRis();
extern void GotPal();
extern void GotCol();
extern void GotDol();
extern void GotDtmOrSrv();
extern void GotDelete();
extern void RubberLineSelect();
extern void RubberSelect();
extern void RubberPoint();
extern void RegisterData();
extern void InitDefaultColors();
extern void SetServerLocation();
extern void InitChatBox();
extern void InitNetTimeOut();

#ifdef MAC_COMPAT
extern void StartWhiteboard();
extern void StartText();
#endif /* MAC_COMPAT */


extern NetPort *outP;


static XrmOptionDescRec Options[] = {
        {"-async", ".async", XrmoptionNoArg, "True"},
        {"-drawFont", ".drawFont", XrmoptionSepArg, NULL},
        {"-spreadsheetFont", ".spreadsheetFont", XrmoptionSepArg, NULL},
        {"-id", ".userId", XrmoptionSepArg, NULL},
        {"-basePixel", ".basePixel", XrmoptionSepArg, NULL},
        {"-lastPixel", ".lastPixel", XrmoptionSepArg, NULL},
        {"-debug", ".debug", XrmoptionNoArg, "True"},
        {"-scaleImage", ".scaleImage", XrmoptionNoArg, "True"},
};

#define offset(field)   XtOffset(struct res_struct *, field)
static XtResource res_list[] = {
	{"drawFont",  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
		offset(font), XtRString, "fixed"},
	{"spreadsheetFont", XtCFont, XtRFontStruct, sizeof(XFontStruct *),
		offset(drawFont), XtRString, "fixed"},
/*
	{XtNfont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
		offset(font), XtRString, XtDefaultFont},
*/
	{"async",  "Async", XtRBoolean, sizeof(Boolean),
		offset(async), XtRString, "False"},
	{"userId",  "UserId", XtRString, sizeof(char *),
		offset(id), XtRString, ""},
	{"basePixel",  "BasePixel", XtRInt, sizeof(int),
		offset(base_pixel), XtRString, "30"},
	{"lastPixel",  "LastPixel", XtRInt, sizeof(int),
		offset(last_pixel), XtRString, "254"},
	{"debug",  "Debug", XtRBoolean, sizeof(Boolean),
		offset(debug), XtRString, "off"},
	{"animSource",  "AnimSource", XtRString, sizeof(String),
		offset(anim_source), XtRString, "server"},
	{"tmpDir",  "TmpDir", XtRString, sizeof(String),
		offset(tmp_dir), XtRString, "/tmp/"},
	{"scaleImage",  "ScaleImage", XtRBoolean, sizeof(Boolean),
		offset(scaleImage), XtRString, "True"},
};

#include "fallbacks.c"

extern Widget netButton;


struct res_struct  res_gotten;
Pixmap DataIn, DataOut;
Pixmap row_arrow, col_arrow;
Pixmap drawPix;
Pixmap doodlePix;
Pixmap scratchPix;
int Swidth, Sheight, Sascent;
int SdrawWidth, SdrawHeight, SdrawAscent;
Widget	rootWidget = NULL;
XFontStruct *drawFont;
GC	drawAreaGC;
GC	invGC;
GC	selGC;
GC	textGC;
GC	invtextGC;
GC	clipOnGC;
GC	clipOffGC;
XtAppContext app;
Display	*myDpy = (Display *)0;
int DrawMode;
charRec *fontTable;
char *UserID = NULL;

/* static Widget WhiteTop; */
static Widget PalTop = NULL;

static XtIntervalId PollTimer = 0;

static void RealExit();

int InitializeUI();
void CBMakeCurrentObject();

void FatalProblem(sig,code,scp,addr)
int     sig, code;
struct  sigcontext *scp;
char    *addr;
{
        fprintf(stderr,"\n\nYou have found a bug in\n");
	/*
        fprintf(stderr,"%s",GetVersionDate());
	*/
        fprintf(stderr,"collage Version 1.2.1\n");
	fprintf(stderr,"Please report what you were doing at the time this\n");
        fprintf(stderr,"occured to:  bugs@ncsa.uiuc.edu\n");
        fprintf(stderr,"...exiting collage now\n\n");

        if (myDpy)
                XUngrabPointer(myDpy,CurrentTime);
        XSync(myDpy,True);

	if (outP != NULL &&
	    !NetSendDisconnect(outP, NULL, NULL)) {
		sleep(1);
		NetTryResend();
		}
	if (!res_gotten.debug)
		exit(-1);

        switch(sig) {
                case SIGBUS:    printf("SIGBUS\n");
                        break;
                case SIGSEGV:printf("SIGSEGV\n");
                        break;
                case SIGILL: printf("SIGILL\n");
                        break;
                default: printf("SIG %d\n",sig);
                };

        /* else dump core */
        /* signal(SIGBUS,0);
        signal(SIGSEGV,0);
        signal(SIGILL,0); */
        abort();
}


void CleanExit(sig)
int sig;
{
	if (outP != NULL &&
	    !NetSendDisconnect(outP, NULL, NULL)) {
		sleep(1);
		NetTryResend();
		}
	RealExit();
}


void DevNull(name,type,class,defaultp,params,num_params)
String name;
String type;
String class;
String defaultp;
String *params;
Cardinal *num_params;
{
/* Dev Null error handler .... shhhh*/
}



/*
 * Check for DTM input, and if client_data is set, add a timeout
 * to recheck again later.
 */
static void
CheckForInput(client_data, id)
	caddr_t client_data;  /* should add timeout */
	XtIntervalId *id;
{
	View *V;

	PollTimer = 0;

	NetClientPollAndRead();

	if (client_data)
	{
		PollTimer = XtAppAddTimeOut(app, 100, CheckForInput,
					    client_data);
	}
}


static void
ReClock(client_data, id)
	caddr_t client_data;  /* should add timeout */
	XtIntervalId *id;
{
	if (PollTimer != 0)
	{
		XtRemoveTimeOut(PollTimer);
	}
	PollTimer = XtAppAddTimeOut(app, 100, CheckForInput, (caddr_t)True);
	XtAppAddTimeOut(app, 5000, ReClock, (caddr_t)True);
}


/* not called.
void
ReturnInOut(in, out)
	char *in;
	char *out;
{
	int cnt;
	Arg argList[10];
	Cardinal argcnt;
	XmString label;
	char host[80];
	char tlab[256];
	struct hostent *phe;
	unsigned long num;

	cnt = 0;
	while(in[cnt] != ':')
	{
		host[cnt] = in[cnt];
		cnt++;
	}
	host[cnt] = '\0';
	if (cnt)
	{
		num = inet_addr(host);
		phe = gethostbyaddr((char *)&num, 4, AF_INET);
		if (phe != NULL)
		{
			strcpy(host, phe->h_name);
		}
	}
	else
	{
		gethostname(host, 80);
		phe = gethostbyname(host);
		if (phe != NULL)
		{
			strcpy(host, phe->h_name);
		}
	}

	sprintf(tlab, "<IN>  %s%s", host, &in[cnt]);
	label = XmStringCreateSimple(tlab);
	XmListReplaceItemsPos(dtmList, &label, 1, 1);
	XmStringFree(label);

	if (out == NULL)
	{
		sprintf(tlab, "<OUT> NONE");
	}
	else
	{
		cnt = 0;
		while(out[cnt] != ':')
		{
			host[cnt] = out[cnt];
			cnt++;
		}
		host[cnt] = '\0';
		if (cnt)
		{
			num = inet_addr(host);
			phe = gethostbyaddr((char *)&num, 4, AF_INET);
			if (phe != NULL)
			{
				strcpy(host, phe->h_name);
			}
		}
		else
		{
			gethostname(host, 80);
			phe = gethostbyname(host);
			if (phe != NULL)
			{
				strcpy(host, phe->h_name);
			}
		}

		sprintf(tlab, "<OUT> %s%s", host, &out[cnt]);
	}
	label = XmStringCreateSimple(tlab);
	XmListReplaceItemsPos(dtmList, &label, 1, 2);
	XmStringFree(label);
} */


ContinueInitialization()
/* Called after widgets have been Realized */
{
	int cnt, x, y;
	XGCValues  gcvalues;
	Cardinal argcnt;
	Arg argList[10];
	Pixel fg, bg;
	Widget da;
	Pixmap clipmask;

	/*
	 * Create the main GC to draw Black on White
	 */
	drawAreaGC = XCreateGC(myDpy, XtWindow(rootWidget), 0, &gcvalues);
	XSetForeground(myDpy, drawAreaGC, DEF_BLACK);
	XSetBackground(myDpy, drawAreaGC, DEF_WHITE);
	XSetFont(myDpy, drawAreaGC, drawFont->fid);
	XSetFunction(myDpy, drawAreaGC, GXcopy);

	/*
	 * Create a temporary drawing area to get fg and bg colors from
	 */
	da = XmCreateDrawingArea(rootWidget, "temp", NULL, 0);
	argcnt = 0;
	XtSetArg(argList[argcnt], XmNforeground, &fg); argcnt++;
	XtSetArg(argList[argcnt], XmNbackground, &bg); argcnt++;
	XtGetValues(da, argList, argcnt);
	XtDestroyWidget(da);

	/*
	 * Create the text GC to draw FG on BG
	 */
	textGC = XCreateGC(myDpy, XtWindow(rootWidget), 0, &gcvalues);
	XSetForeground(myDpy, textGC, fg);
	XSetBackground(myDpy, textGC, bg);
/*
	XSetFont(myDpy, textGC, drawFont->fid);
*/
	XSetFont(myDpy, textGC, res_gotten.drawFont->fid);
	XSetFunction(myDpy, textGC, GXcopy);

	/*
	 * Create the selection GC to draw BG on FG
	 */
	invtextGC = XCreateGC(myDpy, XtWindow(rootWidget), 0, &gcvalues);
	XSetForeground(myDpy, invtextGC, bg);
	XSetBackground(myDpy, invtextGC, fg);
/*	XSetFont(myDpy, invtextGC, drawFont->fid);*/
	XSetFont(myDpy, invtextGC, res_gotten.drawFont->fid);
	XSetFunction(myDpy, invtextGC, GXcopy);

	clipmask = XCreatePixmap(myDpy, XtWindow(rootWidget), 10, 10, 1);
	/*
	 * Create the GC to turn on pixels in the clipmask
	 */
	clipOnGC = XCreateGC(myDpy, clipmask, 0, &gcvalues);
	XSetForeground(myDpy, clipOnGC, (unsigned long)1);
	XSetBackground(myDpy, clipOnGC, (unsigned long)0);
	XSetPlaneMask(myDpy, clipOnGC, (unsigned long)1);
	XSetFunction(myDpy, clipOnGC, GXcopy);

	/*
	 * Create the GC to turn off pixels in the clipmask
	 */
	clipOffGC = XCreateGC(myDpy, clipmask, 0, &gcvalues);
	XSetForeground(myDpy, clipOffGC, (unsigned long)0);
	XSetBackground(myDpy, clipOffGC, (unsigned long)0);
	XSetPlaneMask(myDpy, clipOffGC, (unsigned long)1);
	XSetFunction(myDpy, clipOffGC, GXcopy);

	XFreePixmap(myDpy, clipmask);

	/*
	 * Create the inversion GC to draw rubber-band lines
	 */
	invGC = XCreateGC(myDpy, XtWindow(rootWidget), 0, &gcvalues);
	XSetFunction(myDpy, invGC, GXinvert);

	/*
	 * Create the selection GC for raster selections
	 */
	selGC = XCreateGC(myDpy, XtWindow(rootWidget), 0, &gcvalues);
	XSetFunction(myDpy, selGC, GXinvert);
	XSetLineAttributes(myDpy, selGC, 3, LineSolid, CapButt, JoinMiter);

	/*
	 * Create the scratch pixmap used to pixelate fonts into doodles
	 */
	scratchPix = XCreatePixmap(myDpy, DEF_ROOT,
		Swidth, Sheight, XDefaultDepth(myDpy, XDefaultScreen(myDpy)));

	/*
	 * create the arrows to point to the selected row and column
	 * of the number array.  The nested for loops create pointer
	 * trinagles based on the width and height of the current font.
	 */
	row_arrow = XCreatePixmap(myDpy, DEF_ROOT, Swidth, (Sheight / 2),
			DEF_DEPTH);
	col_arrow = XCreatePixmap(myDpy, DEF_ROOT, Swidth, (Sheight / 2),
			DEF_DEPTH);
	for (y = 0; y < (Sheight / 2); y++)
	{
		cnt = (Swidth / 2) - ((y * (Swidth / 2)) / ((Sheight / 2) - 1));
		for (x = 0; x < Swidth; x++)
		{
			if ((x < cnt)||((Swidth - x) <= cnt))
			{
				XDrawPoint(myDpy, col_arrow, invtextGC, x, y);
			}
			else
			{
				XDrawPoint(myDpy, col_arrow, textGC, x, y);
			}
		}
	}
	for (x = 0; x < Swidth; x++)
	{
		cnt = (Sheight / 4) - ((x * (Sheight / 4)) / (Swidth - 1));
		for (y = 0; y < (Sheight / 2); y++)
		{
			if ((y < cnt)||(((Sheight / 2) - y) <= cnt))
			{
				XDrawPoint(myDpy, row_arrow, invtextGC, x, y);
			}
			else
			{
				XDrawPoint(myDpy, row_arrow, textGC, x, y);
			}
		}
	}

	InitPal();
}


void
SetButton(w)
	Widget w;
{
	Cardinal i;
	Arg argList[5];

	i = 0;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_IN); i++;
	XtSetValues(w, argList, i);
}


void
UnsetButton(w)
	Widget w;
{
	Cardinal i;
	Arg argList[5];

	i = 0;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_OUT); i++;
	XtSetValues(w, argList, i);
}


void
ToggleUIMode(V, mode)
	View *V;
	int mode;
{

	switch (mode)
	{
		case LINESEL:
		case XLINESEL:
		case YLINESEL:
			if (V->Mode == mode)
			{
				if (V->lineSelect)
				{
					RubberLineSelect(V, V->drawArea, 0);
					V->lineSelect = False;
				}
			}
			SetPointer(V->drawArea, XC_right_ptr);
			break;
		case POINTSEL:
			if (V->Mode == mode)
			{
				if (V->pointSelect)
				{
					if ((V->type == V_RASTER)||
						(V->type == V_WHITEBOARD))
					{
						RubberPoint(V, V->drawArea, 0);
						if ((V->next != NULL)&&
						    (V->next->type == V_SHEET))
						{
						    UnSelect(V->next, POINTSEL);
						    V->next->pointSelect= False;
						}
					}
					else
					{
						UnSelect(V, POINTSEL);
						if ((V->next != NULL)&&
						  ((V->next->type == V_RASTER)||
						  (V->next->type == V_WHITEBOARD)))
						{
						    RubberPoint(V->next,
							V->next->drawArea, 0);
						    V->next->pointSelect= False;
						}
					}
					V->pointSelect = False;
				}
			}
			SetPointer(V->drawArea, XC_right_ptr);
			break;
		case GLOBALPOINT:
			SetPointer(V->drawArea, XC_right_ptr);
			break;
		case POLYVIEW:
			if (V->Mode == mode)
			{
				SetPointer(V->drawArea, XC_right_ptr);
			}
			else
			{
				SetPointer(V->drawArea, XC_fleur);
			}
			break;
		case AREASEL:
			if (V->Mode == mode)
			{
				if (V->areaSelect)
				{
					if ((V->type == V_RASTER)||
						(V->type == V_WHITEBOARD))
					{
						RubberSelect(V, V->drawArea);
						if ((V->next != NULL)&&
						    (V->next->type == V_SHEET))
						{
						    UnSelect(V->next, AREASEL);
						    V->next->areaSelect = False;
						}
					}
					else
					{
						UnSelect(V, AREASEL);
						if ((V->next != NULL)&&
						  ((V->next->type == V_RASTER)||
						  (V->next->type == V_WHITEBOARD)))
						{
						    RubberSelect(V->next,
							V->next->drawArea);
						    V->next->areaSelect = False;
						}
					}
					V->areaSelect = False;
				}
			}
			SetPointer(V->drawArea, XC_right_ptr);
			break;
		case LINE:
		case ARROW:
		case OVAL:
		case BOX:
		case FREEHAND:
			if (V->Mode == mode)
			{
				Arg argList[30];
				Cardinal i;

				if (V->type == V_TEXT)
				{
					i = 0;
					XtSetArg(argList[i],
						XmNselectThreshold, 5);
					i++;
					XtSetValues(V->drawArea, argList, i);
				}
				SetPointer(V->drawArea, XC_right_ptr);
			}
			else
			{
				Arg argList[30];
				Cardinal i;

				if (V->type == V_TEXT)
				{
					i = 0;
					XtSetArg(argList[i],
						XmNselectThreshold, 5000);
					i++;
					XtSetValues(V->drawArea, argList, i);
				}
				SetPointer(V->drawArea, XC_pencil);
			}
			break;
		case TEXT:
			if ((V->Mode == mode)||(V->Mode == TEXTINSERT))
			{
				Arg argList[30];
				Cardinal i;

				if (V->type == V_TEXT)
				{
					i = 0;
					XtSetArg(argList[i],
						XmNmaxLength, MAXINT);
					i++;
					XtSetArg(argList[i],
						XmNverifyBell, True);
					i++;
					XtSetArg(argList[i],
						XmNselectThreshold, 5);
					i++;
					XtSetValues(V->drawArea, argList, i);
				}
				SetPointer(V->drawArea, XC_right_ptr);
			}
			else
			{
				Arg argList[30];
				Cardinal i;

				if (V->type == V_TEXT)
				{
					i = 0;
					XtSetArg(argList[i],
						XmNmaxLength, 0);
					i++;
					XtSetArg(argList[i],
						XmNverifyBell, False);
					i++;
					XtSetArg(argList[i],
						XmNselectThreshold, 5000);
					i++;
					XtSetValues(V->drawArea, argList, i);
				}
				SetPointer(V->drawArea, XC_xterm);
			}
			break;
		case ERASE:
			if (V->Mode == mode)
			{
				Arg argList[30];
				Cardinal i;

				if (V->type == V_TEXT)
				{
					i = 0;
					XtSetArg(argList[i],
						XmNselectThreshold, 5);
					i++;
					XtSetValues(V->drawArea, argList, i);
				}
				SetPointer(V->drawArea, XC_right_ptr);
			}
			else
			{
				Arg argList[30];
				Cardinal i;

				if (V->type == V_TEXT)
				{
					i = 0;
					XtSetArg(argList[i],
						XmNselectThreshold, 5000);
					i++;
					XtSetValues(V->drawArea, argList, i);
				}
				SetPointer(V->drawArea, XC_icon);
			}
			break;
		case ERASEBLOCK:
			if (V->Mode == mode)
			{
				Arg argList[30];
				Cardinal i;

				if (V->type == V_TEXT)
				{
					i = 0;
					XtSetArg(argList[i],
						XmNselectThreshold, 5);
					i++;
					XtSetValues(V->drawArea, argList, i);
				}
				SetPointer(V->drawArea, XC_right_ptr);
			}
			else
			{
				Arg argList[30];
				Cardinal i;

				if (V->type == V_TEXT)
				{
					i = 0;
					XtSetArg(argList[i],
						XmNselectThreshold, 5000);
					i++;
					XtSetValues(V->drawArea, argList, i);
				}
				SetPointer(V->drawArea, XC_sizing);
			}
			break;
		/*
		 * Note:  These two modes are one use only modes, they
		 * do not toggle.
		 */
		case PASTE:
		case PASTENOBACK:
			if ((V->Mode != PASTE)&&(V->Mode != PASTENOBACK))
			{
				Arg argList[30];
				Cardinal i;

				if (V->type == V_TEXT)
				{
					i = 0;
					XtSetArg(argList[i],
						XmNselectThreshold, 5000);
					i++;
					XtSetValues(V->drawArea, argList, i);
				}
				SetPointer(V->drawArea, XC_dotbox);
				/*
				 * The Motif Text Widget is so evil that if
				 * we don't force a redraw here, it will save
				 * up a redraw to be done on the next button
				 * press, which mucks up the paste
				 */
				XClearArea(myDpy, XtWindow(V->drawArea),
					0, 0, 1, 1, True);
			}
			break;
		default:
			break;
	};
}


void
SetMode(w, V, mode)
	Widget w;
	View *V;
	int mode;
{

	if (V->Mode == TEXTINSERT)
	{
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}

	ToggleUIMode(V, mode);

	switch (mode)
	{
		case LINESEL:
		case XLINESEL:
		case YLINESEL:
			if (V->lastToggle != NULL)
			{
				UnsetButton(V->lastToggle);
			}
			if (V->Mode == mode)
			{
				V->Mode = NONE;
			}
			else
			{
				if (V->lastToggle != NULL)
				{
					XmToggleButtonGadgetSetState(
						V->lastToggle, False, False);
				}
				V->lastToggle = w;
				if (w != NULL)
				{
					SetButton(w);
				}

				V->Mode = mode;
			}
			break;
		case POINTSEL:
			if (V->lastToggle != NULL)
			{
				UnsetButton(V->lastToggle);
			}
			if (V->Mode == mode)
			{
				V->Mode = NONE;
			}
			else
			{
				if (V->lastToggle != NULL)
				{
					XmToggleButtonGadgetSetState(
						V->lastToggle, False, False);
				}
				V->lastToggle = w;
				if (w != NULL)
				{
					SetButton(w);
				}

				V->Mode = mode;
			}
			break;
		case GLOBALPOINT:
			if (V->Mode == mode)
			{
				V->Mode = NONE;
			}
			else
			{
				if (V->lastToggle != NULL)
				{
					XmToggleButtonGadgetSetState(
						V->lastToggle, False, False);
				}
				V->lastToggle = w;

				V->Mode = mode;
			}
			break;
		case POLYVIEW:
			if (V->Mode == mode)
			{
				V->Mode = NONE;
			}
			else
			{
				if (V->lastToggle != NULL)
				{
					XmToggleButtonGadgetSetState(
						V->lastToggle, False, False);
				}
				V->lastToggle = w;

				V->Mode = mode;
			}
			break;
		case AREASEL:
			if (V->lastToggle != NULL)
			{
				UnsetButton(V->lastToggle);
			}
			if (V->Mode == mode)
			{
				V->Mode = NONE;
			}
			else
			{
				if (V->lastToggle != NULL)
				{
					XmToggleButtonGadgetSetState(
						V->lastToggle, False, False);
				}
				V->lastToggle = w;
				if (w != NULL)
				{
					SetButton(w);
				}

				V->Mode = mode;
			}
			break;
		case LINE:
		case ARROW:
		case OVAL:
		case BOX:
		case FREEHAND:
			if (V->lastToggle != NULL)
			{
				UnsetButton(V->lastToggle);
			}
			if (V->Mode == mode)
			{
				V->Mode = NONE;
			}
			else
			{
				if (V->lastToggle != NULL)
				{
					XmToggleButtonGadgetSetState(
						V->lastToggle, False, False);
				}
				V->lastToggle = w;
				if (w != NULL)
				{
					SetButton(w);
				}

				V->Mode = mode;
			}
			break;
		case TEXT:
			if (V->lastToggle != NULL)
			{
				UnsetButton(V->lastToggle);
			}
			if ((V->Mode == mode)||(V->Mode == TEXTINSERT))
			{
				V->Mode = NONE;
			}
			else
			{
				if (V->lastToggle != NULL)
				{
					XmToggleButtonGadgetSetState(
						V->lastToggle, False, False);
				}
				V->lastToggle = w;
				if (w != NULL)
				{
					SetButton(w);
				}

				V->Mode = mode;
			}
			break;
		case ERASE:
			if (V->lastToggle != NULL)
			{
				UnsetButton(V->lastToggle);
			}
			if (V->Mode == mode)
			{
				V->Mode = NONE;
			}
			else
			{
				if (V->lastToggle != NULL)
				{
					XmToggleButtonGadgetSetState(
						V->lastToggle, False, False);
				}
				V->lastToggle = w;
				if (w != NULL)
				{
					SetButton(w);
				}

				V->Mode = mode;
			}
			break;
		case ERASEBLOCK:
			if (V->lastToggle != NULL)
			{
				UnsetButton(V->lastToggle);
			}
			if (V->Mode == mode)
			{
				V->Mode = NONE;
			}
			else
			{
				if (V->lastToggle != NULL)
				{
					XmToggleButtonGadgetSetState(
						V->lastToggle, False, False);
				}
				V->lastToggle = w;
				if (w != NULL)
				{
					SetButton(w);
				}

				V->Mode = mode;
			}
			break;
		/*
		 * Note:  These two modes are one use only modes, they
		 * do not toggle.
		 */
		case PASTE:
		case PASTENOBACK:
			if ((V->Mode != PASTE)&&(V->Mode != PASTENOBACK))
			{
				V->lastMode = V->Mode;
				V->Mode = mode;
			}
			break;
		default:
			if (V->Mode == mode)
			{
				V->Mode = NONE;
			}
			else
			{
				V->Mode = mode;
			}
			break;
	};
	if (V->Mode == NONE)
	{
		V->lastToggle = NULL;
	}
}


void
UnsetMode(V, mode)
	View *V;
	int mode;
{
	switch (mode)
	{
		case PASTE:
		case PASTENOBACK:
			if ((V->lastMode == PASTE)||
			    (V->lastMode == PASTENOBACK))
			{
				V->lastMode = NONE;
			}
			if (V->lastMode == TEXTINSERT)
			{
				V->lastMode = TEXT;
			}
			if (V->lastMode == NONE)
			{
				if (V->type == V_TEXT)
				{
					Arg argList[5];
					Cardinal i;

					i = 0;
					XtSetArg(argList[i],
						XmNselectThreshold, 5);
					i++;
					XtSetValues(V->drawArea, argList, i);
				}
				SetPointer(V->drawArea, XC_right_ptr);
			}
			else
			{
				V->Mode = NONE;
				ToggleUIMode(V, V->lastMode);
			}
			V->Mode = V->lastMode;
			V->lastMode = NONE;
			break;
		default:
			V->Mode = NONE;
			V->lastMode = NONE;
			break;
	};
}


void
InitPalEdit(rootW)
	Widget rootW;
{
	Arg argList[30];
	Cardinal i;
	Widget palshell;

	/*
	 * Set some necessary resources on the top level shell widget.
	 */
	i = 0;
	XtSetArg(argList[i], XtNtitle, "Palette Editor"); i++;
	XtSetArg(argList[i], XmNallowShellResize, True); i++;
        XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        XtSetArg(argList[i], XmNdeleteResponse, XmUNMAP); i++;
	palshell = XtCreatePopupShell("palshell", topLevelShellWidgetClass,
					rootW, argList, i);
	PalSetup(palshell);
	PalTop = palshell;

	RegisterPopup(palshell, "Palette Editor", False, NULL);
}


void
WhiteboardMap(w, client_data, call_data)
        Widget w;
        caddr_t client_data;
        caddr_t call_data;
{
	View *V = (View *)client_data;
	Palette *pal;

	if (!XtIsRealized(V->shell))
		XtRealizeWidget(V->shell);
	XtRemoveCallback(V->shell, XtNpopupCallback, WhiteboardMap,
			 client_data);

	if (V->isUp == False)
		V->isUp = True;

/* DDT
		V->cmap = DefaultColormap(myDpy, XDefaultScreen(myDpy));
*/
	pal = PaletteSearchByName("Whiteboard");
	if (!pal)
		pal = PaletteFirst();
	if (pal)  {
		SetPalette(V,pal);
		}

	CBMakeCurrentObject((Widget)0, V, NULL);
/*
		V->cData->doodleImage = XGetImage(myDpy, V->doodlePix, 0, 0,
					V->cData->xdim, V->cData->ydim,
					AllPlanes, ZPixmap); */
	return;
}




main(argc,argv)
int	argc;
char	**argv;
{
char	*dtmInPort = (char *) 0;
char	*dtmOutPort = (char *) 0;
int	rargc;
char	**rargv;
Cdata *d;
Widget shell;
int 	numArgs;

	rargc = argc;
	rargv = argv;

#ifndef DEBUG
        /* turn off sig trap */
        signal(SIGBUS,FatalProblem);
        signal(SIGSEGV,FatalProblem);
        signal(SIGILL,FatalProblem);
#endif
	signal(SIGINT, CleanExit);
	signal(SIGTERM, CleanExit);
	signal(SIGHUP, CleanExit);

	XtToolkitInitialize();
	app = XtCreateApplicationContext();
	XtAppSetFallbackResources(app, Fallbacks);
	myDpy = XtOpenDisplay (app, NULL, "collage", "Collage",
			       Options, XtNumber(Options),
#if XtSpecificationRelease > 4
			       &argc,
#else
			       (Cardinal *)&argc,
#endif
			       argv);
	if (myDpy == NULL)
	{
		fprintf(stderr, "Cannot open display!\n");
		exit(1);
	}

	fileLoadList = ListCreate();

	numArgs = argc - 1;
	while (--argc > 0) {
		argv++;
		if ((!strcmp(*argv,"-DTMIN")) || (!strcmp(*argv,"-DTM") ||
			(!strcmp(*argv,"-dtmin")))) {
			argc--;argv++;
			if (argc--)
				dtmInPort = *(argv++);
			}


		if ((argc > 0) && 
			((!strcmp(*argv,"-DTMOUT"))
			|| (!(strcmp(*argv,"-DTMCOL")))
			|| (!(strcmp(*argv,"-dtmout"))))) {
			argc--;argv++;
			if (argc) {
				dtmOutPort = *(argv++);
				argc--;
				}
			}

		if ((argc > 0) && (!strcmp(*argv,"-load"))) {
			argc--;argv++;
			while(argc && 
				(!((!strcmp(*argv,"-DTMIN")) ||
				 (!strcmp(*argv,"-DTMOUT")) ||
				 (!strcmp(*argv,"-DTM")) ||
				 (!strcmp(*argv,"-DTMCOL")) ||
				 (!strcmp(*argv,"-dtmin")) ||
				 (!strcmp(*argv,"-dtmout")) ))) {
				ListAddEntry(fileLoadList,*argv);
				printf("just added %s\n",*argv);
				argc--;argv++;
				}
			}
		if (argc == numArgs) {
			/* no matches */
			fprintf(stderr,"Usage: %s [-DTMIN :port] [-DTMOUT host:port] [-load file [ file]]\n",*rargv);
			exit(0);
			}
		}

/*	if (!dtmInPort) {
		dtmInPort = ":0";
		} */

#ifdef DEBUG
	printf("main(): dtmInPort=\"%s\"\n",dtmInPort);
	printf("main(): dtmOutPort=\"%s\"\n",dtmOutPort);
#endif

	if (!InitCdata())
		exit(0);

/*
	if (!(d = (Cdata *) MALLOC(sizeof(Cdata))))
	{
		fprintf(stderr,"Out of Memory\n");
		exit(1);
	}
	d->type = D_FLOAT;
	d->xdim = 300;
	d->ydim = 300;
	d->xmag = 1;
	d->ymag = 1;
	d->image = (XImage *) 0;
	d->doodleImage = (XImage *) 0;
	if (!(d->name = (char *) MALLOC(strlen("Whiteboard")+1)))
	{
		fprintf(stderr, "Can't allocate memory for Whiteboard name\n");
		exit(1);
	}
	strcpy(d->name, "Whiteboard");
	d->buff = NULL;
	d->fbuff = NULL;
	d->hasPalette = False;
	d->pal = NULL;
*/

	if (!InitializeUI(rargc,rargv))  {
		exit(0);
		}

	InitUIMesg(rootWidget);

/*
	baseView = InitView(rootWidget, d, True);
	XtAddEventHandler(baseView->shell, StructureNotifyMask, 0,
		WhiteboardMap, (caddr_t)baseView);
	RegisterPopup(baseView->shell, "Whiteboard", False, baseView);
	CdataAddEntry(baseView->cData);
	currentObject = baseView->cData;
	WhiteTop = baseView->shell;
*/

	ContinueInitialization();
	NetInit(UserID);
	InitNetTimeOut(rootWidget);

	NewConnect(dtmInPort, dtmOutPort);
	SetServerLocation(dtmOutPort);

	NetRegisterModule("RasView", NETSDS, GotSds, (caddr_t)1,
		GotSds, (caddr_t)0, GotDelete, (caddr_t)NULL);
	NetRegisterModule("RasView", NETRIS8, GotRis, (caddr_t)1,
		GotRis, (caddr_t)0, GotDelete, (caddr_t)NULL);
	NetRegisterModule("RasView", NETPAL, GotPal, (caddr_t)1,
		GotPal, (caddr_t)0, GotDelete, (caddr_t)NULL);
	NetRegisterModule("RasView", NETCOL, GotCol, (caddr_t)1,
		GotCol, (caddr_t)0, GotDelete, (caddr_t)NULL);
	NetRegisterModule("RasView", NETDOL, GotDol, (caddr_t)1,
		GotDol, (caddr_t)0, GotDelete, (caddr_t)NULL);
	NetRegisterModule("RasView", NETDTM, GotDtmOrSrv, (caddr_t)1,
		GotDtmOrSrv, (caddr_t)0, GotDelete, (caddr_t)NULL);
	NetRegisterModule("RasView", NETSRV, GotDtmOrSrv, (caddr_t)2,
		GotDtmOrSrv, (caddr_t)0, GotDelete, (caddr_t)NULL);
/*
	NetRegisterModule("RasView", NETTXT, GotTxt, (caddr_t)1,
		GotTxt, (caddr_t)0, GotDelete, (caddr_t)NULL);
*/

	PrintInit(rootWidget);

	LoadInit(rootWidget);

	AnimationSetup(rootWidget, app);

	InitPalEdit(rootWidget);
	TextSetup(rootWidget);
/* EJB
	shell = TextSetup(rootWidget);
	RegisterPopup(shell, "Text Window", False, NULL);
*/
#ifdef MAC_COMPAT
	StartText(rootWidget);
	StartWhiteboard();
#endif /* MAC_COMPAT */

	ProfileSetup(rootWidget);
	HistSetup(rootWidget);

	ContourInit(rootWidget);

	InitChatBox(rootWidget);

/*
	if (ListHead(fileLoadList)) {
		LoadArgFiles(fileLoadList);
		}
*/

	PollTimer = XtAppAddTimeOut(app, 100, CheckForInput, (caddr_t)True);
	XtAppAddTimeOut(app, 5000, ReClock, (caddr_t)True);
{
    XEvent event;

    for (;;) {
        XtAppNextEvent(app, &event);
        XtDispatchEvent(&event);
    }
}
/*
	XtAppMainLoop(app);
*/

}


void
CBDone(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	View *V = (View *)client_data;

	XtPopdown(V->shell);
	V->isUp = False;
}


static void
RealExit()
{
	AnimationExit();
	TextExit();
/*
	XtDestroyWidget(WhiteTop);
*/
	if (PalTop) XtDestroyWidget(PalTop);
	if (rootWidget) XtDestroyWidget(rootWidget);
	exit(0);
}


void CBExit(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	if (NetSendDisconnect(outP, RealExit, RealExit))
	{
		RealExit();
	}
	while(1) NetTryResend();
}


void
BreakOut(sig, code, scp, addr)
	int     sig, code;
	struct  sigcontext *scp;
	char    *addr;
{
	if (NetSendDisconnect(outP, RealExit, RealExit))
	{
		RealExit();
	}
	while(1) NetTryResend();
}


static void
DrawAreaNewSize(V, width, height)
	View *V;
	int width, height;
{
	Pixmap tmppix;
	Cardinal i;
	Arg argList[10];
	Pixel bg;

	i = 0;
	XtSetArg(argList[i], XmNbackground, &bg); i++;
	XtGetValues(V->drawArea, argList, i);
	XSetForeground(myDpy, drawAreaGC, bg);

	tmppix = XCreatePixmap(myDpy, XtWindow(V->drawArea), width, height,
		XDefaultDepth(myDpy, XDefaultScreen(myDpy)));
	XFillRectangle(myDpy, tmppix, drawAreaGC, 0, 0, width, height);
	if (V->doodlePix != NULL)
	{
		XFreePixmap(myDpy, V->doodlePix);
		V->doodlePix = (Pixmap)NULL;
	}
	V->doodlePix = tmppix;
}

static void
CBDrawAreaExposed(w,client_data,call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
/*EJB
	XEvent event;

	while (XCheckWindowEvent(myDpy,XtWindow(w),ExposureMask,&event));
	if (currentObject) {
		XPutImage(myDpy,XtWindow(drawArea),drawAreaGC,
			currentObject->image,0,0,0,0,
			currentObject->xdim,currentObject->ydim);
		}
*/
}

int
InitializeUI(argc, argv)
	unsigned int	argc;
	char	*argv[];
{
	int cnt;
	Arg argList[10];
	Cardinal i = 0;
	Pixel fg, bg;
	char tlab[256];
	Visual *vis;
	XVisualInfo vinfo;
	int n;
	XVisualInfo *visList;
	int visID;
	Boolean ok;
	int x;


	sprintf(tlab, "%s (Version 1.2.1)", argv[0]);

	rootWidget = XtAppCreateShell("collage", "Collage",
			applicationShellWidgetClass, myDpy, NULL, 0);
/*DDT*/
	vis = XDefaultVisualOfScreen(XtScreen(rootWidget));
	vinfo.depth = 8;
	vinfo.class = PseudoColor;
	visList = XGetVisualInfo(myDpy,VisualDepthMask|VisualClassMask,
			&vinfo,&n);
	if (!n) {
		fprintf(stderr,"\nNCSA Collage 1.2.1 requires an 8 bit Pseudo color visual.\n");
		return(0);
		}
	visID = XVisualIDFromVisual(vis);
	ok = FALSE;
	for (x=0; x < n; x++) {
		if (visList[x].visualid == visID) {
			ok = TRUE;
			}
		}
	if (!ok) {
		fprintf(stderr,"\nNCSA Collage 1.2.1 requires an 8 bit Pseudo color visual.\n");
		return(0);
		}

/*****/

	XtGetApplicationResources(rootWidget, (XtPointer)&res_gotten, res_list,
				XtNumber(res_list), NULL, 0);

	if (!res_gotten.debug) {
        /* nothing user can do... only developer */
        /* so don't print it */
		XtSetWarningMsgHandler(DevNull);
		XtSetWarningHandler(DevNull);
	/*	commented out because this is a beta release */
	}

#ifdef DEBUG
	fprintf(stderr, "res_gotten.async = %d\n", res_gotten.async);
#endif
	NetSetASync(res_gotten.async);

	if ((res_gotten.id != NULL)&&(res_gotten.id[0] != '\0'))
	{
		UserID = (char *)MALLOC(strlen(res_gotten.id) + 1);
		strcpy(UserID, res_gotten.id);
	}
	else
	{
		char host[65];
		char id[256];
		char name[256];
		struct passwd *p;
		char *ptr;

		gethostname(host, 64);
		if (p = getpwuid(getuid()))
		{
			strncpy(name,p->pw_gecos,256);
			name[255] = '\0';
			/* sometimes passwd name field has alot of chfn garbage
			   in it. Don't include this */
			if (ptr = strchr(name,',')) {
				*ptr = '\0';
				}
			else {
				name[25]='\0';
				}
			sprintf(id, "%s@%s", name, host);
		}
		else
		{
			sprintf(id, "%s@%s", "me", host);
		}
		UserID = (char *)MALLOC(strlen(id) + 1);
		strcpy(UserID, id);
	}

	/*
	 * Set some necessary resources on the top level shell widget.
	 */
	i = 0;
        XtSetArg(argList[i], XtNtitle, tlab); i++;
        XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
	XtSetArg(argList[i], XmNshadowThickness, 0); i++;
	XtSetValues(rootWidget, argList, i);

	InitControl(rootWidget);

        XtRealizeWidget(rootWidget);

	if (ListHead(fileLoadList) == NULL)
        	Intro(rootWidget);
	XFlush(myDpy);

	/*
	 * Initialize the Data In and Data Out pixmaps
	 */
	i = 0;
	XtSetArg(argList[i], XtNforeground, &fg); i++;
	XtSetArg(argList[i], XtNbackground, &bg); i++;
	XtGetValues(netButton, argList, i);
	DataIn = XCreatePixmapFromBitmapData(myDpy, DEF_ROOT,
		In_bits, In_width, In_height, fg, bg, DEF_DEPTH);
	DataOut = XCreatePixmapFromBitmapData(myDpy, DEF_ROOT,
		Out_bits, Out_width, Out_height, fg, bg, DEF_DEPTH);

	/*
	 * Initialize font information
	 */
	drawFont = res_gotten.font;
	fontTable = (charRec *)MALLOC(sizeof(charRec) *
				(drawFont->max_char_or_byte2 + 1));
	for (cnt = 0; cnt <= drawFont->max_char_or_byte2; cnt++)
	{
		fontTable[cnt].length = -1;
	}
	Swidth = drawFont->max_bounds.width;;
	Sheight = drawFont->max_bounds.ascent + drawFont->max_bounds.descent;;
	Sascent = drawFont->max_bounds.ascent;

	SdrawWidth = res_gotten.drawFont->max_bounds.width;;
	SdrawHeight = res_gotten.drawFont->max_bounds.ascent 
			+ res_gotten.drawFont->max_bounds.descent;;
	SdrawAscent = res_gotten.drawFont->max_bounds.ascent;

	/*
	 * Initialize the default colormap values
	 */
	InitDefaultColors();

	return(1);
}


void
CBMakeCurrentObject(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V;
	Cdata *d;
	Visual *visual;
	int owidth, oheight;
	XWindowAttributes attr;

	V = (View *) client_data;
	d = V->cData;

	if (V->type == V_WHITEBOARD)
	{
		owidth = d->xdim;
		oheight = d->ydim;
		XGetWindowAttributes(myDpy,
				XtWindow(XtParent(V->drawArea)), &attr);
		d->xdim = attr.width;
		d->ydim = attr.height;
	}

	XGetWindowAttributes(myDpy, XtWindow(V->drawArea), &attr);
	if ((attr.width != d->xdim)||(attr.height != d->ydim))
	{
		Arg argList[2];
		Cardinal i = 0;
		XtSetArg(argList[i], XtNwidth, d->xdim); i++;
		XtSetArg(argList[i], XtNheight, d->ydim); i++;
		XtSetValues(V->drawArea, argList, i);
	}

	visual = XDefaultVisual(myDpy,XDefaultScreen(myDpy));

	if (V->drawPix != NULL)
	{
		XFreePixmap(myDpy, V->drawPix);
		V->drawPix = (Pixmap)NULL;
	}
	if (V->type == V_WHITEBOARD)
	{
		XSetWindowBackgroundPixmap(myDpy, XtWindow(V->drawArea),
			ParentRelative);
	}
	else
	{
		V->drawPix = XCreatePixmap(myDpy, XtWindow(V->drawArea),
			d->xdim, d->ydim,
			XDefaultDepth(myDpy, XDefaultScreen(myDpy)));
		XPutImage(myDpy, V->drawPix, drawAreaGC, d->image, 0, 0,
				0, 0, d->xdim, d->ydim);
		XSetWindowBackgroundPixmap(myDpy, XtWindow(V->drawArea),
			V->drawPix);
	}
	DrawAreaNewSize(V, d->xdim, d->ydim);
	if (V->drawPix != NULL)
	{
		XCopyArea(myDpy, V->drawPix, V->doodlePix, drawAreaGC,
				0, 0, d->xdim, d->ydim, 0, 0);
	}
	if (V->type == V_WHITEBOARD)
	{
		unsigned int swidth, sheight;

		if (d->xdim < owidth)
			swidth = d->xdim;
		else
			swidth = owidth;
		if (d->ydim < oheight)
			sheight = d->ydim;
		else
			sheight = oheight;
		if (d->doodleImage)
		{
			XPutImage(myDpy, V->doodlePix, drawAreaGC,
					d->doodleImage,
					0, 0, 0, 0, swidth, swidth);
			XDestroyImage(d->doodleImage);
		}
		d->doodleImage = XGetImage(myDpy, V->doodlePix, 0, 0,
				d->xdim, d->ydim, AllPlanes, ZPixmap);
	}
	else if (d->doodleImage)
	{
		XPutImage(myDpy, V->doodlePix, drawAreaGC,
			d->doodleImage, 0, 0, 0, 0, d->xdim, d->ydim);
	}
	XClearArea(myDpy, XtWindow(V->drawArea), 0, 0, 0, 0, True);

	/* currentObject = d; */


	if (d->hasPalette)
	{
		SetPalette(V, d->pal);
	}

} /* CBMakeCurrentObject */



void
NewCdata(V) 
	View	*V;
{
	Cdata	*d;
	Visual *visual;
	Arg	argList[10];
	Cardinal i;
	Widget b;
	XmString label;

	d = V->cData;

#ifdef DEBUG
	printf("Just got and now displaying new data \n");
	printf("dimensions = %d,%d\n",d->xdim,d->ydim);
#endif

	visual = XDefaultVisual(myDpy, XDefaultScreen(myDpy));

	if ((! d->image)&&(V->type != V_WHITEBOARD))
	{
		d->image = XCreateImage(myDpy, visual, 8, ZPixmap, 0,
			d->buff, d->xdim, d->ydim, 8, d->xdim);
	}

	CBMakeCurrentObject((Widget)0, V, NULL);

	if (! d->doodleImage)
	{
		d->doodleImage = XGetImage(myDpy, V->doodlePix, 0, 0,
				d->xdim, d->ydim, AllPlanes, ZPixmap);
	}

	if (!CdataSearchByName(d->name))
	{
		CdataAddEntry(d);
		RegisterData(d);
	}
	if (! V->isUp)
		XtPopup(V->shell, XtGrabNone);
}


void
CBRasterResize(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	View *V = (View *)client_data;
	Cdata *d;
	XWindowAttributes attr;
	Pixmap tmppix;
	Cardinal i;
	Arg argList[10];
	Pixel bg;
	Dimension shadow, border_width;

	if (event->type != ConfigureNotify)
	{
		return;
	}

	d = V->cData;

	if (d->V->type != V_WHITEBOARD)
	{
		return;
	}

	i = 0;
	XtSetArg(argList[i], XmNshadowThickness, &shadow); i++;
	XtGetValues(XtParent(V->drawArea), argList, i);

	i = 0;
	XtSetArg(argList[i], XmNborderWidth, &border_width); i++;
	XtGetValues(V->drawArea, argList, i);

	XGetWindowAttributes(myDpy, XtWindow(XtParent(V->drawArea)), &attr);

	i = 0;
	XtSetArg(argList[i], XmNwidth, (attr.width - (2 * shadow) -
					2 * border_width)); i++;
	XtSetArg(argList[i], XmNheight, (attr.height - (2 * shadow) -
					 2 * border_width)); i++;
	XtSetValues(V->drawArea, argList, i);

	i = 0;
	XtSetArg(argList[i], XmNbackground, &bg); i++;
	XtGetValues(V->drawArea, argList, i);
	XSetForeground(myDpy, drawAreaGC, bg);

	tmppix = XCreatePixmap(myDpy, XtWindow(V->drawArea),
		attr.width, attr.height,
		XDefaultDepth(myDpy, XDefaultScreen(myDpy)));
	XFillRectangle(myDpy, tmppix, drawAreaGC, 0, 0,
		attr.width, attr.height);

	if (V->doodlePix != NULL)
	{
		XFreePixmap(myDpy, V->doodlePix);
		V->doodlePix = (Pixmap)NULL;
	}
	V->doodlePix = tmppix;

	if (d->doodleImage)
	{
		XPutImage(myDpy, V->doodlePix, drawAreaGC,
				d->doodleImage,
				0, 0, 0, 0, d->xdim, d->ydim);
		XDestroyImage(d->doodleImage);
	}
	d->xdim = attr.width;
	d->ydim = attr.height;
	d->doodleImage = XGetImage(myDpy, V->doodlePix, 0, 0,
		d->xdim, d->ydim, AllPlanes, ZPixmap);

	XClearArea(myDpy, XtWindow(V->drawArea), 0, 0, 0, 0, True);
}

