%***************************************************************************
%  FILE = io.red				Wed Nov 16 20:13:59 EST 1988
% 
%  Procedures in this file:
% 
%  MKRDR SIMPRDR FORMRDR PARSELSQB CLEANSYM EQUALPARSE1 DISPF1
%  DISPF2 IPRP* IPROP* PRINTRDR RDRP RDR1 TESTWIDTH DNCASE
%  UPCASE DNNAME UPNAME MCLEAR
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);

GLOBAL '(PARSEFLAG!*  SYMLST!*);
GLOBAL '(!*NERO !*NAT YCOORD!* YMAX!* YMIN!* POSN!*);
FLUID '(READFLG!*);
READFLG!* := 'NIL;  % reader control flag (?)
PUT('![, 'STAT, 'PARSELSQB);

FLAG('(!]),'DELIM);

FLAG('(!]),'NODEL);   % what does this mean anyway?

PUT ('FN, 'SIMPFN, 'MKRDR);  % for functional objects

% mkrdr is the simplification routine for all indexed objects.
% it builds the ('rdr name (index) (symlst)) form of the object.
% note that indexed objects are flagged 'full, so that mkrdr gets
% the object name too (except for 'fn above, which is a function 
% caller).

SYMBOLIC PROCEDURE MKRDR (U);
BEGIN SCALAR TNSR, INDEX, LEX1, SYMLST;
  TNSR := MYCAR (U);
  IF NOT IDP (TNSR) THEN <<   % is from fn, i.e its a function call
    TNSR := MYCAR (SIMP (TNSR));  % eval algebraic function.
    CLEARTMP ();		% clean the trash
    IF NOT IDP (TNSR) THEN RETURN (TNSR . 1) % it may return 0
  >>;
  % because the parser insists that the first element of a list
  % be a name (i.e a valid function) one has to cheat to get the
  % signs of the symmetrization operations.
  SYMLST := SUBLIS ('((!*ONE . 1) (!*MONE . -1)), MYCDR (MYCADADR (U)));
  INDEX := MYCDDADR (U);
  IF MYCAR (INDEX) EQ 'NIL THEN INDEX := 'NIL
  ELSE IF MEMQ ('NIL, MAPCAR (INDH (INDEX), 'ATOM)) THEN
    MERROR (LIST ("non-atomic indice:", TNSR, INDEX), 'T, 'MKRDR)
  ELSE IF INDEXED (TNSR) AND NOT CHKINDEX (TNSR, INDEX) THEN <<
    MERROR (LIST ("subscript out of bounds:", TNSR), 'NIL, 'NIL);
    RETURN ('NIL . 1)
  >>;
  LEX1 := SYMI (LIST ('RDR, TNSR, INDEX, REVERSE (SYMLST)));
  IF LEX1 = 0 THEN RETURN ('NIL . 1);
  IF MYCAR (LEX1) EQ 'MINUS THEN
    LEX1 := LIST ('MINUS, SYMINDEX (SHIFT!* (MYCADR (LEX1), 'T)))
  ELSE LEX1 := SYMINDEX (SHIFT!* (LEX1, 'T));
  IF LEX1 = 0 THEN RETURN ('NIL . 1)
  ELSE RETURN (SIMP (LEX1));
END;

% simprdr is the simplification routine for rdr forms.
% it either returns unevaluated, or gets an object value if
% there is an integer index. Certain other types of index are
% also interpreted here i.e those for displaying the contents of
% an object.
% if READFLG!* is on, then things are still being parsed and we dont want
% to evaluate the object if that were possible (eg. integer index or scalar
% object

SYMBOLIC PROCEDURE SIMPRDR (U);
BEGIN SCALAR TNSR, INDEX, SYMLST, DISPF2, LEX;
  TNSR := MYCADR (U);      % break up the input list.
  INDEX := MYCADDR (U);
  SYMLST := MYCADDDR (U);
  IF MYCAR (U) EQ 'QRDR OR NOT INDEXED (TNSR) THEN  % noeval op
    RETURN (LIST ((FORMRDR (TNSR, INDEX, SYMLST) . 1) . 1) . 1)
  ELSE IF NOT INDEX THEN <<
    IF READFLG!* THEN RETURN (LIST ((FORMRDR (TNSR, INDEX, SYMLST) . 1) . 1) . 1);
    IF INDEXED (TNSR) EQ 'SCALAR THEN RETURN (READTNSR (TNSR, 'NIL))
    ELSE RETURN (MYCADR (AEVAL (DISPF1 (TNSR))))
  >>;
  IF (LENGTH (INDEX) = (LEX := MYCAR (GET (TNSR, 'INDICES))) + 1) AND
      NTH (INDEX, LEX + 1) EQ '? THEN <<    % display format 2 request
    INDEX := HEAD (INDEX, LEX);    % strip ? from index and
    DISPF2 := 'T                   % set flag for later action.
  >>;
  IF NOT (((LEX OR 0) + 1) = (MYCAR (FDERIV (INDEX)) OR ((LENGTH (INDEX)) + 1)))
    THEN MERROR (LIST ("index wrong length:", TNSR, INDEX), 'T, 'SIMPRDR)
  ELSE IF DISPF2 THEN RETURN (MYCADR (AEVAL (DISPF2 (TNSR, INDEX))))
  ELSE IF NOT INTINDEX (INDEX) OR READFLG!* THEN
% this causes the failure of implicit evals
%OR GET (TNSR, 'IMPLICIT) THEN  % unevaled form
    RETURN (LIST ((FORMRDR (TNSR, INDEX, SYMLST) . 1) . 1) . 1)
  ELSE IF NOT FREE1 (INDEX, '!*AT!*) THEN <<  
    MERROR (LIST ("no such offspring for", TNSR), 'NIL, 'SIMPRDR);
    RETURN ('NIL . 1)
  >> ELSE <<  % integer index, read and return value.
    IF DERIV (INDEX, '!#BR) AND NOT DERIV (INDEX, '!#DBR) THEN
	RETURN (SIMP!* (CNVRTDIF (TNSR, INDEX)));
    RETURN (READTNSR (TNSR, INDEX));
  >>;
END;

SYMBOLIC PROCEDURE FORMRDR (TNSR, INDEX, SYMLST);
<<
  IF SYMLST THEN LIST ('RDR, TNSR, INDEX, SYMLST);
  ELSE CAR (FKERN (LIST ('RDR, TNSR, INDEX)))
>>;

PARSEFLAG!* := 'NIL;  % global flag to tell parselsqb if it's top level
GLOBAL '(CURSYM!*);
% parselsqb is the parsing routine for object indices and symmetrization
% operations. i.e it collects up things between [].

SYMBOLIC PROCEDURE PARSELSQB;
BEGIN SCALAR LEX, LST, LOCALFLAG;
  IF NOT PARSEFLAG!* THEN <<	% this is the top level call
    PARSEFLAG!* := LOCALFLAG := 'T; % set local flag so we can tell below
    SYMLST!* := 'NIL		% clear the symmetrization list
  >>;
  LOOP: 	% collect the stuff between the brackets
    LEX := XREAD ('GROUP);
    IF ATOM (LEX) THEN <<  % its a regular indice
      IF GET (LEX, 'SHARE) THEN
        MERROR (LIST ("index cannot be shared:", LEX), 'T, 'PARSELSQB)
      ELSE LST := ACONC (LST, LEX)
      >>
    ELSE LST := APPEND (LST, LEX);  % returned by the symmetrization routines
    IF NOT (CURSYM!* EQ '!]) THEN GO TO LOOP;

  SCAN (); 
  IF LOCALFLAG THEN << % this is the top level call, we are collecting the index
    PARSEFLAG!* := 'NIL;     % clear the flag, an interrupt here can screw this
    LEX := 'FINDEX . ('SYMLST . SYMLST!*) . LST;  % set up the index and
    SYMLST!* := 'NIL; 				% clear the symetrization list.
		% NOTE: a name MUST appear as the car of the index, so integer
                % indexes might mess this up. Therefore, we place the name
		% 'FINDEX there to keep the parser happy.
    RETURN (LEX)
  >> ELSE <<    % we were collecting a symmetrization list
    LEX := CLEANSYM (LST);   % wipe out stuff between Bach brackets and shifts
    SYMLST!* := ('!*ONE . MYCAR (LEX)) . SYMLST!*; % must have a name in car, 
                                           % so we can't use 1 or -1 directly. 
    RETURN (MYCADR (LEX))
  >>;
END;

% cleansym takes a list containing Bach brackets, shift and deriv ops.
% and returns 2 lists: one with only the Bach brakets removed, the other
% with everything between Bach brackets removed, as well as all other
% operators.

SYMBOLIC PROCEDURE CLEANSYM (LIS);
BEGIN SCALAR LEX, LEX2, FLG;
  WHILE LIS DO <<
    IF MYCAR (LIS) EQ '!# THEN <<	% Bach bracket found.
      FLG := NOT FLG;		% toggle flag
      LIS := MYCDR (LIS)		% discard bracket
    >>
    ELSE IF MYCAR (FDERIV (LIS)) = 1 THEN <<  % deriv op
      LEX2 := MYCAR (LIS) . LEX2;              % pass onto index
      LIS := MYCDR (LIS)		% but not to symmetrization list.
    >> ELSE <<
      IF NOT FLG THEN LEX := INDH (MYCAR (LIS)) . LEX; %  add to symm list.
      LEX2 := MYCAR (LIS) . LEX2;		% and to index
      LIS := MYCDR (LIS)
    >>
  >>;
  RETURN (LIST (REVERSE (LEX), REVERSE (LEX2)));
END;

NEWTOK '((!= !=)  EQUALPARSE);  % define == operator

INFIX ==;      % will have lowest precedence in system

PUT ('EQUALPARSE, 'SIMPFN, 'EQUALPARSE1);

% equalparse is the routine that receives the right- and left-hand
% sides of an == operation and begins the evaluation process.
% it returns the value written if it is a scalar, or the indexed object
% that was writtten to.

SYMBOLIC PROCEDURE EQUALPARSE1 (U);
BEGIN SCALAR EX1, EX2, LEX, LEX1, READFLG!*;
  READFLG!* := 'T;  % indicates a read in progress, see RDR for use.
  IF ATOM (MYCAR (U)) THEN EX1 := MYCAR (U)  % scalar output expected
  ELSE EX1 := REVAL (MYCAR (U));     % otherwise its indexed, 
                                   % so get mkrdr to do its stuff.
  READFLG!* := 'NIL;
  EX2 := MYCADR (U);        % right-hand side of ==
  IF EX1 = 0 THEN RETURN ('NIL . 1)  % symmetry sez no way.
  ELSE IF NOT ATOM (EX1) AND MYCAR (EX1) EQ 'MINUS THEN <<
    EX1 := MYCADR (EX1);    % transfer symmetry sign from left to right sides
    EX2 := LIST ('MINUS, EX2)
  >>; 
  IF IDP (EX1) THEN       % evaluate scalar, i.e no index.
    RETURN (EVALTNSR (EX1, 'NIL, EX2))
%  ELSE IF NOT IDP (MYCADR (EX1)) THEN  % not a valid object (e.g might be a sum)
  ELSE IF NOT CHECKTYPE (EX1, 'RDR) THEN  % not a valid object (e.g might be a sum)
    MERROR (LIST ("cannnot assign to:", EX1), 'TRUE, 'EQUALPARSE1)
  ELSE IF INTINDEX (MYCADDR (EX1)) THEN <<   % single element to be written
    IF DERIV (MYCADDR (EX1), 'NIL) THEN
        MERROR (LIST ("cannnot assign to:", EX1), 'TRUE, 'EQUALPARSE1);
    EVALTNSR1 (MYCADR (EX1), MYCADDR (EX1), REVAL (EX2), 'NIL);
    RETURN (READTNSR (MYCADR (EX1), MYCADDR (EX1)))  % reread to find what went in.
    >>
  ELSE IF NOT INDEXED (MYCADR (EX1)) AND NOT MYCADDR (EX1) THEN <<
    MKSCALAR!* (LIST (MYCADR (EX1)));	% make the scalar object automatically 
    RETURN (EVALTNSR (MYCADR (EX1), 'NIL, EX2))
  >>
  ELSE RETURN (EVALTNSR (MYCADR (EX1), MYCADDR (EX1), EX2)); % a whole object
END;

GLOBAL '(!*IPROP);

% dispf1 displays the contents of an indexed object in the 'first'
% format, i.e it prints out the explicit elements.

SYMBOLIC PROCEDURE DISPF1 (TNSR);
BEGIN SCALAR LEX;
  IPROP!* (TNSR, NOT !*IPROP);   % print the properties
  LEX := GET (TNSR, 'TVALUE);
  WHILE LEX DO <<
    MAPRINT (LIST ('RDR, TNSR, MYCAAR (LEX)), 0);  % print the object and index
    PRIN2!* (" = ");
    MAPRINT (MK!*SQ (MULTSQ (GET (TNSR, 'MULTIPLIER), MYCDAR (LEX))), 0);    
    LEX := MYCDR (LEX);
    TERPRI!* ('T)
  >>;
  RETURN (TNSR);
END;

% dispf2 is the other function for displaying the contents of
% indexed objects (in format '2'). it calls igen to generate all
% possible indices for the object and reads to find the values. 
% unless nero is set zeroes are printed as well (unlike dispf1,
% which never sees a zero unless the object is implicit).

SYMBOLIC PROCEDURE DISPF2 (TNSR, INDEX);
BEGIN SCALAR LIS, LEX;
  IPROP!* (TNSR, NOT !*IPROP);   % print the property list
  LIS := IGEN (INDEX, GET (TNSR, 'CONCOV), GET (TNSR, 'SYMMETRY));
  WHILE LIS DO <<
    LEX := READTNSR (TNSR, MYCAR (LIS)); % read the value
    IF NOT !*NERO OR (!*NERO AND NOT (LEX = '(NIL . 1))) THEN <<
      MAPRINT (LIST ('RDR, TNSR, MYCAR (LIS)), 0);
      PRIN2!* (" = "); 
      MAPRINT (MK!*SQ (LEX), 0);
      TERPRI!* ('T)
    >>;
    LIS := MYCDR (LIS)
  >>;
  RETURN (LIST ('RDR, TNSR, INDEX)); % return a valid indexed object
END;

SYMBOLIC SETQ (!*IPROP, 'T); % user flag to suppress iprop.

GLOBAL '(IPROP!*!*);  % stuff for iprop to print.
SYMBOLIC SETQ (IPROP!*!*, '(PNAME IMPLICIT INDEXED COORDS INDICES CONCOV
           MULTIPLIER TYPE SYMMETRY CONJUGATE !*AT!* !#DBR));

PUT ('IPROP, 'SIMPFN, 'IPRP!*);

% iprp* sets up a user call to iprop* (note spelling)

SYMBOLIC PROCEDURE IPRP!* (U);
<<
  IPROP!* (MYCAR (U), 'NIL);
  MYCAR (U) . 1
>>;

% iprop* prints out the properties of an indexed object as specified
% by the iprop** list.

SYMBOLIC PROCEDURE IPROP!* (TNSR, FLG);
BEGIN SCALAR LEX, LEX1;
  IF FLG THEN RETURN ();  
  LEX := IPROP!*!*;
  WHILE LEX DO <<
    IF LEX1 := GET (TNSR, MYCAR (LEX)) THEN <<
      WRITE (MYCAR (LEX), ":");
      SPACES (20 - FLATSIZE2 (MYCAR (LEX)));  % tab over
      WRITE (LEX1);
      TERPRI!* ('T)
    >>;
    LEX := MYCDR (LEX)
  >>;
  TERPRI!* ('T);
END;

PUT ('RDR, 'SIMPFN, 'SIMPRDR);  % simplification properties

FLAG ('(RDR QRDR), 'FULL);

PUT ('RDR, 'INFIX, 31);

PUT ('QRDR, 'SIMPFN, 'SIMPRDR); % for 'quoted' indexed objects

% printrdr is the function the system asks to print indexed objects.
% it does some setting up and then calls either rdrp or rdr1 to do the
% actual output in 'pretty' or 'not pretty' format, respectively.

SYMBOLIC PROCEDURE PRINTRDR (U);
BEGIN SCALAR PNAME, TNSR, INDEX, CONCOV, I, SYMLST, CFLG;
  TNSR := MYCAR (U);
  CFLG := MYCDR (GET (TNSR, 'CONJUGATE)); % need bar if its conjugate.
  INDEX := MYCADR (U);
  CONCOV := GET (TNSR, 'CONCOV);
  SYMLST := MYCADDR (U);
  PNAME := GET (TNSR, 'PNAME) OR TNSR;  % print name of object
  I := MYCAR (FDERIV (INDEX));    	% look for deriv operator.
  IF (NOT CONCOV AND NOT INDEXED (TNSR) EQ 'SCALAR) OR NOT !*NAT THEN
        RDR1 (PNAME, INDEX, 1)  	% no concov(!) or nat is off.
  ELSE IF NOT I THEN RDRP (PNAME, INDEX, CONCOV, CFLG)
  ELSE RDRP (PNAME, INDEX, APPEND (CONCOV,  % has a deriv, add -1's to concov
             CNSTN (-1, LENGTH (INDEX) - I + 1)), CFLG);
%  if there remains a symmetrization list, print it after
%		      % the object using [] or {} as appropriate.
  FOR EACH X IN SYMLST DO RDR1 ('NIL, MYCDR (X), MYCAR (X));
  RETURN ('T);
END;

% rdrp is the pretty printer for indexed objects; it is called by
% printrdr.

SYMBOLIC PROCEDURE RDRP (PNAME, INDEX, CONCOV, CFLG);
BEGIN SCALAR LEX, FLG, I, POSL;

  TESTWIDTH (PNAME, INDEX, CONCOV);  % will it fit on the line?
  IF CFLG THEN <<  	% print a bar over the conjugate
    POSL := POSN!*;
    IF (YCOORD!* := YCOORD!* + 1) > YMAX!* THEN YMAX!* := YCOORD!*;
    FOR I := FLATSIZE2 (PNAME) STEP -1 UNTIL 1 DO PRIN2!* ("_");
    YCOORD!* := YCOORD!* - 1;
    POSN!* := POSL
  >>;
  PRIN2!* (PNAME);	% print the name of the object
  WHILE CONCOV DO <<    % for each indice, print it up or down as specified.
    LEX := MYCAR (CONCOV);
    FLG := 'NIL;    % derivative flag. if true, we just printed a | or || 
                    % so don't leave a space to the indice.
    IF CHECKTYPE (MYCAR (INDEX), '!*AT!*) THEN <<
      INDEX := MYCADAR (INDEX) . MYCDR (INDEX);  % move shifted indices.
      LEX := - LEX
    >>
    ELSE IF MYCAR (FDERIV (INDEX)) = 1 THEN <<  % print derivative operator
      IF MYCAR (INDEX) EQ '!#BR THEN INDEX := "|" . MYCDR (INDEX)
      ELSE INDEX := "||" . MYCDR (INDEX);
      FLG := 'T
    >>;
    YCOORD!* := YCOORD!* + SIGN (LEX);   % set up coordinate for indice
    IF YCOORD!* > YMAX!* THEN YMAX!* := YCOORD!*
    ELSE IF YCOORD!* < YMIN!* THEN YMIN!* := YCOORD!*;
    			% print each index type specially
    IF ABS (LEX) = 5 OR ABS (LEX) = 1 THEN  %  tensor and matrix index
      PRIN2!* (DNNAME (MYCAR (INDEX)))          
    ELSE IF ABS (LEX) = 3 OR ABS (LEX) = 4 THEN <<  % spinor indices
      PRIN2!* (UPNAME (MYCAR (INDEX)));
      IF ABS (LEX) = 4 THEN PRIN2!* ("'")   % primed spinor index
    >>
    ELSE IF ABS (LEX) = 2 THEN <<     % tetrad index
      PRIN2!* ("(");
      PRIN2!* (UPNAME (MYCAR (INDEX)));
      PRIN2!* (")")
    >>;
    INDEX := MYCDR (INDEX);
    IF NOT FLG THEN PRIN2!* (" ");
    YCOORD!* := YCOORD!* - SIGN (LEX);
    CONCOV := MYCDR (CONCOV)
  >>;
END;

% rdr1 prints an indexed object in 'not pretty' form, i.e. much the
% same form that the user types it: name[i1,i2,i3].
% it is also used to print unserviced symmetrization requests, the
% parameter N tells it which set of brackets to use: 1 ==> [],
% -1 ==> {}.

SYMBOLIC PROCEDURE RDR1 (PNAME, EX, N);
BEGIN;
  IF NOT EX THEN RETURN ();
  IF PNAME THEN PRIN2!* (PNAME);
  IF N = 1 THEN PRIN2!* ("[")
  ELSE PRIN2!* ("{");
  LOOP:
    PRIN2!* (MYCAR (EX));
    EX := MYCDR (EX);
    IF NOT EX THEN GO TO AFTERLOOP;
    PRIN2!* (",");  % commas after each indice.
  GO TO LOOP;
  AFTERLOOP:
  IF N = 1 THEN PRIN2!* ("]")
  ELSE PRIN2!* ("}");
END;

% testwidth determines the print width of an indexed object and
% forces a newline if it won't fit on whats left of the current line.

SYMBOLIC PROCEDURE TESTWIDTH (PNAME, INDEX, CONCOV);
BEGIN SCALAR WID, LEX;
      % count print length of name and each indice.
  WID := FLATSIZE2 (PNAME) + FLATSIZE2 (INDH (INDEX));
  WHILE INDEX DO <<  % count other special chars used by rdrp, and spaces.
    LEX := ABS (MYCAR (CONCOV));
    CONCOV := MYCDR (CONCOV);
    IF LEX = 1 OR LEX = 3 OR LEX = 5 THEN WID := WID + 1 
    ELSE IF LEX = 2 THEN WID := WID + 3
    ELSE WID := WID + 2;
    IF MYCAR (INDEX) EQ '!#BR THEN WID := WID - 3  % these guys print smaller
    ELSE IF MYCAR (INDEX) EQ '!#DBR THEN WID := WID - 4;
    INDEX := MYCDR (INDEX)
  >>;
  IF WID > (LINELENGTH (NIL) - 10 - POSN!*) THEN TERPRI!* ('T);
END;

% dncase shifts an upper case character to lower case.

SYMBOLIC PROCEDURE DNCASE (EX);
BEGIN SCALAR LEX;
  LEX := MASCII (EX);
  IF LEX > 90 OR LEX < 65 THEN RETURN (EX)
  ELSE RETURN (MASCII (LEX + 32));
END;

% upcase shifts a lower case character to upper case.

SYMBOLIC PROCEDURE UPCASE (EX);
BEGIN SCALAR LEX;
  LEX := MASCII (EX);
  IF LEX > 123 OR LEX < 97 THEN RETURN (EX)
  ELSE RETURN (MASCII (LEX - 32));
END;

% dnname shifts an entire name to lower case.

SYMBOLIC PROCEDURE DNNAME (EX);
  IF NOT IDP (EX) THEN EX
  ELSE MAKENAME (MAPCAR (EXPLODE (EX), 'DNCASE));

% upname shifts an entire name to upper case.

SYMBOLIC PROCEDURE UPNAME (EX);
  IF NOT IDP (EX) THEN EX
  ELSE MAKENAME (MAPCAR (EXPLODE (EX), 'UPCASE));


FLAG ('(MCLEAR), 'OPFN);  % make it directly callable

% mclear is used to clean up the flags in case an error has left them
% in a peculiar state. 

SYMBOLIC PROCEDURE MCLEAR;
<<
  READFLG!* := 'NIL;
  PARSEFLAG!* := 'NIL;
  SYMLST!* := 'NIL;
  LINELENGTH (80)
>>;

;END;
