(*^

::[paletteColors = 128; 
	fontset = title, "Geneva", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Geneva", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Geneva", 14, L2, center, bold, nohscroll;
	fontset = section, "Geneva", 14, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Geneva", 12, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Geneva", 10, L2, bold, nohscroll, whiteBox;
	fontset = text, "Geneva", 12, L2, nohscroll;
	fontset = smalltext, "Geneva", 10, L2, nohscroll;
	fontset = input, "Courier", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R65535, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Geneva", 10, L2, italic, B65535, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Geneva", 10, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "New York", 12, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Arithmetic with Mathematical Constants
:[font = text; inactive; ]
This example comes from subsection 7.1.5
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

;[s]
3:0,0;67,1;93,0;470,-1;
2:2,14,10,Geneva,0,10,0,0,0;1,14,10,Geneva,2,10,0,0,0;
:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
Examples of Use
:[font = text; inactive; ]
After loading this package, expressions involving mathematical constants and approximate numbers are evaluated numerically.
:[font = input; ]
1.0 + Pi
:[font = input; endGroup; ]
1.0 EulerGamma
:[font = subsection; inactive; startGroup; Cclosed; ]
Caveat
:[font = text; inactive; ]
The accuracy of 0.0 on input is quite large. This causes the constants to be evaluated to high accuracy.
:[font = input; endGroup; endGroup; ]
0.0 + GoldenRatio
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)

BeginPackage["RMPackages`Constants`"]
(*
:[font = input; initialization; ]
*)
Constants::usage = "Constants.m defines rules for approximate arithmetic with the
	mathematical constants Pi, Degree, GoldenRatio, E, EulerGamma and Catalan."
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
constantList = {Pi, Degree, GoldenRatio, E, EulerGamma, Catalan}
(*
:[font = input; initialization; ]
*)
protected = Unprotect[Release[constantList]]
(*
:[font = input; initialization; ]
*)
DefineRules[const_Symbol] := (
	const/: const + r_ := N[const, Accuracy[r]] + r /; Accuracy[r] < Infinity;
	const/: const * r_ := N[const, Precision[r]] * r /; Precision[r] < Infinity;
	const/: const ^ r_ := N[const, Precision[r]] ^ r /; Precision[r] < Infinity
	)
(*
:[font = input; initialization; ]
*)
DefineRules /@ constantList
(*
:[font = input; initialization; ]
*)
Protect[Release[protected]]
(*
:[font = input; initialization; ]
*)
End[]
(*
:[font = input; initialization; endGroup; ]
*)
EndPackage[]
(*
^*)