
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)msg.c	1.6	NCSA	9/8/87";
#endif lint

/*
** routines to display useful information
*/

#include <errno.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <sunwindow/notify.h>

extern struct pixfont *bold;

/*
** errmsg -- put up a box with an error and wait for an ok click
*/

int errmsg(e1, e2)
char *e1, *e2;
{
	char buffer[256];

	if (e2 != (char *)0)
		(void) sprintf(buffer, e1, e2);
	else
		(void) sprintf(buffer, e1);

	confirm(buffer, TRUE);
}

/*
** just print a normal message and wait for ok
*/

int msg(e1,e2)
char *e1,e2;
{
	errmsg(e1,e2);
}

/*
** print a UNIX system error
*/

syserr(e1)
char *e1;
{
	extern char *sys_errlist[];
	extern int errno;
	char buffer[256];

	(void)sprintf(buffer,"%s: %s",e1, sys_errlist[errno]);
	errmsg(buffer,(char *) 0);
}

extern Pixwin *pw;
static Frame init_msgbox();
static Frame msgbox;

nowait(e1,e2)
char *e1, *e2;
{
	int   answer;
	char message[256];

	(void)sprintf(message,e1,e2);
	msgbox=init_msgbox(message);
	return;
}

destroy_msg()
{

	window_set(msgbox,FRAME_NO_CONFIRM,TRUE,0);
	window_destroy(msgbox);
 
}

static Frame
init_msgbox(message)
char *message;
{
	Frame msgbox;
	Panel panel;
	Panel_item message_item;
	int left,top,width,height,okleft,pixnum;
	Rect *r;
	Rect rr;
	extern Frame base_frame;
	struct pixrect *pr;
	Pixwin *msgpw;

	msgbox=window_create(0,FRAME,FRAME_SHOW_LABEL,FALSE,0); /* create base frame */
	panel=window_create(msgbox,PANEL,PANEL_LABEL_BOLD,TRUE,0);   /* create single panel */
	msgpw=(Pixwin *)window_get(panel,WIN_PIXWIN); /* get panel's pixwin */
	message_item=panel_create_item(panel,PANEL_MESSAGE,
	                               PANEL_LABEL_STRING,message,
								   PANEL_SHOW_ITEM,TRUE,
								   0);
	window_fit(panel);
	window_fit(msgbox);
	window_set(msgbox,WIN_SHOW,TRUE,0);
	/* center msgbox on screen  */
	win_getsize(window_get(base_frame, WIN_FD), &rr);
	width=(int)window_get(msgbox,WIN_WIDTH);
	height=(int)window_get(msgbox,WIN_HEIGHT);
	left=(rr.r_width -width)/2;
	top=(rr.r_height-height)/2;
	if (left<0) left=0;
	if (top<0) top=0;

	left += (int) window_get(base_frame, WIN_X);
	top += (int) window_get(base_frame, WIN_Y);

	window_set(msgbox,WIN_X,left,WIN_Y,top,0);
	notify_post_event(msgbox,WIN_REPAINT,NOTIFY_IMMEDIATE);
	notify_dispatch();
	return(msgbox);

}
