#ifndef lint
static char *SCCSid = "@(#)rrsun.c	1.2	(NCSA)	9/27/87";
#endif lint

#include <stdio.h>
#include <sys/file.h>
#include "vrfile.h"
#include "rr.h"
#include "vr.h"

/*
** Low level raster routines for the Sun under SunView
*/

/*
** RRwindow -- create a window on the screen
**
** Arguments:
**
**	VRW *w;	-- pointer to the window
**
** Returns:
**
**	int -- 1 if successful, 0 if failure
**
*/

#define	RASTERLABEL	"Raster Window - "

int RRwindow(w)
VRW *w;
{

	char	tbuf[256];
	char	*strcpy();
	char	*strcat();

	/*
	** make a nice label for the nice user
	*/

	(void)strcpy(tbuf, RASTERLABEL);
	(void)strcat(tbuf, w->w_name);

	/*
	** call SunView, open the frame thing
	*/

	w->w_rr.r_frame = window_create(0, FRAME,
		WIN_SHOW, TRUE,
		WIN_X, w->w_left,
		WIN_Y, w->w_top,
		WIN_WIDTH, w->w_width,
		WIN_HEIGHT, w->w_height,
		FRAME_LABEL, tbuf,
		0);

	if (w->w_rr.r_frame == (Frame)0)
		return 0;

	/*
	** now we need a canvas
	*/

	w->w_rr.r_canvas = window_create(w->w_rr.r_frame, CANVAS,
		CANVAS_WIDTH, w->w_width,
		CANVAS_HEIGHT, w->w_height,
		CANVAS_RETAINED, FALSE,
		CANVAS_AUTO_CLEAR, FALSE,
		0);

	/*
	** save the pixwin for later, we'll need to rop into it and use
	** it to change colormaps
	*/

	w->w_rr.r_pixwin = canvas_pixwin(w->w_rr.r_canvas);

	/*
	** assign the colormap name for later use
	*/

	pw_setcmsname(w->w_rr.r_pixwin, w->w_name);
	w->w_rr.r_cmsize = 2;		/* I believe that this is the default cm size */

	/*
	** set canvas to usable mode
	*/

	window_set(w->w_rr.r_canvas,
		CANVAS_RETAINED, TRUE,
		CANVAS_FIXED_IMAGE, FALSE,
		CANVAS_AUTO_CLEAR, TRUE,
		0);

	return 1;
}

/*
** RRdestroy -- destroy a window
**
** Arguments:
**
**	VRW *w;	-- pointer to window structure
**
** Returns:
**
**	int;	-- 0 if failure, 1 if success
**
*/

int RRdestroy(w)
VRW *w;
{

	/*
	** well, if window_destroy returns a status, I don't know about it...
	*/

	(void)window_destroy(w->w_rr.r_frame);
	return 1;
}

/*
** RRmap -- change the colormap of a window
**
** Arguments:
**
**	VRW		*w;		-- pointer to window structure
**	int		s;		-- start point
**	int		n;		-- number of entries
**	int		c;		-- count of data, currently unused but left as placeholder
**	char	*data;	-- data for map entries
**
**	Returns:
**
**	int;			-- 1 if success, 0 if failure
**		
*/

int RRmap(w, s, n, c, data)
VRW		*w;
int		s;
int		n;
int		c;
char	*data;
/* ARGSUSED */
{

	u_char	red[256];
	u_char	green[256];
	u_char	blue[256];
	int		i;
	char	*d = data;

	/*
	** set up colormap arrays
	*/

	for (i = s; i < s + n; i++) {

		red[i] = *d;
		green[i] = d[1];
		blue[i] = d[2];

		d += 3;		/* R + G + B == 3 */

	}

	/*
	** set canvas to non-retained and so forth
	** Why do I do this, you ask?
	** see page 69, section 5.8, SunView Programmer's Guide
	** "Color in Canvases"
	*/

	window_set(w->w_rr.r_canvas,
		CANVAS_RETAINED, FALSE,
		CANVAS_AUTO_CLEAR, FALSE,
		0);

	/*
	** set colormap
	*/

	pw_setcmsname(w->w_rr.r_pixwin, w->w_name);
	pw_putcolormap(w->w_rr.r_pixwin, s, n, red, green, blue);
	w->w_rr.r_cmsize = n - s;

	/*
	** determine depth of pixrect based on size of colormap
	** pixrects are only supported in 1, 8, 16, and 24.  We
	** will only worry about 1 and 8 for now.  This is not
	** my fault, but it makes my life easier.
	*/

	w->w_rr.r_depth = (w->w_rr.r_cmsize > 2) ? 8 : 1;

	/*
	** reset canvas modes
	*/

	window_set(w->w_rr.r_canvas,
		CANVAS_RETAINED, TRUE,
		CANVAS_AUTO_CLEAR, TRUE,
		0);

	return 1;
}

/*
** RRpixel	-- ROP's a line of raster data on to the Canvas
**
** Arguments:
**
**	VRW		*w;			-- the window to use
**	int		x;			-- x-position
**	int		y;			-- y-position
**	int		c;			-- count of data
**	char	*data;		-- pointer to data
**
** Returns:
**
**	int;	-- Always Returns 1 until error checking is added
**
*/

int RRpixel(w, x, y, c, data)
VRW		*w;
int		x;
int		y;
int		c;
char	*data;
{
	Pixwin			*p = w->w_rr.r_pixwin;
	extern Pixrect	*mem_point();
	Pixrect			*pr;

	if (w->w_rr.r_depth == 1)
		c *= 8;

	/*
	** make a pixrect point at our data -- it's c wide by 1 tall
	*/

	pr = mem_point(c, 1, w->w_rr.r_depth, data);

	if (pr == (Pixrect *)0)
		return 0;

	/*
	** now rop the pixrect onto the pixwin
	*/

	pw_rop(p, x, y, c, 1, PIX_SRC, pr, 0, 0);

	return 1;
}

/*
** RRfile		-- dump a window region to a file
**
** Arguments:
**
**	VRW		*w;		-- pointer to window structure
**	int		left;	-- left edge of region
**	int		top;	-- top of region
**	int		width;	-- width of region
**	int		height;	-- height of region
**	int		format;	-- file format -- 1 == Sun_Raster, 2 == Sun_RLE, 3 == NCSA
**					-- 0 defaults to NCSA Raw Binary
**	char	*name;	-- file name
*/

int RRfile(w, left, top, width, height, format, name)
VRW		*w;
int		left;
int		top;
int		width;
int		height;
int		format;
char	*name;
{

	Pixrect			*tpr;
	Pixrect			*mem_create();
	struct mpr_data	*tpr_d;
	colormap_t		cm;
	FILE			*pout;					/* used for SUN RLE, STANDARD */
	int				pf;						/* used for NCSARAW */
	int				pmode = RT_BYTE_ENCODED;
	u_char			red[256];
	u_char			green[256];
	u_char			blue[256];

	/*
	** see what we've got
	*/

	switch (format) {

		/*
		** Sun standard Raster is same as Sun RLE except for flag on
		** pr_dump
		*/

		case RF_SUNRAS:
			pmode = RT_STANDARD;

		case RF_SUNRLE:

			/*
			** make a place to store the data
			*/

			if ((tpr = mem_create(width, height, w->w_rr.r_depth)) == 
				(Pixrect *)0)
				return 0;

			/*
			** grab the data
			*/

			(void)pw_read(tpr, left, top, width, height, PIX_SRC,
				w->w_rr.r_pixwin, 0, 0);

			/*
			** grab the colormap thing
			*/

			(void)pw_getcolormap(w->w_rr.r_pixwin, 0, w->w_rr.r_cmsize, 
				red, green, blue);

			cm.map[0] = red;
			cm.map[1] = green;
			cm.map[2] = blue;
			cm.type = RMT_EQUAL_RGB;
			cm.length = w->w_rr.r_cmsize;

			/*
			** open the output file
			*/

			pout = fopen(name, "w");
			if (pout == (FILE *)0)
				return 0;

			/*
			** dump the pixrect -- copyflag must be 1 if RLE, 0 is ok
			** otherwise, I think...
			*/

			if (pr_dump(tpr, pout, &cm, pmode, (pmode == RT_STANDARD) ? 0 : 1)
				!= 0) {
				(void)fclose(pout);
				return 0;
			}

			/*
			** All went well
			*/

			(void)fclose(pout);
			return 1;

		/*
		** best guess is NCSARAW, at least for now
		*/

		case RF_GUESS:
		case RF_NCSARAW:

			/*
			** create a place to hold the data
			*/

			if ((tpr = mem_create(width, height, w->w_rr.r_depth)) == 
				(Pixrect *)0)
				return 0;

			/*
			** access the pixrect data area
			*/

			tpr_d = mpr_d(tpr);

			/*
			** grab the data
			*/

			(void)pw_read(tpr, left, top, width, height, PIX_SRC,
				w->w_rr.r_pixwin, 0, 0);

			/*
			** open the file
			*/

			pf = open(name, O_CREAT | O_WRONLY, 0664);
			if (pf < 0)
				return 0;

			/*
			** write out the data
			*/

			if (write(pf, (char *)tpr_d->md_image, width * height) < 0)
				return 0;

			(void)close(pf);

			return 1;

		/*
		** I don't know what to do with anything else
		*/

		default:
			return 0;
	}
}

/*
** RRmsave	-- saves a color map to a file
**
** Arguments:
**
**	VRW		*w;		-- window structure pointer
**	char	*name;	-- file name to save to
**
** Returns:
**
**	int;			-- 1 if success, 0 if failure
**
*/

int RRmsave(w, name)
VRW		*w;
char	*name;
{
	int		mf;
	u_char	r[256];
	u_char	g[256];
	u_char	b[256];

	/*
	** retrieve the colormap
	*/

	(void)pw_getcolormap(w->w_rr.r_pixwin, 0, w->w_rr.r_cmsize, r, g, b);

	/*
	** open the file
	*/

	mf = open(name, O_WRONLY | O_CREAT, 0664);
	if (mf < 0)
		return 0;

	/*
	** attempt to write the data
	*/

	if (write(mf,(char *)r,256) != 256)
		return 0;
	if (write(mf,(char *)g,256) != 256)
		return 0;
	if (write(mf,(char *)b,256) != 256)
		return 0;

	/*
	** now close and go home
	*/

	(void)close(mf);
	return 1;

}

/*
** for later
*/

int RRrle(w, x, y, c, data)
VRW		*w;
int		x;
int		y;
int		c;
char	*data;
/* ARGSUSED */
{
	return 0;
}

int RRclick(w)
VRW	*w;
/* ARGSUSED */
{
	return 0;
}

