
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)rgpio.c	1.4	NCSA	8/12/87";
#endif lint

#include <stdio.h>

/*
** routines to support the postscript device
*/

static FILE *psout;
static int	oflag = -1;

/*
** open the postscript device
*/

open_ps()
{
	extern char psfname[];
	char		*psfile = psfname;
	int			write_ps();

	if (*psfile == '|') {
		psout = popen(++psfile, "w");
		oflag = 1;
	}
	else {
		psout = fopen(psfile,"w");
		oflag = 0;
	}

	if (psout == NULL)
		return -1;

	RGPoutfunc(write_ps);
}

/*
** close the postscript device
*/

close_ps()
{

	if (oflag)
		pclose(psout);
	else
		fclose(psout);
	
	oflag = -1;
}

/*
** write on the postscript device
*/

write_ps(s)
char *s;
{
	while (*s != '\0')
		fputc(*s++, psout);
}
