
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)parse.c	1.13	NCSA	9/27/87";
#endif lint

/*
*    LOOK.C
*    User interface code for NCSA Telnet
****************************************************************************
*                                                                          *
*      part of:                                                            *
*      TCP/IP kernel for NCSA Telnet                                       *
*      by Tim Krauskopf                                                    *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
*    Copyright (c) 1987, Board of Trustees of the University of Illinois   *
*                                                                          *
****************************************************************************
*
*/

#include <sys/types.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>

#include <stdio.h>
#include <fcntl.h>
#include "defs.h"
#include "session.h"

/*********************************************************************/
/*  parse
*   look at the string which has just come in from outside and
*   check for special sequences that we are interested in.
*
*   Tries to pass through routine strings immediately, waiting for special
*   characters ESC and 255 to change modes.
*/

#define STNORM	0
#define GOAHEAD 249
#define WILLTEL 251
#define WONTTEL 252
#define DOTEL	253
#define DONTTEL 254
#define ESCFOUND 5
#define IACFOUND 6

char parsedat[500];

parse(tw,st,cnt)
	struct session *tw;
	int cnt;
	unsigned char *st;


	{
	int i,cv;
	unsigned char *mark,*orig;

	orig = st;				/* remember beginning point */
	mark = st + cnt;		/* set to end of input string */

/*
*  traverse string, looking for any special characters which indicate that
*  we need to change modes.
*/
	while (st < mark) {

		switch (tw->s_telstate) {
			case ESCFOUND:
				if (*st == 12) {
					if (tw->s_termstate != TEKTYPE) {
						int t;

						debug(5,"Entering Tek Mode \r\n");

						t = VGnewwin(1);		/* this must change 
												   if we want a new device */

						if (t < 0)
							errmsg("Too many TEK windows","");
						else {
							tw->s_tekwin = t;
							tw->s_termstate = TEKTYPE;
						}
					}
					if (tw->s_termstate == TEKTYPE)
						VGwrite(tw->s_tekwin,"\033\014",2);
					orig = ++st;	/* skip ESC-FF in stream */
					tw->s_telstate = STNORM;
					break;
				}
/*
*  check for raster protocol 
*/
				if (*st == '^') {
					tw->s_termstate = RASTYPE;
					tw->s_telstate = STNORM;
					VRwrite("\033^",2);		/* echo ESC ^ */
					orig = ++st;
					break;
				}
				parsewrite(tw,"\033",1);
				orig = ++st;
				tw->s_telstate = STNORM;
				break;
			case IACFOUND: 		/* telnet option negotiation */
				if (*st == 255) {		/* real data = 255 */
					st++;				/* real 255 will get sent */
					tw->s_telstate = STNORM;
					break;
				}
				if ( 248 < *st ) {
					tw->s_telstate = *st;		/* by what the option is */
					st++;
					break;
				}
				debug(1,"\n\r strange telnet option\r\n");
				orig = st;
				tw->s_telstate = STNORM;
				break;
			case GOAHEAD:
				tw->s_telstate = STNORM;
				orig = st;
				break;
			case DOTEL:
				sprintf(parsedat," telnet option %d %d\r\n",tw->s_telstate,*st);
				debug(1,parsedat);
				if (*st != 3) {			/* anything but suppress go-ahead */
					sprintf(parsedat,"%c%c%c",255,WONTTEL,*st++);
					netwrite(tw->s_winval,parsedat,3);	/* refuse it */
				}
				tw->s_telstate = STNORM;
				orig = st;
				break;
			case DONTTEL:
				sprintf(parsedat," telnet option %d %d\r\n",tw->s_telstate,
						*st++);
				debug(1,parsedat);
				tw->s_telstate = STNORM;
				orig = st;
				break;
			case WILLTEL:
				sprintf(parsedat," telnet option %d %d\r\n",tw->s_telstate,*st);
				debug(1,parsedat);
				tw->s_telstate = STNORM;
				switch(*st++) {
					case 3:				/* suppress go-ahead */
						break;
					case 1:				/* echo */
						tw->s_echo = 1;
						netwrite(tw->s_winval,tw->s_linemode,strlen(tw->s_linemode));
						tw->s_linemode[0] = '\0';
#ifdef OLDM
						if (tw->s_echo)
							break;
					/*	else {
							 tw->s_echo = 1;  add if you want to change */
						/* currently fall-through */
#endif
						break;
					default:
						sprintf(parsedat,"%c%c%c",255,DONTTEL,*(st-1));
						netwrite(tw->s_winval,parsedat,3);	/* refuse it */
				}
				orig = st;
				break;
							
			case WONTTEL:
				sprintf(parsedat," telnet option %d %d\r\n",tw->s_telstate,*st);
				debug(1,parsedat);
				tw->s_telstate = STNORM;
				switch(*st++) {			/* which option? */
					case 1:				/* echo */
						tw->s_echo = 0;
						break;
					default:
						break;
				}
				orig = st;
				break;
			default:
				tw->s_telstate = STNORM;
				break;
		}

/*
* quick scan of the remaining string, skip chars while they are
* uninteresting
*/
		if (tw->s_telstate == STNORM) {
/*
*  skip along as fast as possible until an interesting character is found
*/
			while (st < mark && *st != 27 && *st < 128) {
				if (!tw->s_telbinary)
					*st &= 127;
				st++;
			}
/*
*  send the string where it belongs
*/
			parsewrite(tw, orig, st - orig);

			orig = st;				/* forget what we have sent already */

			if (st < mark)
			switch (*st) {
				case 255:			/* telnet IAC */
					tw->s_telstate = IACFOUND;
					st++;
					break;

				case 27:			/* ESCape code */
					if (st == mark-1 || *(st+1) == 12 || *(st+1) == '^') {
						tw->s_telstate = ESCFOUND;
					}
					st++;			/* strip or accept ESC char */
			
					break;

				default:
					debug(1," strange char > 128\r\n");
					st++;
					break;
			}

		}

	}  /* end while */

			
}
