
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)cursor.c	1.3	NCSA	7/22/87";
#endif lint

/*
** routines to manipulate the cursor
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <sunwindow/pixwin.h>
#include <pixrect/pixrect.h>

static short    hg_data[] = {
#include <images/hglass.cursor>
};

mpr_static(tt_hourglass_cursor_pr, 16, 16, 1, hg_data);
struct cursor    tt_hourglass_cursor = 
	{ 8, 8, PIX_SRC | PIX_DST, &tt_hourglass_cursor_pr };

/*
** hourglasss
*/

hourglasscursor(w)
Window w;
{

	window_set(w, WIN_CURSOR, &tt_hourglass_cursor, 0);

}

/*
** normal
*/

static short    nc_data[16]  =  {
        0x8000,0xC000,0xE000,0xF000,0xF800,0xFC00,0xFE00,0xF000,
        0xD800,0x9800,0x0C00,0x0C00,0x0600,0x0600,0x0300,0x0300
};

mpr_static(tt_normal_cursor_pr, 16, 16, 1, nc_data);
struct cursor    tt_normal_cursor  =  
	{ 0, 0, PIX_SRC | PIX_DST, &tt_normal_cursor_pr};
 

normalcursor(w)
Window w;
{

	window_set(w, WIN_CURSOR, &tt_normal_cursor, 0);
}
