/************************************************************ 
*
* Example program: Read in slices from a 10 x 12 SDS
*
* Input file:  named by user on command line
* Output file: none (output is printed to the console)
*
************************************************************ */

#include <stdio.h>
#include "df.h"
#define ROWS  10
#define COLS  12
#define TRUE   1
#define FALSE  0

char *malloc();

main(argc,argv)
int argc;
char *argv[];
{
    int  i, rank;
	int dimsizes[2];
    float data[ROWS][COLS];
	
    if (argc != 2) {
        printf("Usage: %s infile\n", argv[0]);
        exit(1);
    }

    DFSDgetdims(argv[1], &rank, dimsizes, 3);

/**/printf("rank=%d, dimsizes=%d & %d\n",rank,dimsizes[0],dimsizes[1]);
    /* read in two slices  */

    printf("\n\nReads in two slices from a scientific dataset.\n\n");
    printf("First slice: 4x6 array starting at (3,4):\n");
    getit(argv[1], 3,4,4,6, data,dimsizes);
    printf("\n\nSecond slice: 10x2 array starting at (1,10):\n");
    getit(argv[1], 1,10,10,2,data,dimsizes);
    printf("\n");

}

getit(filename, st0, st1, rows, cols, data, dimsizes)
int st0, st1, rows, cols, dimsizes[2];
float *data;
char *filename;
{
    int i, j, ret, winst[2], windims[2];

    winst[0]=st0; winst[1]=st1;
    dimsizes[0] = windims[0] = rows; 
    dimsizes[1] = windims[1] = cols;
/**/printf("winst=%d & %d\nwindims=%d & %d\n",
                                     winst[0],winst[1],windims[0],windims[1]);
    ret = DFSDgetslice(filename, winst, windims, data, dimsizes);
    if (ret != 0) {
        printf("\nError calling DFSDgetslice.\n");
        printf("ret = %d;  DFerror = %d\n\n", ret, DFerror);
    }    
    for (i=0; i<rows; i++)  {
        printf("\n  ");
        for (j=0; j<cols; j++)
	        printf("%5.0f%c",data[i*cols+j], ' ');
    }
    printf("\n");
}











