      program threeRIS
C
C Illustrates reading three RISs from three files and outputting them
C to one filei.  A palette is also read from a file and associated 
C with all of the images..
C
C Input files:  storm110.hdf,storm120.hdf, storm130.hdf (in "files" directory)
C               grey.pal (HDF file containing a palette)
C Output file: 3storm.hdf
C
      character*1 image1(256,256), image2(256,256), image3(256,256)
      character*1 pal(768)
      integer xdim(3), ydim(3)
      integer DFTAG_RLE
      integer d8spal, dpgpal
      integer d8pimg, d8aimg, d8gdims, d8gimg
      integer ret, ispal

      DATA DFTAG_RLE/11/

      write(*,*) 'xdim, ydim, ispal, ret:'

      ret = d8gdims('storm110.hdf', xdim(1), ydim(1), ispal)
      write(*,*) xdim(1), ydim(1), ispal, ret
      ret = d8gimg('storm110.hdf', image1, xdim(1), ydim(1), pal)

      ret = d8gdims('storm120.hdf', xdim(2), ydim(2), ispal)
      write(*,*) xdim(2), ydim(2), ispal, ret
      ret = d8gimg('storm120.hdf', image2, xdim(2), ydim(2), pal)

      ret = d8gdims('storm130.hdf', xdim(3), ydim(3), ispal)
      write(*,*) xdim(3), ydim(3), ispal, ret
      ret = d8gimg('storm130.hdf', image3, xdim(3), ydim(3), pal)

      ret = dpgpal('grey.pal', pal)


C     :
C     :

      write(*,*) 'Now writing out first image.  No compression.'
      ret = d8spal(pal)
      ret = d8pimg('3storm.hdf', image1, xdim(1), ydim(1), 0)

      write(*,*) '   Second image. RLE compression.'
      ret = d8aimg('3storm.hdf', image2,
     &                    xdim(2), ydim(2), DFTAG_RLE)
      write(*,*) '      Third image.  No compression.'
      ret = d8aimg('3storm.hdf', image3, xdim(3), ydim(3), 0)

C     :

      stop
      end




